/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.BetterPhysics;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitBetterPhysics
extends BetterPhysics
implements Listener {
    public BukkitBetterPhysics(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.checkForPhysics(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.checkForPhysics(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockUpdate(BlockPhysicsEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.checkForPhysics(event.getBlock());
    }

    private void checkForPhysics(Block block) {
        if (this.canLadderFall(block)) {
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), (Runnable)new FallingLadders(block));
        }
    }

    public boolean canLadderFall(Block block) {
        return this.ladders && block.getType() == Material.LADDER && block.getRelative(0, -1, 0).getType().isAir();
    }

    private class FallingLadders
    implements Runnable {
        private final Block ladder;

        FallingLadders(Block ladder) {
            this.ladder = ladder;
        }

        @Override
        public void run() {
            if (!BukkitBetterPhysics.this.canLadderFall(this.ladder)) {
                return;
            }
            this.ladder.getWorld().spawn(this.ladder.getLocation().add(0.5, 0.0, 0.5), FallingBlock.class, fallingBlock -> fallingBlock.setBlockData(this.ladder.getBlockData()));
            this.ladder.setType(Material.AIR, false);
            BukkitBetterPhysics.this.checkForPhysics(this.ladder.getRelative(BlockFace.UP));
        }
    }
}

