/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.BetterLeads;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitBetterLeads
extends BetterLeads
implements Listener {
    public BukkitBetterLeads(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerClick(PlayerInteractEntityEvent event) {
        Creature creature;
        LivingEntity entity;
        Entity entity2 = event.getRightClicked();
        if (!(entity2 instanceof LivingEntity) || (entity = (LivingEntity)entity2).isLeashed() || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (event.getPlayer().getInventory().getItem(event.getHand()).getType() != Material.LEAD) {
            return;
        }
        CraftBookPlugin.logDebugMessage("A player has right clicked an entity with a lead!", "betterleads.allowed-mobs");
        String typeName = BukkitAdapter.adapt((EntityType)event.getRightClicked().getType()).id();
        if (typeName == null) {
            return;
        }
        CraftBookPlugin.logDebugMessage("It is of type: " + typeName, "betterleads.allowed-mobs");
        if (!(this.allowedMobs.contains(typeName) || typeName.startsWith("minecraft:") && this.allowedMobs.contains(typeName.substring("minecraft:".length())))) {
            return;
        }
        CraftBookPlugin.logDebugMessage(typeName + " is allowed in the configuration.", "betterleads.allowed-mobs");
        if (!player.hasPermission("craftbook.betterleads.leash") && !player.hasPermission("craftbook.betterleads.leash." + typeName.replace(":", "."))) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        CraftBookPlugin.logDebugMessage("Leashing entity!", "betterleads.allowed-mobs");
        Entity entity3 = event.getRightClicked();
        if (entity3 instanceof Creature && (creature = (Creature)entity3).getTarget() != null && creature.getTarget().equals((Object)event.getPlayer())) {
            creature.setTarget(null);
        }
        event.setCancelled(true);
        Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> {
            if (!entity.setLeashHolder((Entity)event.getPlayer())) {
                CraftBookPlugin.logDebugMessage("Failed to leash entity!", "betterleads.allowed-mobs");
                return;
            }
            if (event.getPlayer().getGameMode() == GameMode.CREATIVE) {
                return;
            }
            event.getPlayer().getInventory().getItem(event.getHand()).subtract(1);
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityTarget(EntityTargetEvent event) {
        Monster monster;
        block7: {
            block6: {
                Entity entity;
                if (!this.stopTargetting && !this.mobRepellant || !((entity = event.getEntity()) instanceof Monster)) break block6;
                monster = (Monster)entity;
                if (event.getTarget() instanceof Player && EventUtil.passesFilter((Event)event)) break block7;
            }
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer((Player)event.getTarget());
        if (this.stopTargetting && player.hasPermission("craftbook.betterleads.ignore-target") && monster.isLeashed() && monster.getLeashHolder() == event.getTarget()) {
            event.setTarget(null);
            event.setCancelled(true);
            return;
        }
        if (this.mobRepellant && player.hasPermission("craftbook.betterleads.repel-mobs")) {
            for (Entity ent : event.getTarget().getNearbyEntities(10.0, 10.0, 10.0)) {
                if (ent == null || !ent.isValid() || ent.getType() != event.getEntity().getType() || !monster.isLeashed() || monster.getLeashHolder() != event.getTarget()) continue;
                event.setTarget(null);
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHitchBreak(HangingBreakByEntityEvent event) {
        if (!this.persistentHitch && !this.ownerBreakOnly) {
            return;
        }
        if (!(event.getEntity() instanceof LeashHitch)) {
            return;
        }
        if (!(event.getRemover() instanceof Player)) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        event.setCancelled(true);
        int amountConnected = 0;
        for (Entity ent : event.getEntity().getNearbyEntities(10.0, 10.0, 10.0)) {
            boolean canBreak;
            LivingEntity entity;
            if (!(ent instanceof LivingEntity) || !(entity = (LivingEntity)ent).isLeashed() || entity.getLeashHolder() != event.getEntity()) continue;
            boolean bl = canBreak = !this.ownerBreakOnly || !(ent instanceof Tameable);
            if (!(canBreak || ((Tameable)ent).isTamed() && ((Tameable)ent).getOwner() != event.getRemover())) {
                canBreak = true;
            }
            if (canBreak || event.getRemover().hasPermission("craftbook.betterleads.owner-break.bypass")) {
                entity.setLeashHolder(null);
                event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), new ItemStack(Material.LEAD, 1));
                continue;
            }
            ++amountConnected;
        }
        if (!this.persistentHitch && amountConnected == 0) {
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> ((Hanging)event.getEntity()).remove());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onUnleash(PlayerUnleashEntityEvent event) {
        Tameable entity;
        block6: {
            block5: {
                Entity entity2;
                if (!this.ownerBreakOnly || !((entity2 = event.getEntity()) instanceof Tameable)) break block5;
                entity = (Tameable)entity2;
                if (EventUtil.passesFilter((Event)event)) break block6;
            }
            return;
        }
        if (!(entity.isLeashed() && entity.getLeashHolder() instanceof LeashHitch && entity.isTamed())) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (entity.getOwner() != event.getPlayer() && !player.hasPermission("craftbook.betterleads.owner-break.bypass")) {
            event.setCancelled(true);
        }
    }
}

