/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit;

import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.CartBlockEnterEvent;
import org.enginehub.craftbook.bukkit.events.CartBlockImpactEvent;
import org.enginehub.craftbook.bukkit.events.CartBlockRedstoneEvent;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartMechanismBlocks;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.HistoryHashMap;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.SignUtil;

final class MechanicListenerAdapter
implements Listener {
    private final Map<UUID, Long> signClickTimer = new HistoryHashMap<UUID, Long>(10);

    MechanicListenerAdapter() {
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block;
        if (SignClickEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Action action = null;
        if (event.getAction() == Action.RIGHT_CLICK_AIR) {
            block = event.getPlayer().getTargetBlock(null, 5);
            if (!block.getType().isAir()) {
                action = Action.RIGHT_CLICK_BLOCK;
            }
        } else {
            block = event.getClickedBlock();
            action = event.getAction();
        }
        if (block != null && SignUtil.isSign(block) && event.getHand() == EquipmentSlot.HAND) {
            Vector clickedPosition;
            if (CraftBook.getInstance().getPlatform().getConfiguration().signClickTimeout > 0L) {
                long lastClick = this.signClickTimer.computeIfAbsent(event.getPlayer().getUniqueId(), uuid -> 0L);
                if (lastClick > System.currentTimeMillis() - CraftBook.getInstance().getPlatform().getConfiguration().signClickTimeout) {
                    event.setCancelled(true);
                    return;
                }
                this.signClickTimer.put(event.getPlayer().getUniqueId(), System.currentTimeMillis());
            }
            Location interactionPoint = event.getInteractionPoint();
            Block clickedBlock = event.getClickedBlock();
            Vector vector = clickedPosition = interactionPoint != null && clickedBlock != null ? interactionPoint.subtract(clickedBlock.getLocation()).toVector() : null;
            if (clickedPosition == null) {
                RayTraceResult rayTraceResult = event.getPlayer().rayTraceBlocks(5.0, FluidCollisionMode.NEVER);
                clickedPosition = rayTraceResult != null ? rayTraceResult.getHitPosition() : new Vector(0.5, 0.5, 0.5);
            }
            SignClickEvent ev = new SignClickEvent(event.getPlayer(), action, event.getItem(), block, event.getBlockFace(), event.getHand(), clickedPosition);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)ev);
            if (ev.useInteractedBlock() == Event.Result.DENY) {
                event.setUseInteractedBlock(Event.Result.DENY);
            }
            if (ev.useItemInHand() == Event.Result.DENY) {
                event.setUseItemInHand(Event.Result.DENY);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (SourcedBlockRedstoneEvent.getHandlerList().getRegisteredListeners().length == 0 && CartBlockRedstoneEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        MechanicListenerAdapter.checkBlockChange(event.getBlock(), false);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (SourcedBlockRedstoneEvent.getHandlerList().getRegisteredListeners().length == 0 && CartBlockRedstoneEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        MechanicListenerAdapter.checkBlockChange(event.getBlock(), true);
    }

    private static void checkBlockChange(Block block, boolean build) {
        Material type = block.getType();
        int power = 0;
        if (type == Material.REDSTONE_BLOCK) {
            power = 15;
        } else if (type == Material.REDSTONE_WALL_TORCH || type == Material.REDSTONE_TORCH) {
            Lightable lightable = (Lightable)block.getBlockData();
            if (lightable.isLit()) {
                power = 15;
            }
        } else {
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Powerable) {
                if (((Powerable)blockData).isPowered()) {
                    power = 15;
                }
            } else if (blockData instanceof AnaloguePowerable) {
                power = ((AnaloguePowerable)blockData).getPower();
            }
        }
        if (power != 0) {
            MechanicListenerAdapter.handleRedstoneForBlock(block, build ? 0 : power, build ? power : 0, 0);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        if (SourcedBlockRedstoneEvent.getHandlerList().getRegisteredListeners().length == 0 && CartBlockRedstoneEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        MechanicListenerAdapter.handleRedstoneForBlock(event.getBlock(), event.getOldCurrent(), event.getNewCurrent(), 1);
    }

    private static void handleRedstoneForBlock(Block block, int oldLevel, int newLevel, int depth) {
        boolean wasChange;
        if (depth > 4) {
            return;
        }
        boolean wasOn = oldLevel >= 1;
        boolean isOn = newLevel >= 1;
        boolean bl = wasChange = wasOn != isOn;
        if (!wasChange) {
            return;
        }
        switch (block.getType()) {
            case REDSTONE_WIRE: {
                if (CraftBook.getInstance().getPlatform().getConfiguration().indirectRedstone) {
                    MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.NORTH), block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.SOUTH), block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.EAST), block, oldLevel, newLevel);
                    MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.WEST), block, oldLevel, newLevel);
                } else {
                    RedstoneWire redstoneWire = (RedstoneWire)block.getBlockData();
                    int connectedFaces = 0;
                    for (BlockFace face : redstoneWire.getAllowedFaces()) {
                        if (redstoneWire.getFace(face) == RedstoneWire.Connection.NONE) continue;
                        ++connectedFaces;
                    }
                    for (BlockFace face : redstoneWire.getAllowedFaces()) {
                        RedstoneWire.Connection connection = redstoneWire.getFace(face);
                        if (connection == RedstoneWire.Connection.NONE && connectedFaces != 0 && (connectedFaces != 1 || redstoneWire.getFace(face.getOppositeFace()) == RedstoneWire.Connection.NONE)) continue;
                        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(face), block, oldLevel, newLevel);
                    }
                }
                MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.UP), block, oldLevel, newLevel);
                MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.DOWN), block, oldLevel, newLevel);
                return;
            }
            case REPEATER: 
            case COMPARATOR: 
            case OBSERVER: {
                Directional diode = (Directional)block.getBlockData();
                BlockFace f = diode.getFacing().getOppositeFace();
                Block relativeBlock = block.getRelative(f);
                MechanicListenerAdapter.handleDirectWireInput(relativeBlock, block, oldLevel, newLevel);
                if (relativeBlock.getPistonMoveReaction() != PistonMoveReaction.BREAK) {
                    MechanicListenerAdapter.handleRedstoneForBlock(relativeBlock, oldLevel, newLevel, depth + 1);
                }
                return;
            }
            case ACACIA_BUTTON: 
            case BIRCH_BUTTON: 
            case DARK_OAK_BUTTON: 
            case JUNGLE_BUTTON: 
            case OAK_BUTTON: 
            case SPRUCE_BUTTON: 
            case STONE_BUTTON: 
            case LEVER: {
                Directional button = (Directional)block.getBlockData();
                BlockFace face = button.getFacing().getOppositeFace();
                MechanicListenerAdapter.handleRedstoneForBlock(block.getRelative(face), oldLevel, newLevel, depth + 1);
                break;
            }
            case POWERED_RAIL: 
            case ACTIVATOR_RAIL: {
                return;
            }
        }
        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.WEST), block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.EAST), block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN), block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN), block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.NORTH), block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.SOUTH), block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN), block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN), block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.UP), block, oldLevel, newLevel);
        MechanicListenerAdapter.handleDirectWireInput(block.getRelative(BlockFace.DOWN), block, oldLevel, newLevel);
    }

    private static void handleDirectWireInput(Block block, Block sourceBlock, int oldLevel, int newLevel) {
        if (block.equals((Object)sourceBlock)) {
            return;
        }
        SourcedBlockRedstoneEvent event = new SourcedBlockRedstoneEvent(sourceBlock, block, oldLevel, newLevel);
        CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)event);
        if (CartBlockRedstoneEvent.getHandlerList().getRegisteredListeners().length != 0) {
            Bukkit.getServer().getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> {
                CartMechanismBlocks cmb = CartMechanismBlocks.find(event.getBlock());
                if (cmb == null) {
                    return;
                }
                CartBlockRedstoneEvent ev = new CartBlockRedstoneEvent(event.getBlock(), event.getSource(), event.getOldCurrent(), event.getNewCurrent(), cmb, cmb.findMinecart());
                CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)ev);
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleMove(VehicleMoveEvent event) {
        if (CartBlockImpactEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof Minecart) {
            Minecart cart = (Minecart)vehicle;
            CartMechanismBlocks cmb = CartMechanismBlocks.findByRail(event.getTo().getBlock());
            Location from = event.getFrom();
            Location to = event.getTo();
            if (cmb == null || !LocationUtil.isWithinSphericalRadius(from, to, 2.0)) {
                return;
            }
            boolean minor = from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ();
            CartBlockImpactEvent ev = new CartBlockImpactEvent(cart, from, to, cmb, minor);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)ev);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (CartBlockEnterEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof Minecart) {
            Minecart cart = (Minecart)vehicle;
            Block block = event.getVehicle().getLocation().getBlock();
            CartMechanismBlocks cmb = CartMechanismBlocks.findByRail(block);
            if (cmb == null) {
                return;
            }
            CartBlockEnterEvent ev = new CartBlockEnterEvent(cart, event.getEntered(), cmb);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)ev);
            if (ev.isCancelled()) {
                event.setCancelled(true);
            }
        }
    }
}

