/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit;

import com.google.common.base.Joiner;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.command.CommandUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlatform;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.PlatformCommandManager;
import org.enginehub.craftbook.bukkit.BukkitCraftBookCommandSender;
import org.enginehub.craftbook.bukkit.BukkitCraftBookPlatform;
import org.enginehub.craftbook.bukkit.BukkitCraftBookPlayer;
import org.enginehub.craftbook.bukkit.MechanicListenerAdapter;
import org.enginehub.craftbook.bukkit.bstats.bukkit.Metrics;
import org.enginehub.craftbook.bukkit.bstats.charts.SimpleBarChart;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.companion.CompanionPlugins;
import org.enginehub.craftbook.util.profile.Profile;

public class CraftBookPlugin
extends JavaPlugin {
    public static CompanionPlugins plugins;
    private static CraftBookPlugin instance;
    private static CraftBookPlatform platform;
    private final PlatformCommandManager commandManager = new PlatformCommandManager();
    private MechanicListenerAdapter managerAdapter;
    private static final int BSTATS_ID = 3319;
    private static PrintWriter debugLogger;

    public CraftBookPlugin() {
        instance = this;
    }

    public void createDefaultConfiguration(String name) {
        Path actual = CraftBook.getInstance().getPlatform().getWorkingDirectory().resolve(name);
        if (Files.notExists(actual, new LinkOption[0])) {
            try (InputStream stream = this.getResource("defaults/" + name);){
                if (stream == null) {
                    throw new FileNotFoundException();
                }
                try {
                    Files.copy(stream, actual, new CopyOption[0]);
                    CraftBook.LOGGER.info("Default configuration file written: " + name);
                }
                catch (IOException e) {
                    CraftBook.LOGGER.warn("Failed to write default config file", (Throwable)e);
                }
            }
            catch (IOException e) {
                CraftBook.LOGGER.error("Unable to read default configuration: " + name);
            }
        }
    }

    public void onEnable() {
        this.getDataFolder().mkdirs();
        platform = new BukkitCraftBookPlatform();
        CraftBook.getInstance().setPlatform(platform);
        CraftBook.getInstance().setup();
        plugins = new CompanionPlugins();
        plugins.initiate(this);
        CraftBookPlugin.logDebugMessage("Initializing Managers!", "startup");
        this.managerAdapter = new MechanicListenerAdapter();
        CraftBookPlugin.logDebugMessage("Initializing Permission!", "startup");
        PermissionsResolverManager.initialize((Plugin)this);
        this.setupCraftBook();
        this.registerGlobalEvents();
        CraftBookPlugin.logDebugMessage("Initializing Commands!", "startup");
        this.commandManager.registerCommandsWith(platform);
        this.getServer().getPluginManager().registerEvents(new Listener(this){

            @EventHandler(priority=EventPriority.HIGH)
            public void playerJoin(PlayerJoinEvent event) {
                CraftBook.getInstance().getExecutorService().submit(() -> CraftBook.getInstance().getProfileCache().put(new Profile(event.getPlayer().getUniqueId(), event.getPlayer().getName())));
                if (!event.getPlayer().isOp()) {
                    return;
                }
                boolean foundAMech = false;
                for (CraftBookMechanic mech : platform.getMechanicManager().getLoadedMechanics()) {
                    if (mech instanceof VariableManager) continue;
                    foundAMech = true;
                    break;
                }
                if (!foundAMech) {
                    event.getPlayer().sendMessage((Component)Component.text((String)"[CraftBook] Warning! You have no mechanics enabled, the plugin will appear to do nothing until a feature is enabled!", (TextColor)NamedTextColor.RED));
                }
            }
        }, (Plugin)this);
        boolean foundAMech = false;
        for (CraftBookMechanic mech : platform.getMechanicManager().getLoadedMechanics()) {
            if (mech instanceof VariableManager) continue;
            foundAMech = true;
            break;
        }
        if (!foundAMech) {
            Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.getComponentLogger().warn((Component)Component.text((String)"Warning! You have no mechanics enabled, the plugin will appear to do nothing until a feature is enabled!", (TextColor)NamedTextColor.RED)), 20L, 6000L);
        }
    }

    public void setupCraftBook() {
        if (CraftBookPlugin.platform.getConfiguration().debugLogToFile) {
            try {
                debugLogger = new PrintWriter(new File(this.getDataFolder(), "debug.log"));
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        CraftBookPlugin.logDebugMessage("Initializing Mechanisms!", "startup");
        try {
            new File(CraftBookPlugin.inst().getDataFolder(), "mechanics").mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        platform.getMechanicManager().enableMechanics();
    }

    public void registerGlobalEvents() {
        CraftBookPlugin.logDebugMessage("Registring managers!", "startup");
        this.getServer().getPluginManager().registerEvents((Listener)this.managerAdapter, (Plugin)CraftBookPlugin.inst());
        try {
            CraftBookPlugin.logDebugMessage("Initializing Metrics!", "startup");
            Metrics metrics = new Metrics((Plugin)this, 3319);
            metrics.addCustomChart(new SimpleBarChart("enabled_mechanics", () -> platform.getMechanicManager().getLoadedMechanics().stream().collect(Collectors.toMap(mech -> mech.getClass().getSimpleName(), o -> 1))));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        platform.unload();
    }

    private String rebuildArguments(String commandLabel, String[] args) {
        int plSep = commandLabel.indexOf(":");
        if (plSep >= 0 && plSep < commandLabel.length() + 1) {
            commandLabel = commandLabel.substring(plSep + 1);
        }
        StringBuilder sb = new StringBuilder("/").append(commandLabel);
        if (args.length > 0) {
            sb.append(" ");
        }
        return Joiner.on((String)" ").appendTo(sb, (Object[])args).toString();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        this.commandManager.handleCommand(this.wrapCommandSender(sender), this.rebuildArguments(label, args));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String arguments = this.rebuildArguments(alias, args);
        return CommandUtil.fixSuggestions((String)arguments, this.commandManager.handleCommandSuggestion(this.wrapCommandSender(sender), arguments));
    }

    public static CraftBookPlugin inst() {
        return instance;
    }

    public PlatformCommandManager getCommandManager() {
        return this.commandManager;
    }

    public boolean inGroup(Player player, String group) {
        try {
            return PermissionsResolverManager.getInstance().inGroup((OfflinePlayer)player, group);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public String[] getGroups(Player player) {
        try {
            return PermissionsResolverManager.getInstance().getGroups((OfflinePlayer)player);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new String[0];
        }
    }

    public boolean hasPermission(CommandSender sender, String perm) {
        if (sender.isOp()) {
            if (sender instanceof Player) {
                if (!CraftBookPlugin.platform.getConfiguration().noOpPermissions) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return PermissionsResolverManager.getInstance().hasPermission(player.getWorld().getName(), (OfflinePlayer)player, perm);
        }
        return false;
    }

    public Actor wrapCommandSender(CommandSender sender) {
        if (sender instanceof Player) {
            return this.wrapPlayer((Player)sender);
        }
        return new BukkitCraftBookCommandSender(plugins.getWorldEdit(), sender);
    }

    public CraftBookPlayer wrapPlayer(Player player) {
        return new BukkitCraftBookPlayer(this, player);
    }

    public void reloadConfiguration() {
        platform.getMechanicManager().shutdown();
        this.getServer().getScheduler().cancelTasks((Plugin)CraftBookPlugin.inst());
        HandlerList.unregisterAll((Plugin)CraftBookPlugin.inst());
        if (CraftBookPlugin.platform.getConfiguration().debugLogToFile) {
            debugLogger.close();
            debugLogger = null;
        }
        platform.getConfiguration().load();
        this.managerAdapter = new MechanicListenerAdapter();
        this.setupCraftBook();
        this.registerGlobalEvents();
    }

    public static boolean isDebugFlagEnabled(String flag) {
        if (CraftBookPlugin.inst() == null) {
            return false;
        }
        if (!CraftBook.getInstance().getPlatform().getConfiguration().debugMode || CraftBook.getInstance().getPlatform().getConfiguration().debugFlags == null || CraftBook.getInstance().getPlatform().getConfiguration().debugFlags.isEmpty()) {
            return false;
        }
        String[] flagBits = RegexUtil.PERIOD_PATTERN.split(flag);
        Object tempFlag = "";
        for (int i = 0; i < flagBits.length; ++i) {
            tempFlag = i == 0 ? flagBits[i] : (String)tempFlag + "." + flagBits[i];
            for (String testflag : CraftBook.getInstance().getPlatform().getConfiguration().debugFlags) {
                if (!testflag.toLowerCase(Locale.ENGLISH).equals(tempFlag)) continue;
                return true;
            }
        }
        return false;
    }

    public static void logDebugMessage(String message, String code) {
        if (!CraftBookPlugin.isDebugFlagEnabled(code)) {
            return;
        }
        CraftBook.LOGGER.info("[Debug][" + code + "] " + message);
        if (CraftBook.getInstance().getPlatform().getConfiguration().debugLogToFile) {
            debugLogger.println("[" + code + "] " + message);
        }
    }
}

