/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit;

import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.adapter.bukkit.TextAdapter;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.item.ItemType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.util.TextUtil;

public final class BukkitCraftBookPlayer
extends BukkitPlayer
implements CraftBookPlayer {
    private final CraftBookPlugin plugin;
    private final Player player;

    public BukkitCraftBookPlayer(CraftBookPlugin plugin, Player player) {
        super(CraftBookPlugin.plugins.getWorldEdit(), player);
        this.plugin = plugin;
        this.player = player;
    }

    public void print(Component component) {
        TextAdapter.sendMessage((CommandSender)this.player, (Component)TextUtil.format(component, this.getLocale()));
    }

    @Override
    public void printActionBar(Component component) {
        TextAdapter.sendActionBar((CommandSender)this.player, (Component)TextUtil.format(component, this.getLocale()));
    }

    public void printInfo(Component component) {
        this.print(component.color(TextColor.YELLOW));
    }

    public boolean hasPermission(String perm) {
        return this.plugin.hasPermission((CommandSender)this.player, perm);
    }

    @Override
    public boolean isInsideVehicle() {
        return this.player.isInsideVehicle();
    }

    @Override
    public boolean isHoldingBlock() {
        ItemType mainitem = this.getItemInHand(HandSide.MAIN_HAND).getType();
        ItemType offitem = this.getItemInHand(HandSide.OFF_HAND).getType();
        return mainitem.hasBlockType() && !mainitem.getBlockType().getMaterial().isAir() || offitem.hasBlockType() && !offitem.getBlockType().getMaterial().isAir();
    }

    @Override
    public boolean isSneaking() {
        return this.player.isSneaking();
    }
}

