/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit;

import com.sk89q.bukkit.util.CommandInfo;
import com.sk89q.bukkit.util.CommandRegistration;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.util.PermissionCondition;
import com.sk89q.worldedit.util.formatting.WorldEditText;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.report.Report;
import com.sk89q.worldedit.util.report.ReportList;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookManifest;
import org.enginehub.craftbook.CraftBookPlatform;
import org.enginehub.craftbook.YamlConfiguration;
import org.enginehub.craftbook.bukkit.BukkitCommandInspector;
import org.enginehub.craftbook.bukkit.BukkitConfiguration;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.mechanic.BukkitMechanicManager;
import org.enginehub.craftbook.bukkit.report.LoadedICsReport;
import org.enginehub.craftbook.bukkit.report.MechanicReport;
import org.enginehub.craftbook.bukkit.report.PerformanceReport;
import org.enginehub.craftbook.bukkit.report.PluginReport;
import org.enginehub.craftbook.bukkit.report.SchedulerReport;
import org.enginehub.craftbook.bukkit.report.ServerReport;
import org.enginehub.craftbook.bukkit.report.ServicesReport;
import org.enginehub.craftbook.bukkit.report.WorldReport;
import org.enginehub.craftbook.bukkit.st.BukkitSelfTriggerManager;
import org.enginehub.craftbook.mechanic.MechanicManager;
import org.enginehub.craftbook.st.SelfTriggerManager;
import org.enginehub.craftbook.util.profile.cache.ProfileCache;
import org.enginehub.craftbook.util.profile.resolver.CacheForwardingService;
import org.enginehub.craftbook.util.profile.resolver.CombinedProfileService;
import org.enginehub.craftbook.util.profile.resolver.HttpRepositoryService;
import org.enginehub.craftbook.util.profile.resolver.PaperPlayerService;
import org.enginehub.craftbook.util.profile.resolver.ProfileService;
import org.enginehub.craftbook.util.report.ReportFlag;
import org.enginehub.piston.CommandManager;
import org.jspecify.annotations.Nullable;

public class BukkitCraftBookPlatform
implements CraftBookPlatform {
    private final MechanicManager mechanicManager = new BukkitMechanicManager();
    private YamlConfiguration config;
    private @Nullable String version;
    private BukkitSelfTriggerManager selfTriggerManager;

    @Override
    public String getPlatformName() {
        return "Bukkit-Official";
    }

    @Override
    public String getPlatformVersion() {
        if (this.version != null) {
            return this.version;
        }
        CraftBookManifest manifest = CraftBookManifest.load();
        this.version = manifest.getCraftBookVersion();
        return this.version;
    }

    @Override
    public void load() {
        this.mechanicManager.setup();
        try {
            CraftBookPlugin.inst().createDefaultConfiguration("config.yml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.config = new BukkitConfiguration(new YAMLProcessor(CraftBook.getInstance().getPlatform().getWorkingDirectory().resolve("config.yml"), true, YAMLFormat.EXTENDED));
        try {
            this.config.load();
        }
        catch (Throwable e) {
            CraftBook.LOGGER.error("Failed to load CraftBook Configuration File! Is it corrupt?", e);
            CraftBook.LOGGER.error("Disabling CraftBook due to invalid Configuration File!");
            Bukkit.getPluginManager().disablePlugin((Plugin)CraftBookPlugin.inst());
            return;
        }
        this.selfTriggerManager = new BukkitSelfTriggerManager();
        if (System.getenv("CRAFTBOOK_DOCGEN") == null) {
            this.selfTriggerManager.setup();
        }
    }

    @Override
    public void unload() {
        this.mechanicManager.shutdown();
        this.selfTriggerManager.shutdown();
    }

    @Override
    public void registerCommands(CommandManager commandManager) {
        BukkitCommandInspector inspector = new BukkitCommandInspector(CraftBookPlugin.inst(), commandManager);
        CommandRegistration registration = new CommandRegistration((Plugin)CraftBookPlugin.inst());
        registration.register(commandManager.getAllCommands().map(command -> {
            String[] permissionsArray = command.getCondition().as(PermissionCondition.class).map(PermissionCondition::getPermissions).map(s -> s.toArray(new String[0])).orElseGet(() -> new String[0]);
            String[] aliases = (String[])Stream.concat(Stream.of(command.getName()), command.getAliases().stream()).toArray(String[]::new);
            return new CommandInfo(WorldEditText.reduceToText((Component)command.getUsage(), (Locale)WorldEdit.getInstance().getConfiguration().defaultLocale), WorldEditText.reduceToText((Component)command.getDescription(), (Locale)WorldEdit.getInstance().getConfiguration().defaultLocale), aliases, (Object)inspector, permissionsArray);
        }).collect(Collectors.toList()));
    }

    public void resetCommandRegistration(CraftBookPlugin plugin) {
        CommandRegistration registration = new CommandRegistration((Plugin)plugin);
        registration.unregisterCommands();
        plugin.getCommandManager().registerCommandsWith(CraftBook.getInstance().getPlatform());
    }

    @Override
    public Path getWorkingDirectory() {
        return CraftBookPlugin.inst().getDataFolder().toPath();
    }

    @Override
    public MechanicManager getMechanicManager() {
        return this.mechanicManager;
    }

    @Override
    public SelfTriggerManager getSelfTriggerManager() {
        return this.selfTriggerManager;
    }

    @Override
    public YamlConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void reloadConfiguration() {
        CraftBookPlugin.inst().reloadConfiguration();
    }

    @Override
    public void addPlatformReports(ReportList report, ReportFlag ... flags) {
        report.add((Report)new ServerReport());
        report.add((Report)new PluginReport());
        report.add((Report)new SchedulerReport());
        report.add((Report)new ServicesReport());
        report.add((Report)new WorldReport());
        report.add((Report)new PerformanceReport());
        report.add((Report)new MechanicReport());
        block3: for (ReportFlag flag : flags) {
            switch (flag) {
                case IC_REPORT: {
                    report.add((Report)new LoadedICsReport());
                    continue block3;
                }
            }
        }
    }

    @Override
    public ProfileService createProfileService(ProfileCache profileCache) {
        return new CacheForwardingService(new CombinedProfileService(List.of(PaperPlayerService.getInstance(), HttpRepositoryService.forMinecraft())), profileCache);
    }

    @Override
    public boolean isPluginAvailable(String pluginName) {
        return Bukkit.getPluginManager().isPluginEnabled(pluginName);
    }

    @Override
    public void refreshPlayerCommandMaps() {
        CraftBookPlugin plugin = CraftBookPlugin.inst();
        if (plugin.getCommandManager().getMechanicRegistrar().isDirty()) {
            this.resetCommandRegistration(plugin);
            Bukkit.getOnlinePlayers().forEach(Player::updateCommands);
        }
    }
}

