/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.bukkit.util.CommandInspector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Actor;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.util.TextUtil;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.inject.MapBackedValueStore;

public class BukkitCommandInspector
implements CommandInspector {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CraftBookPlugin plugin;
    private final CommandManager dispatcher;

    public BukkitCommandInspector(CraftBookPlugin plugin, CommandManager dispatcher) {
        Preconditions.checkNotNull((Object)((Object)plugin));
        Preconditions.checkNotNull((Object)dispatcher);
        this.plugin = plugin;
        this.dispatcher = dispatcher;
    }

    public String getShortText(Command command) {
        Optional mapping = this.dispatcher.getCommand(command.getName());
        if (mapping.isPresent()) {
            return TextUtil.reduceToText(((org.enginehub.piston.Command)mapping.get()).getDescription(), WorldEdit.getInstance().getConfiguration().defaultLocale);
        }
        LOGGER.warn("BukkitCommandInspector doesn't know how about the command '" + String.valueOf(command) + "'");
        return "Help text not available";
    }

    public String getFullText(Command command) {
        Optional mapping = this.dispatcher.getCommand(command.getName());
        if (mapping.isPresent()) {
            return TextUtil.reduceToText(((org.enginehub.piston.Command)mapping.get()).getFullHelp(), WorldEdit.getInstance().getConfiguration().defaultLocale);
        }
        LOGGER.warn("BukkitCommandInspector doesn't know how about the command '" + String.valueOf(command) + "'");
        return "Help text not available";
    }

    public boolean testPermission(CommandSender sender, Command command) {
        Optional mapping = this.dispatcher.getCommand(command.getName());
        if (mapping.isPresent()) {
            MapBackedValueStore store = MapBackedValueStore.create();
            store.injectValue(Key.of(Actor.class), context -> Optional.of(this.plugin.wrapCommandSender(sender)));
            return ((org.enginehub.piston.Command)mapping.get()).getCondition().satisfied((InjectedValueAccess)store);
        }
        LOGGER.warn("BukkitCommandInspector doesn't know how about the command '" + String.valueOf(command) + "'");
        return false;
    }
}

