/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.enginehub.craftbook.ChangedSign;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.mechanics.variables.VariableKey;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.enginehub.craftbook.util.ParsingUtil;
import org.jspecify.annotations.Nullable;

public class BukkitChangedSign
extends ChangedSign {
    private final Block block;
    private final Side side;
    private @Nullable Sign sign;
    private Component @Nullable [] lines;
    private Component @Nullable [] oldLines;

    private BukkitChangedSign(Block block, Side side, Component @Nullable [] lines, @Nullable CraftBookPlayer player) {
        this.block = block;
        this.side = side;
        if (lines == null) {
            this.flushLines();
        } else {
            this.lines = lines;
            this.oldLines = new Component[this.lines.length];
            System.arraycopy(this.lines, 0, this.oldLines, 0, this.lines.length);
        }
        if (player != null) {
            this.checkPlayerVariablePermissions(player);
        }
    }

    @Override
    public void checkPlayerVariablePermissions(CraftBookPlayer player) {
        if (this.lines != null && VariableManager.instance != null) {
            for (int i = 0; i < 4; ++i) {
                Component line = this.lines[i];
                for (VariableKey variableKey : VariableManager.instance.getPossibleVariables(line, (Actor)player)) {
                    if (variableKey.hasPermission((Actor)player, "use")) continue;
                    TextReplacementConfig config = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%" + variableKey.getOriginalForm() + "%").replacement("").build();
                    this.setLine(i, line.replaceText(config));
                }
            }
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public Sign getSign() {
        if (this.sign == null) {
            this.sign = (Sign)this.block.getState(false);
        }
        return this.sign;
    }

    public SignSide getSignSide() {
        return this.getSign().getSide(this.side);
    }

    public Side getSide() {
        return this.side;
    }

    public Material getType() {
        return this.block.getType();
    }

    @Override
    public int getX() {
        return this.block.getX();
    }

    @Override
    public int getY() {
        return this.block.getY();
    }

    @Override
    public int getZ() {
        return this.block.getZ();
    }

    @Override
    public Component @Nullable [] getLines() {
        return this.lines;
    }

    @Override
    public Component getLine(int index) throws IndexOutOfBoundsException {
        return this.getLine(index, null);
    }

    @Override
    public Component getLine(int index, @Nullable Player player) throws IndexOutOfBoundsException {
        return ParsingUtil.parseLine(this.lines[index], player);
    }

    @Override
    public Component getRawLine(int index) throws IndexOutOfBoundsException {
        return this.lines[index];
    }

    @Override
    public void setLine(int index, Component line) throws IndexOutOfBoundsException {
        this.lines[index] = line;
    }

    public void setType(Material type) {
        this.block.setType(type);
    }

    @Override
    public boolean update(boolean force) {
        if (!this.hasChanged() && !force) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            this.getSignSide().line(i, this.lines[i]);
        }
        System.arraycopy(this.lines, 0, this.oldLines, 0, this.lines.length);
        return this.getSign().update(force, false);
    }

    @Override
    public void setLines(Component[] lines) {
        this.lines = lines;
    }

    @Override
    public void setOldLines(Component[] oldLines) {
        this.oldLines = oldLines;
    }

    @Override
    public boolean hasChanged() {
        for (int i = 0; i < 4; ++i) {
            if (Objects.equals(this.oldLines[i], this.lines[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void flushLines() {
        this.sign = null;
        this.lines = this.getSignSide().lines().toArray(new Component[0]);
        if (this.oldLines == null) {
            this.oldLines = new Component[this.lines.length];
        }
        System.arraycopy(this.lines, 0, this.oldLines, 0, this.lines.length);
    }

    public boolean equals(Object o) {
        if (o instanceof BukkitChangedSign) {
            BukkitChangedSign other = (BukkitChangedSign)o;
            return Objects.equals(other.getType(), this.getType()) && other.getSide() == this.getSide() && other.getX() == this.getX() && other.getY() == this.getY() && other.getZ() == this.getZ() && Objects.equals(other.getBlock().getWorld().getUID(), this.getBlock().getWorld().getUID()) && Arrays.equals(other.getLines(), this.getLines());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.side, Arrays.hashCode(this.lines), this.getX(), this.getY(), this.getZ(), this.block.getWorld().getUID());
    }

    public String toString() {
        return Arrays.stream(this.lines).map(arg_0 -> ((PlainTextComponentSerializer)PlainTextComponentSerializer.plainText()).serialize(arg_0)).collect(Collectors.joining("|"));
    }

    public static BukkitChangedSign create(Sign sign, Side side) {
        return BukkitChangedSign.create(sign.getBlock(), side, sign.getSide(side).lines().toArray(new Component[0]), null);
    }

    public static BukkitChangedSign create(Sign sign, Side side, @Nullable CraftBookPlayer player) {
        return BukkitChangedSign.create(sign.getBlock(), side, sign.getSide(side).lines().toArray(new Component[0]), player);
    }

    public static BukkitChangedSign create(Block block, Side side) {
        return BukkitChangedSign.create(block, side, null, null);
    }

    public static BukkitChangedSign create(Block block, Side side, Component @Nullable [] lines, @Nullable CraftBookPlayer player) {
        Preconditions.checkNotNull((Object)block, (Object)"block");
        Preconditions.checkNotNull((Object)side, (Object)"side");
        return new BukkitChangedSign(block, side, lines, player);
    }
}

