/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.util.report.Unreported;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanic.MechanicType;

public abstract class YamlConfiguration {
    public List<String> enabledMechanics;
    public boolean noOpPermissions;
    public boolean indirectRedstone;
    public boolean safeDestruction;
    public int stThinkRate;
    public boolean obeyWorldGuard;
    public boolean obeyPluginProtections;
    public boolean showPermissionMessages;
    public long signClickTimeout;
    public boolean debugMode;
    public boolean debugLogToFile;
    public List<String> debugFlags;
    @Unreported
    public YAMLProcessor config;

    public YamlConfiguration(YAMLProcessor config) {
        this.config = config;
    }

    public void load() {
        this.config.setWriteDefaults(true);
        this.config.setHeader(new String[]{"# CraftBook Configuration for " + CraftBook.getInstance().getPlatform().getPlatformName() + ".", "# This configuration will automatically add new configuration options for you,", "# So there is no need to regenerate this configuration unless you want to.", "# More information about these features are available at:", "# " + CraftBook.getDocsDomain() + "mechanics/", "#", "# NOTE! NOTHING IS ENABLED BY DEFAULT! ENABLE FEATURES TO USE THEM!", ""});
        this.enabledMechanics = new ArrayList<String>();
        this.config.setComment("mechanics", "List of mechanics and whether they are enabled or not");
        MechanicType.REGISTRY.values().stream().sorted(Comparator.comparing(t -> t.getCategory().name()).thenComparing(MechanicType::id)).forEach(mechanicType -> {
            String path = "mechanics." + mechanicType.getCategory().name().toLowerCase(Locale.ENGLISH) + "." + mechanicType.id();
            boolean enabled = this.config.getBoolean(path, mechanicType.id().equals("variables"));
            if (enabled) {
                this.enabledMechanics.add(mechanicType.id());
            }
        });
        this.config.setComment("st-think-ticks", "WARNING! Changing this can result in all ST mechanics acting very weirdly, only change this if you know what you are doing!");
        this.stThinkRate = this.config.getInt("st-think-ticks", 2);
        this.config.setComment("safe-destruction", "Causes many mechanics to require sufficient blocks to function, for example gates, bridges and doors.");
        this.safeDestruction = this.config.getBoolean("safe-destruction", true);
        this.config.setComment("no-op-permissions", "If on, OP's will not default to have access to everything.");
        this.noOpPermissions = this.config.getBoolean("no-op-permissions", false);
        this.config.setComment("indirect-redstone", "Allows redstone not directly facing a mechanism to trigger said mechanism.");
        this.indirectRedstone = this.config.getBoolean("indirect-redstone", false);
        this.config.setComment("obey-worldguard-flags", "Whether WorldGuard flags should be checked when performing CraftBook actions.");
        this.obeyWorldGuard = this.config.getBoolean("obey-worldguard-flags", true);
        this.config.setComment("obey-plugin-protections", "Whether to obey other plugins attempts to cancel CraftBook actions.");
        this.obeyPluginProtections = this.config.getBoolean("obey-plugin-protections", true);
        this.config.setComment("sign-click-timeout", "How often in milliseconds players can interact with CraftBook signs.");
        this.signClickTimeout = this.config.getInt("sign-click-timeout", 500);
        this.config.setComment("debug-mode", "Enable a mode that will print extra debug information to the console.");
        this.debugMode = this.config.getBoolean("debug-mode", false);
        this.config.setComment("debug-mode-file-logging", "Causes all debug mode output to be logged into a file. This file is reset every startup (And every /cb reload).");
        this.debugLogToFile = this.config.getBoolean("debug-mode-file-logging", false);
        this.config.setComment("debug-flags", "Enable certain debug types when debug mode is enabled.");
        this.debugFlags = this.config.getStringList("debug-flags", new ArrayList());
        this.config.setComment("show-permission-messages", "Show messages when a player does not have permission to do something.");
        this.showPermissionMessages = this.config.getBoolean("show-permission-messages", true);
        this.config.save();
    }

    public void save() {
        for (MechanicType availableMechanic : MechanicType.REGISTRY.values()) {
            String path = "mechanics." + availableMechanic.getCategory().name().toLowerCase(Locale.ENGLISH) + "." + availableMechanic.id();
            this.config.setProperty(path, (Object)this.enabledMechanics.contains(availableMechanic.id()));
        }
        this.config.save();
    }
}

