/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sk89q.worldedit.command.argument.Arguments;
import com.sk89q.worldedit.command.argument.VectorConverter;
import com.sk89q.worldedit.command.argument.WorldConverter;
import com.sk89q.worldedit.command.util.PermissionCondition;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.command.CommandArgParser;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.internal.util.Substring;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlatform;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.command.CraftBookExceptionConverter;
import org.enginehub.craftbook.command.argument.RegistryConverter;
import org.enginehub.craftbook.commands.CraftBookCommands;
import org.enginehub.craftbook.mechanic.MechanicCommandRegistrar;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandManagerService;
import org.enginehub.piston.CommandParseResult;
import org.enginehub.piston.exception.CommandException;
import org.enginehub.piston.exception.CommandExecutionException;
import org.enginehub.piston.exception.ConditionFailedException;
import org.enginehub.piston.exception.UsageException;
import org.enginehub.piston.impl.CommandManagerServiceImpl;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.InjectedValueStore;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.inject.MapBackedValueStore;
import org.enginehub.piston.inject.MemoizingValueAccess;
import org.enginehub.piston.inject.MergedValueAccess;
import org.enginehub.piston.util.HelpGenerator;
import org.enginehub.piston.util.ValueProvider;

public class PlatformCommandManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CommandManagerServiceImpl commandManagerService = new CommandManagerServiceImpl();
    private final CommandManager commandManager = this.commandManagerService.newCommandManager();
    private final InjectedValueStore globalInjectedValues = MapBackedValueStore.create();
    private final CommandRegistrationHandler registration = new CommandRegistrationHandler(List.of());
    private final MechanicCommandRegistrar mechanicCommandRegistrar = new MechanicCommandRegistrar((CommandManagerService)this.commandManagerService, this.commandManager, this.registration);
    private final CraftBookExceptionConverter exceptionConverter = new CraftBookExceptionConverter(CraftBook.getInstance());

    public PlatformCommandManager() {
        this.initialize();
    }

    private void initialize() {
        this.registerAlwaysInjectedValues();
        this.registerArgumentConverters();
        this.registerCoreCommands();
    }

    private void registerAlwaysInjectedValues() {
    }

    private void registerArgumentConverters() {
        RegistryConverter.register(this.commandManager);
        com.sk89q.worldedit.command.argument.RegistryConverter.register((CommandManager)this.commandManager);
        VectorConverter.register((CommandManager)this.commandManager);
        WorldConverter.register((CommandManager)this.commandManager);
    }

    private void registerCoreCommands() {
        CraftBookCommands.register((CommandManagerService)this.commandManagerService, this.commandManager, this.registration);
    }

    public MechanicCommandRegistrar getMechanicRegistrar() {
        return this.mechanicCommandRegistrar;
    }

    public void registerCommandsWith(CraftBookPlatform platform) {
        platform.registerCommands(this.commandManager);
        this.mechanicCommandRegistrar.unmarkDirty();
    }

    private Stream<Substring> parseArgs(String input) {
        return CommandArgParser.forArgString((String)input.substring(1)).parseArgs();
    }

    private MemoizingValueAccess initializeInjectedValues(Arguments arguments, Actor actor) {
        MapBackedValueStore store = MapBackedValueStore.create();
        store.injectValue(Key.of(Actor.class), ValueProvider.constant((Object)actor));
        if (actor instanceof CraftBookPlayer) {
            CraftBookPlayer player = (CraftBookPlayer)actor;
            store.injectValue(Key.of(CraftBookPlayer.class), ValueProvider.constant((Object)player));
        } else {
            store.injectValue(Key.of(CraftBookPlayer.class), context -> {
                throw new CommandException((Component)TextComponent.of((String)"This command must be used with a player."), ImmutableList.of());
            });
        }
        store.injectValue(Key.of(Arguments.class), ValueProvider.constant((Object)arguments));
        return MemoizingValueAccess.wrap((InjectedValueAccess)MergedValueAccess.of((InjectedValueAccess[])new InjectedValueAccess[]{store, this.globalInjectedValues}));
    }

    private void handleUnknownException(Actor actor, Throwable t) {
        actor.printError((Component)TranslatableComponent.of((String)"worldedit.command.error.report"));
        actor.print((Component)TextComponent.of((String)(t.getClass().getName() + ": " + t.getMessage())));
        LOGGER.error("An unexpected error while handling a CraftBook command", t);
    }

    public void handleCommand(Actor actor, String arguments) {
        Object[] split = (String[])this.parseArgs(arguments).map(Substring::getSubstring).toArray(String[]::new);
        if (!this.commandManager.containsCommand(split[0])) {
            return;
        }
        MemoizingValueAccess context = this.initializeInjectedValues(() -> arguments, actor);
        try {
            try {
                this.commandManager.execute((InjectedValueAccess)context, (List)ImmutableList.copyOf((Object[])split));
            }
            catch (Throwable t) {
                Throwable next = t;
                do {
                    this.exceptionConverter.convert(next);
                } while ((next = next.getCause()) != null);
                throw t;
            }
        }
        catch (ConditionFailedException e) {
            if (e.getCondition() instanceof PermissionCondition) {
                actor.printError((Component)TranslatableComponent.of((String)"worldedit.command.permissions"));
            } else {
                actor.print(e.getRichMessage());
            }
        }
        catch (UsageException e) {
            actor.print((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder((String)"").color(TextColor.RED)).append(e.getRichMessage())).build());
            ImmutableList cmd = e.getCommands();
            if (!cmd.isEmpty()) {
                actor.print((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder((String)"Usage: ").color(TextColor.RED)).append(HelpGenerator.create((CommandParseResult)e.getCommandParseResult()).getUsage())).build());
            }
        }
        catch (CommandExecutionException e) {
            this.handleUnknownException(actor, e.getCause());
        }
        catch (CommandException e) {
            actor.printError((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder((String)"").color(TextColor.RED)).append(e.getRichMessage())).build());
        }
        catch (Throwable t) {
            this.handleUnknownException(actor, t);
        }
    }

    public List<Substring> handleCommandSuggestion(Actor actor, String arguments) {
        try {
            ImmutableSet suggestions;
            List<Substring> split = this.parseArgs(arguments).toList();
            List<String> argStrings = split.stream().map(Substring::getSubstring).toList();
            MemoizingValueAccess access = this.initializeInjectedValues(() -> arguments, actor);
            try {
                suggestions = this.commandManager.getSuggestions((InjectedValueAccess)access, argStrings);
            }
            catch (Throwable t) {
                if (!(t instanceof CommandException)) {
                    LOGGER.debug("Unexpected error occurred while generating suggestions for input: " + arguments, t);
                    return Collections.emptyList();
                }
                throw t;
            }
            return suggestions.stream().map(suggestion -> {
                int noSlashLength = arguments.length() - 1;
                Substring original = suggestion.getReplacedArgument() == split.size() ? Substring.from((String)arguments, (int)noSlashLength, (int)noSlashLength) : (Substring)split.get(suggestion.getReplacedArgument());
                return Substring.wrap((String)suggestion.getSuggestion(), (int)(original.getStart() + 1), (int)(original.getEnd() + 1));
            }).toList();
        }
        catch (ConditionFailedException conditionFailedException) {
            return Collections.emptyList();
        }
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }
}

