/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jspecify.annotations.Nullable;

public class CraftBookManifest {
    public static final String CRAFT_BOOK_VERSION = "CraftBook-Version";
    private final String craftBookVersion;

    public static CraftBookManifest load() {
        Attributes attributes = CraftBookManifest.readAttributes();
        return new CraftBookManifest(CraftBookManifest.readAttribute(attributes, CRAFT_BOOK_VERSION, () -> "(unknown)"));
    }

    private static @Nullable Attributes readAttributes() {
        Class<CraftBookManifest> clazz = CraftBookManifest.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        try {
            URL url = URI.create(classPath).toURL();
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            Manifest manifest = jarConnection.getManifest();
            return manifest.getMainAttributes();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String readAttribute(@Nullable Attributes attributes, String name, Supplier<String> defaultAction) {
        if (attributes == null) {
            return defaultAction.get();
        }
        String value = attributes.getValue(name);
        return value != null ? value : defaultAction.get();
    }

    private CraftBookManifest(String craftBookVersion) {
        this.craftBookVersion = craftBookVersion;
    }

    public String getCraftBookVersion() {
        return this.craftBookVersion;
    }
}

