/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.io.ResourceLoader;
import com.sk89q.worldedit.util.io.file.ArchiveUnpacker;
import com.sk89q.worldedit.util.task.SimpleSupervisor;
import com.sk89q.worldedit.util.task.Supervisor;
import com.sk89q.worldedit.util.translation.TranslationManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.enginehub.craftbook.CraftBookPlatform;
import org.enginehub.craftbook.CraftBookResourceLoader;
import org.enginehub.craftbook.util.concurrent.EvenMoreExecutors;
import org.enginehub.craftbook.util.profile.cache.HashMapCache;
import org.enginehub.craftbook.util.profile.cache.ProfileCache;
import org.enginehub.craftbook.util.profile.cache.SQLiteCache;
import org.enginehub.craftbook.util.profile.resolver.ProfileService;

public class CraftBook {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final CraftBook instance = new CraftBook();
    private CraftBookPlatform platform;
    private final ResourceLoader resourceLoader = new CraftBookResourceLoader();
    private final LazyReference<ArchiveUnpacker> archiveUnpacker = LazyReference.from(() -> {
        try {
            return new ArchiveUnpacker(this.platform.getWorkingDirectory().resolve(".archive-unpack"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    });
    private TranslationManager translationManager;
    private final Supervisor supervisor = new SimpleSupervisor();
    private ProfileCache profileCache;
    private ProfileService profileService;
    private ListeningExecutorService executorService;

    public static CraftBook getInstance() {
        return instance;
    }

    public void setup() {
        try {
            this.translationManager = new TranslationManager((ArchiveUnpacker)this.archiveUnpacker.getValue(), this.resourceLoader);
        }
        catch (IOException e) {
            LOGGER.error("Failed to initialise localisations", (Throwable)e);
        }
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)EvenMoreExecutors.newBoundedCachedThreadPool(0, 1, 20, "CraftBook Task Executor - %s"));
        Path cacheDir = this.getPlatform().getWorkingDirectory().resolve("cache");
        if (!Files.exists(cacheDir, new LinkOption[0])) {
            try {
                Files.createDirectories(cacheDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to create cache directory, profile cache may not work correctly.", (Throwable)e);
            }
        }
        try {
            this.profileCache = new SQLiteCache(cacheDir.resolve("profiles.sqlite").toFile());
        }
        catch (IOException | UnsatisfiedLinkError ignored) {
            LOGGER.warn("Failed to initialize SQLite profile cache. Cache is memory-only.");
            this.profileCache = new HashMapCache();
        }
        this.profileService = this.getPlatform().createProfileService(this.profileCache);
        this.getPlatform().load();
    }

    public CraftBookPlatform getPlatform() {
        Preconditions.checkNotNull((Object)this.platform);
        return this.platform;
    }

    public void setPlatform(CraftBookPlatform platform) {
        Preconditions.checkNotNull((Object)platform);
        this.platform = platform;
    }

    public Supervisor getSupervisor() {
        return this.supervisor;
    }

    public ListeningExecutorService getExecutorService() {
        return this.executorService;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public ProfileCache getProfileCache() {
        return this.profileCache;
    }

    public TranslationManager getTranslationManager() {
        return this.translationManager;
    }

    public static String getDocsDomain() {
        return "https://craftbook.enginehub.org/en/5.0.0/";
    }
}

