/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook;

import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;

public abstract class AbstractCraftBookMechanic
implements CraftBookMechanic {
    private final MechanicType<? extends CraftBookMechanic> mechanicType;

    public AbstractCraftBookMechanic(MechanicType<? extends CraftBookMechanic> mechanicType) {
        this.mechanicType = mechanicType;
    }

    @Override
    public MechanicType<? extends CraftBookMechanic> getMechanicType() {
        return this.mechanicType;
    }

    @Override
    public void loadConfiguration(Path configFile) {
        YAMLProcessor mechanicConfig = new YAMLProcessor(configFile, true, YAMLFormat.EXTENDED);
        try {
            mechanicConfig.load();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            CraftBook.LOGGER.error("Failed to load configuration for " + this.getMechanicType().getName(), (Throwable)e);
        }
        mechanicConfig.setWriteDefaults(true);
        MechanicType<? extends CraftBookMechanic> mechType = this.getMechanicType();
        mechanicConfig.setHeader(new String[]{"# CraftBook " + mechType.getName() + " Configuration", "# -- Generated for version: " + CraftBook.getInstance().getPlatform().getPlatformVersion(), "# ", "# More information about this mechanic is available at...", "# " + this.getDocsUrl(mechType), "#", "# NOTE! Make sure to enable this in the config.yml file if you wish to use it.", ""});
        this.loadFromConfiguration(mechanicConfig);
        mechanicConfig.save();
    }
}

