/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.hook.miniplaceholder;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.economy.Currency;
import com.github.encryptsl.lite.eco.utils.PlaceholderHelper;
import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.resolver.AudienceTagResolver;
import io.github.miniplaceholders.kotlin.ExpansionExtKt;
import io.github.miniplaceholders.kotlin.TagExtKt;
import java.math.BigDecimal;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002J\f\u0010\u0006\u001a\u00020\u0007*\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/miniplaceholder/EconomyMiniPlaceholder;", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "toTag", "Lnet/kyori/adventure/text/minimessage/tag/Tag;", "Ljava/math/BigDecimal;", "", "register", "", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nEconomyMiniPlaceholder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EconomyMiniPlaceholder.kt\ncom/github/encryptsl/lite/eco/common/hook/miniplaceholder/EconomyMiniPlaceholder\n+ 2 ExpansionExt.kt\nio/github/miniplaceholders/kotlin/ExpansionExtKt\n*L\n1#1,68:1\n33#2:69\n33#2:70\n33#2:71\n*S KotlinDebug\n*F\n+ 1 EconomyMiniPlaceholder.kt\ncom/github/encryptsl/lite/eco/common/hook/miniplaceholder/EconomyMiniPlaceholder\n*L\n20#1:69\n25#1:70\n30#1:71\n*E\n"})
public final class EconomyMiniPlaceholder {
    @NotNull
    private final LiteEco liteEco;

    public EconomyMiniPlaceholder(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
    }

    private final Tag toTag(BigDecimal $this$toTag) {
        TextComponent textComponent = Component.text((String)$this$toTag.toPlainString());
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        return TagExtKt.asInsertingTag((ComponentLike)textComponent);
    }

    private final Tag toTag(String $this$toTag) {
        TextComponent textComponent = Component.text((String)$this$toTag);
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        return TagExtKt.asInsertingTag((ComponentLike)textComponent);
    }

    public final void register() {
        Expansion expansion = ExpansionExtKt.expansion("lite-eco", (Function1<? super Expansion.Builder, ? extends Expansion.Builder>)((Function1)arg_0 -> EconomyMiniPlaceholder.register$lambda$0(this, arg_0)));
        expansion.register();
    }

    private static final Tag register$lambda$0$0(EconomyMiniPlaceholder this$0, Player p, ArgumentQueue s, Context context) {
        PlaceholderHelper placeholderHelper = this$0.liteEco.getPlaceholderHelper();
        Intrinsics.checkNotNull((Object)s);
        String currency = placeholderHelper.parseCurrency(s);
        PlaceholderHelper placeholderHelper2 = this$0.liteEco.getPlaceholderHelper();
        UUID uUID = p.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        return this$0.toTag(placeholderHelper2.getBalance(uUID, currency));
    }

    private static final Tag register$lambda$0$1(EconomyMiniPlaceholder this$0, Player p, ArgumentQueue s, Context context) {
        PlaceholderHelper placeholderHelper = this$0.liteEco.getPlaceholderHelper();
        Intrinsics.checkNotNull((Object)s);
        String currency = placeholderHelper.parseCurrency(s);
        Currency currency2 = this$0.liteEco.getCurrencyImpl();
        PlaceholderHelper placeholderHelper2 = this$0.liteEco.getPlaceholderHelper();
        UUID uUID = p.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        return this$0.toTag(Currency.fullFormatting$default(currency2, placeholderHelper2.getBalance(uUID, currency), null, 2, null));
    }

    private static final Tag register$lambda$0$2(EconomyMiniPlaceholder this$0, Player p, ArgumentQueue s, Context context) {
        PlaceholderHelper placeholderHelper = this$0.liteEco.getPlaceholderHelper();
        Intrinsics.checkNotNull((Object)s);
        String currency = placeholderHelper.parseCurrency(s);
        Currency currency2 = this$0.liteEco.getCurrencyImpl();
        PlaceholderHelper placeholderHelper2 = this$0.liteEco.getPlaceholderHelper();
        UUID uUID = p.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        return this$0.toTag(currency2.compacted(placeholderHelper2.getBalance(uUID, currency)));
    }

    private static final Tag register$lambda$0$3(EconomyMiniPlaceholder this$0, ArgumentQueue i, Context context) {
        PlaceholderHelper placeholderHelper = this$0.liteEco.getPlaceholderHelper();
        Intrinsics.checkNotNull((Object)i);
        String currency = placeholderHelper.parseCurrency(i);
        return this$0.toTag(this$0.liteEco.getPlaceholderHelper().getNameByRank(1, currency));
    }

    private static final Tag register$lambda$0$4(EconomyMiniPlaceholder this$0, ArgumentQueue i, Context context) {
        PlaceholderHelper placeholderHelper = this$0.liteEco.getPlaceholderHelper();
        Intrinsics.checkNotNull((Object)i);
        String currency = placeholderHelper.parseCurrency(i);
        return this$0.toTag(this$0.liteEco.getCurrencyImpl().formatted(this$0.liteEco.getPlaceholderHelper().getTotalBalance(currency)));
    }

    private static final Tag register$lambda$0$5(EconomyMiniPlaceholder this$0, ArgumentQueue i, Context context) {
        PlaceholderHelper placeholderHelper = this$0.liteEco.getPlaceholderHelper();
        Intrinsics.checkNotNull((Object)i);
        Pair<Integer, String> pair = placeholderHelper.parseRankAndCurrency(i);
        if (pair == null) {
            return null;
        }
        Pair<Integer, String> pair2 = pair;
        int rank = ((Number)pair2.component1()).intValue();
        String currency = (String)pair2.component2();
        return this$0.toTag(Currency.fullFormatting$default(this$0.liteEco.getCurrencyImpl(), this$0.liteEco.getPlaceholderHelper().getBalanceByRank(rank, currency), null, 2, null));
    }

    private static final Tag register$lambda$0$6(EconomyMiniPlaceholder this$0, ArgumentQueue i, Context context) {
        PlaceholderHelper placeholderHelper = this$0.liteEco.getPlaceholderHelper();
        Intrinsics.checkNotNull((Object)i);
        Pair<Integer, String> pair = placeholderHelper.parseRankAndCurrency(i);
        if (pair == null) {
            return null;
        }
        Pair<Integer, String> pair2 = pair;
        int rank = ((Number)pair2.component1()).intValue();
        String currency = (String)pair2.component2();
        return this$0.toTag(this$0.liteEco.getCurrencyImpl().compacted(this$0.liteEco.getPlaceholderHelper().getBalanceByRank(rank, currency)));
    }

    private static final Tag register$lambda$0$7(EconomyMiniPlaceholder this$0, ArgumentQueue i, Context context) {
        PlaceholderHelper placeholderHelper = this$0.liteEco.getPlaceholderHelper();
        Intrinsics.checkNotNull((Object)i);
        Pair<Integer, String> pair = placeholderHelper.parseRankAndCurrency(i);
        if (pair == null) {
            return null;
        }
        Pair<Integer, String> pair2 = pair;
        int rank = ((Number)pair2.component1()).intValue();
        String currency = (String)pair2.component2();
        String string = this$0.liteEco.getPlaceholderHelper().getBalanceByRank(rank, currency).toPlainString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPlainString(...)");
        return this$0.toTag(string);
    }

    private static final Tag register$lambda$0$8(EconomyMiniPlaceholder this$0, ArgumentQueue i, Context context) {
        PlaceholderHelper placeholderHelper = this$0.liteEco.getPlaceholderHelper();
        Intrinsics.checkNotNull((Object)i);
        Pair<Integer, String> pair = placeholderHelper.parseRankAndCurrency(i);
        if (pair == null) {
            return null;
        }
        Pair<Integer, String> pair2 = pair;
        int rank = ((Number)pair2.component1()).intValue();
        String currency = (String)pair2.component2();
        return this$0.toTag(this$0.liteEco.getPlaceholderHelper().getNameByRank(rank, currency));
    }

    private static final Expansion.Builder register$lambda$0(EconomyMiniPlaceholder this$0, Expansion.Builder $this$expansion) {
        String placeholderName$iv;
        Expansion.Builder $this$audience$iv;
        Intrinsics.checkNotNullParameter((Object)$this$expansion, (String)"$this$expansion");
        Expansion.Builder builder = $this$expansion;
        String string = "balance";
        AudienceTagResolver resolver$iv = (arg_0, arg_1, arg_2) -> EconomyMiniPlaceholder.register$lambda$0$0(this$0, arg_0, arg_1, arg_2);
        boolean $i$f$audience = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$audience$iv.audiencePlaceholder(Player.class, placeholderName$iv, resolver$iv), (String)"audiencePlaceholder(...)");
        $this$audience$iv = $this$expansion;
        placeholderName$iv = "balance_formatted";
        resolver$iv = (arg_0, arg_1, arg_2) -> EconomyMiniPlaceholder.register$lambda$0$1(this$0, arg_0, arg_1, arg_2);
        $i$f$audience = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$audience$iv.audiencePlaceholder(Player.class, placeholderName$iv, resolver$iv), (String)"audiencePlaceholder(...)");
        $this$audience$iv = $this$expansion;
        placeholderName$iv = "balance_compacted";
        resolver$iv = (arg_0, arg_1, arg_2) -> EconomyMiniPlaceholder.register$lambda$0$2(this$0, arg_0, arg_1, arg_2);
        $i$f$audience = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$audience$iv.audiencePlaceholder(Player.class, placeholderName$iv, resolver$iv), (String)"audiencePlaceholder(...)");
        ExpansionExtKt.global($this$expansion, "top_rank_player", (arg_0, arg_1) -> EconomyMiniPlaceholder.register$lambda$0$3(this$0, arg_0, arg_1));
        ExpansionExtKt.global($this$expansion, "total_balance", (arg_0, arg_1) -> EconomyMiniPlaceholder.register$lambda$0$4(this$0, arg_0, arg_1));
        ExpansionExtKt.global($this$expansion, "top_balance_formatted", (arg_0, arg_1) -> EconomyMiniPlaceholder.register$lambda$0$5(this$0, arg_0, arg_1));
        ExpansionExtKt.global($this$expansion, "top_balance_compacted", (arg_0, arg_1) -> EconomyMiniPlaceholder.register$lambda$0$6(this$0, arg_0, arg_1));
        ExpansionExtKt.global($this$expansion, "top_balance", (arg_0, arg_1) -> EconomyMiniPlaceholder.register$lambda$0$7(this$0, arg_0, arg_1));
        return ExpansionExtKt.global($this$expansion, "top_player", (arg_0, arg_1) -> EconomyMiniPlaceholder.register$lambda$0$8(this$0, arg_0, arg_1));
    }
}

