/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.hook.economy.ezeconomy;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.common.hook.HookListener;
import com.github.encryptsl.lite.eco.utils.ClassUtil;
import com.skyblockexp.ezeconomy.api.EzEconomyAPI;
import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import com.skyblockexp.ezeconomy.dto.PlayerBalanceDTO;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/economy/ezeconomy/EzEconomyHook;", "Lcom/github/encryptsl/lite/eco/common/hook/HookListener;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "economyHandler", "Lcom/skyblockexp/ezeconomy/api/EzEconomyAPI;", "getEconomyHandler", "()Lcom/skyblockexp/ezeconomy/api/EzEconomyAPI;", "canRegister", "", "register", "", "unregister", "getBalance", "", "uuid", "Ljava/util/UUID;", "currency", "", "Companion", "LiteEco"})
public final class EzEconomyHook
extends HookListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    public static final String PLUGIN_NAME = "EzEconomy";

    public EzEconomyHook(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        super(PLUGIN_NAME, "You can now export economy from plugin EzEconomy to LiteEco with /eco database import EzEconomy <into_currency> [--from <currency>]");
        this.liteEco = liteEco;
    }

    private final EzEconomyAPI getEconomyHandler() {
        EzEconomyAPI ezEconomyAPI;
        if (Companion.isEzEconomyPresent()) {
            EzEconomyPlugin instance;
            Plugin plugin = this.liteEco.getPluginManager().getPlugin(PLUGIN_NAME);
            EzEconomyPlugin ezEconomyPlugin = instance = plugin instanceof EzEconomyPlugin ? (EzEconomyPlugin)plugin : null;
            StorageProvider storage = ezEconomyPlugin != null ? ezEconomyPlugin.getStorage() : null;
            ezEconomyAPI = new EzEconomyAPI(storage);
        } else {
            ezEconomyAPI = null;
        }
        return ezEconomyAPI;
    }

    @Override
    public boolean canRegister() {
        Plugin plugin = this.liteEco.getPluginManager().getPlugin(PLUGIN_NAME);
        return !this.getRegistered() && plugin != null && Companion.isEzEconomyPresent();
    }

    @Override
    public void register() {
        this.setRegistered(this.getEconomyHandler() != null);
    }

    @Override
    public void unregister() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final double getBalance(@NotNull UUID uuid, @Nullable String currency) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        try {
            EzEconomyAPI ezEconomyAPI = this.getEconomyHandler();
            EzEconomyAPI ezEconomyAPI2 = ezEconomyAPI;
            if (ezEconomyAPI == null) return 0.0;
            String string = currency;
            if (string == null) {
                EzEconomyAPI ezEconomyAPI3 = this.getEconomyHandler();
                string = ezEconomyAPI3 != null ? ezEconomyAPI3.getDefaultCurrency() : null;
            }
            PlayerBalanceDTO playerBalanceDTO = ezEconomyAPI2.getBalance(uuid, string);
            ezEconomyAPI2 = playerBalanceDTO;
            if (playerBalanceDTO == null) return 0.0;
            double d = ezEconomyAPI2.getBalance();
            return d;
        }
        catch (Exception e) {
            this.liteEco.getComponentLogger().warn("Failed to get EzEconomy balance for " + uuid + ": " + e.getMessage());
            return 0.0;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/economy/ezeconomy/EzEconomyHook$Companion;", "", "<init>", "()V", "PLUGIN_NAME", "", "isEzEconomyPresent", "", "LiteEco"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEzEconomyPresent() {
            return ClassUtil.INSTANCE.isValidClasspath("com.skyblockexp.ezeconomy.core.EzEconomyPlugin");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

