/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.extensions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0002\u001a\"\u0010\u0006\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u001a\u001a\u0010\n\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u001a*\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0016"}, d2={"units", "", "", "[Ljava/lang/String;", "toValidDecimal", "Ljava/math/BigDecimal;", "compactFormat", "pattern", "compactPattern", "locale", "moneyFormat", "formatNumber", "number", "compacted", "", "decompressNumber", "str", "compactNumber", "Lkotlin/Pair;", "getLocale", "Ljava/util/Locale;", "localeStr", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nMoneyFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoneyFormat.kt\ncom/github/encryptsl/lite/eco/common/extensions/MoneyFormatKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n3938#2:85\n4474#2,2:86\n1080#3:88\n296#3,2:89\n*S KotlinDebug\n*F\n+ 1 MoneyFormat.kt\ncom/github/encryptsl/lite/eco/common/extensions/MoneyFormatKt\n*L\n47#1:85\n47#1:86,2\n48#1:88\n49#1:89,2\n*E\n"})
public final class MoneyFormatKt {
    @NotNull
    private static final String[] units;

    @Nullable
    public static final BigDecimal toValidDecimal(@NotNull String $this$toValidDecimal) {
        Intrinsics.checkNotNullParameter((Object)$this$toValidDecimal, (String)"<this>");
        String s = ((Object)StringsKt.trim((CharSequence)$this$toValidDecimal)).toString();
        if (StringsKt.isBlank((CharSequence)s) || StringsKt.contains$default((CharSequence)s, (CharSequence)" ", (boolean)false, (int)2, null)) {
            return null;
        }
        return MoneyFormatKt.decompressNumber(s);
    }

    @NotNull
    public static final String compactFormat(@NotNull BigDecimal $this$compactFormat, @NotNull String pattern, @NotNull String compactPattern, @NotNull String locale) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$compactFormat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)compactPattern, (String)"compactPattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Pair<BigDecimal, String> pair = MoneyFormatKt.compactNumber($this$compactFormat);
        if (pair != null) {
            Pair<BigDecimal, String> pair2 = pair;
            BigDecimal value = (BigDecimal)pair2.component1();
            String unit = (String)pair2.component2();
            object = MoneyFormatKt.formatNumber(value, compactPattern, locale, true) + unit;
        } else {
            object = MoneyFormatKt.formatNumber$default($this$compactFormat, pattern, locale, false, 8, null);
        }
        return object;
    }

    @NotNull
    public static final String moneyFormat(@NotNull BigDecimal $this$moneyFormat, @NotNull String pattern, @NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)$this$moneyFormat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return MoneyFormatKt.formatNumber$default($this$moneyFormat, pattern, locale, false, 8, null);
    }

    private static final String formatNumber(BigDecimal number, String pattern, String locale, boolean compacted) {
        DecimalFormat decimalFormat;
        DecimalFormat $this$formatNumber_u24lambda_u240 = decimalFormat = new DecimalFormat();
        boolean bl = false;
        $this$formatNumber_u24lambda_u240.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(MoneyFormatKt.getLocale(locale)));
        $this$formatNumber_u24lambda_u240.setRoundingMode(compacted ? RoundingMode.HALF_UP : RoundingMode.HALF_UP);
        $this$formatNumber_u24lambda_u240.applyPattern(pattern);
        DecimalFormat formatter = decimalFormat;
        String string = formatter.format(number);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    static /* synthetic */ String formatNumber$default(BigDecimal bigDecimal, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return MoneyFormatKt.formatNumber(bigDecimal, string, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final BigDecimal decompressNumber(String str) {
        BigDecimal bigDecimal;
        Object v3;
        String upper;
        block4: {
            void $this$filterTo$iv$iv;
            String string = ((Object)StringsKt.trim((CharSequence)str)).toString();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            upper = string2;
            String[] $this$filter$iv = units;
            boolean $i$f$filter = false;
            String[] stringArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            Iterable $this$firstOrNull$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    String it = (String)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.length());
                    it = (String)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.length()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.endsWith$default((String)upper, (String)it, (boolean)false, (int)2, null)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        String unit = v3;
        if (unit != null) {
            int index = ArraysKt.indexOf((Object[])units, (Object)unit);
            String numberPart = StringsKt.removeSuffix((String)upper, (CharSequence)unit);
            BigDecimal bigDecimal2 = StringsKt.toBigDecimalOrNull((String)numberPart);
            bigDecimal = bigDecimal2 != null ? bigDecimal2.multiply(BigDecimal.TEN.pow(index * 3)) : null;
        } else {
            bigDecimal = StringsKt.toBigDecimalOrNull((String)str);
        }
        return bigDecimal;
    }

    private static final Pair<BigDecimal, String> compactNumber(BigDecimal number) {
        if (number.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigInteger bigInteger = number.abs().toBigInteger();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"toBigInteger(...)");
        BigInteger absIntPart = bigInteger;
        if (Intrinsics.areEqual((Object)absIntPart, (Object)BigInteger.ZERO)) {
            return null;
        }
        int digits = absIntPart.toString().length();
        int unitIndex = (digits - 1) / 3;
        if (unitIndex == 0) {
            return null;
        }
        int index = unitIndex >= units.length ? units.length - 1 : unitIndex;
        BigDecimal divisor = BigDecimal.TEN.pow(index * 3);
        BigDecimal scaled = number.divide(divisor, 1, RoundingMode.HALF_UP);
        return TuplesKt.to((Object)scaled, (Object)units[index]);
    }

    private static final Locale getLocale(String localeStr) {
        Locale locale = Locale.forLanguageTag(StringsKt.replace$default((String)localeStr, (char)'_', (char)'-', (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(...)");
        return locale;
    }

    static {
        String[] stringArray = new String[]{"", "K", "M", "B", "T", "Q", "Qn", "S", "Se", "O", "N", "D"};
        units = stringArray;
    }
}

