/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.database;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.interfaces.DatabaseConnectorProvider;
import com.github.encryptsl.lite.eco.common.database.DatabaseConfigLoader;
import com.github.encryptsl.lite.eco.common.database.tables.Account;
import com.github.encryptsl.lite.eco.common.database.tables.MonologTable;
import com.github.encryptsl.lite.eco.common.extensions.DatabaseLoggerTransactionKt;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.flywaydb.core.Flyway;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.DatabaseConfig;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.dao.id.LongIdTable;
import org.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.exposed.v1.jdbc.SchemaUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/encryptsl/lite/eco/common/database/DatabaseConnector;", "Lcom/github/encryptsl/lite/eco/api/interfaces/DatabaseConnectorProvider;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "hikari", "Lcom/zaxxer/hikari/HikariDataSource;", "onLoad", "", "initConnect", "driver", "", "jdbcHost", "user", "pass", "onDisable", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nDatabaseConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseConnector.kt\ncom/github/encryptsl/lite/eco/common/database/DatabaseConnector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,81:1\n1586#2:82\n1661#2,3:83\n37#3,2:86\n*S KotlinDebug\n*F\n+ 1 DatabaseConnector.kt\ncom/github/encryptsl/lite/eco/common/database/DatabaseConnector\n*L\n61#1:82\n61#1:83,3\n61#1:86,2\n*E\n"})
public final class DatabaseConnector
implements DatabaseConnectorProvider {
    @NotNull
    private final LiteEco liteEco;
    @Nullable
    private HikariDataSource hikari;

    public DatabaseConnector(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
    }

    @Override
    public void onLoad() {
        FileConfiguration fileConfiguration = this.liteEco.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)fileConfiguration, (String)"getConfig(...)");
        DatabaseConfigLoader configLoader = new DatabaseConfigLoader((ConfigurationSection)fileConfiguration);
        DatabaseConfigLoader.DbConfig dbConfig = configLoader.load();
        String driver = dbConfig.component1();
        String jdbcUrl = dbConfig.component2();
        String username = dbConfig.component3();
        String password = dbConfig.component4();
        try {
            this.initConnect(driver, jdbcUrl, username, password);
            this.liteEco.getLogger().info("\u2705 Database connection established successfully.");
        }
        catch (Exception e) {
            this.liteEco.getLogger().error("\u274c Database failed to initialize: " + e.getMessage());
            this.liteEco.getPluginManager().disablePlugin((Plugin)this.liteEco);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initConnect(@NotNull String driver, @NotNull String jdbcHost, @NotNull String user, @NotNull String pass) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)jdbcHost, (String)"jdbcHost");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
        try {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            void $this$initConnect_u24lambda_u240;
            String[] stringArray;
            String[] stringArray2 = stringArray = new HikariDataSource();
            Object object = this;
            boolean bl = false;
            $this$initConnect_u24lambda_u240.setDriverClassName(driver);
            $this$initConnect_u24lambda_u240.setJdbcUrl(jdbcHost);
            $this$initConnect_u24lambda_u240.setUsername(user);
            $this$initConnect_u24lambda_u240.setPassword(pass);
            $this$initConnect_u24lambda_u240.setPoolName(((Object)((Object)this.liteEco)).getClass().getSimpleName());
            $this$initConnect_u24lambda_u240.setMaximumPoolSize(20);
            $this$initConnect_u24lambda_u240.setReadOnly(false);
            $this$initConnect_u24lambda_u240.setTransactionIsolation("TRANSACTION_SERIALIZABLE");
            ((DatabaseConnector)object).hikari = stringArray;
            stringArray = new String[]{"classpath:db/migration"};
            Flyway.configure().locations(stringArray).table("lite_eco_schema_history").baselineOnMigrate(true).dataSource((DataSource)this.hikari).load().migrate();
            HikariDataSource hikariDataSource = this.hikari;
            Intrinsics.checkNotNull((Object)hikariDataSource);
            Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)((DataSource)hikariDataSource), null, (DatabaseConfig)DatabaseConfig.Companion.invoke(DatabaseConnector::initConnect$lambda$1), null, null, (int)26, null);
            Iterable $this$map$iv = this.liteEco.getCurrencyImpl().getCurrenciesKeys();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(new Account((String)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Account[] tables = thisCollection$iv.toArray(new Account[0]);
            DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseConnector.initConnect$lambda$3(tables, arg_0), 1, null);
        }
        catch (Exception e) {
            this.liteEco.getLogger().error("Database initialization failed: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisable() {
        try {
            HikariDataSource hikariDataSource = this.hikari;
            if (hikariDataSource != null) {
                hikariDataSource.close();
            }
            this.liteEco.getLogger().info("\u2705 Database connection closed cleanly.");
        }
        catch (Exception e) {
            this.liteEco.getLogger().error("\u26a0\ufe0f Failed to close database connection: " + e.getMessage());
        }
        finally {
            this.hikari = null;
        }
    }

    private static final Unit initConnect$lambda$1(DatabaseConfig.Builder $this$DatabaseConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$DatabaseConfig, (String)"$this$DatabaseConfig");
        $this$DatabaseConfig.setPreserveKeywordCasing(true);
        return Unit.INSTANCE;
    }

    private static final Unit initConnect$lambda$3(Account[] $tables, Transaction $this$loggedTransaction) {
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)$tables);
        spreadBuilder.add((Object)MonologTable.INSTANCE);
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])((Table[])spreadBuilder.toArray((Object[])new LongIdTable[spreadBuilder.size()])), (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }
}

