/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.config;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.objects.ModernText;
import com.tchristofferson.configupdater.ConfigUpdater;
import java.io.Closeable;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d2\u0006\u0010\u0019\u001a\u00020\u0014J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020!H\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0014J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0014J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0006\u0010)\u001a\u00020!J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dJ\u000e\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u0014J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006."}, d2={"Lcom/github/encryptsl/lite/eco/common/config/Locales;", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "langYml", "Lorg/bukkit/configuration/file/FileConfiguration;", "fallbackYml", "config", "getConfig", "()Lorg/bukkit/configuration/file/FileConfiguration;", "logger", "Lnet/kyori/adventure/text/logger/slf4j/ComponentLogger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lnet/kyori/adventure/text/logger/slf4j/ComponentLogger;", "localeDir", "Ljava/io/File;", "prefix", "", "getPrefix", "()Ljava/lang/String;", "translation", "Lnet/kyori/adventure/text/Component;", "translationKey", "tagResolver", "Lnet/kyori/adventure/text/minimessage/tag/resolver/TagResolver;", "translationList", "", "plainTextTranslation", "component", "load", "", "loadEnUs", "setLocale", "", "localeCode", "getMessage", "key", "getList", "reloadCurrentLocale", "availableLocales", "isLocaleAvailable", "locale", "availableLocalesFromJar", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nLocales.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Locales.kt\ncom/github/encryptsl/lite/eco/common/config/Locales\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,177:1\n1586#2:178\n1661#2,3:179\n1586#2:182\n1661#2,3:183\n1642#2,10:187\n1915#2:197\n1916#2:199\n1652#2:200\n1586#2:204\n1661#2,3:205\n1#3:186\n1#3:198\n3938#4:201\n4474#4,2:202\n*S KotlinDebug\n*F\n+ 1 Locales.kt\ncom/github/encryptsl/lite/eco/common/config/Locales\n*L\n36#1:178\n36#1:179,3\n40#1:182\n40#1:183,3\n138#1:187,10\n138#1:197\n138#1:199\n138#1:200\n150#1:204\n150#1:205,3\n138#1:198\n149#1:201\n149#1:202,2\n*E\n"})
public final class Locales {
    @NotNull
    private final LiteEco liteEco;
    private FileConfiguration langYml;
    private FileConfiguration fallbackYml;
    @NotNull
    private final File localeDir;

    public Locales(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
        this.localeDir = new File(this.liteEco.getDataFolder(), "locale");
    }

    private final FileConfiguration getConfig() {
        FileConfiguration fileConfiguration = this.liteEco.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)fileConfiguration, (String)"getConfig(...)");
        return fileConfiguration;
    }

    private final ComponentLogger getLogger() {
        return this.liteEco.getLogger();
    }

    @NotNull
    public final String getPrefix() {
        String string = this.getConfig().getString("plugin.prefix");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final Component translation(@NotNull String translationKey) {
        Intrinsics.checkNotNullParameter((Object)translationKey, (String)"translationKey");
        return ModernText.miniModernText(this.getMessage(translationKey));
    }

    @NotNull
    public final Component translation(@NotNull String translationKey, @NotNull TagResolver tagResolver) {
        Intrinsics.checkNotNullParameter((Object)translationKey, (String)"translationKey");
        Intrinsics.checkNotNullParameter((Object)tagResolver, (String)"tagResolver");
        return ModernText.miniModernText(this.getMessage(translationKey), tagResolver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Component> translationList(@NotNull String translationKey) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)translationKey, (String)"translationKey");
        Iterable $this$map$iv = this.getList(translationKey);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ModernText.miniModernText((String)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Component> translationList(@NotNull String translationKey, @NotNull TagResolver tagResolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)translationKey, (String)"translationKey");
        Intrinsics.checkNotNullParameter((Object)tagResolver, (String)"tagResolver");
        Iterable $this$map$iv = this.getList(translationKey);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ModernText.miniModernText((String)it, tagResolver));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String plainTextTranslation(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        String string = PlainTextComponentSerializer.plainText().serialize(component);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        return string;
    }

    public final void load() {
        CharSequence charSequence;
        this.loadEnUs();
        String string = this.getConfig().getString("plugin.translation");
        if (string == null) {
            string = "";
        }
        String selected = string;
        Locales locales = this;
        CharSequence charSequence2 = selected;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            Locales locales2 = locales;
            boolean bl = false;
            charSequence = "en_us";
            locales = locales2;
        } else {
            charSequence = charSequence2;
        }
        locales.setLocale((String)charSequence);
    }

    private final void loadEnUs() {
        String fileName = "en_us.yml";
        File file = new File(this.localeDir, fileName);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            this.liteEco.saveResource("locale/" + fileName, false);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(...)");
        this.fallbackYml = (FileConfiguration)yamlConfiguration;
    }

    public final boolean setLocale(@NotNull String localeCode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)localeCode, (String)"localeCode");
        String string = localeCode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String normalizedLocale = string;
        String fileName = normalizedLocale + ".yml";
        File file = new File(this.localeDir, fileName);
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                String resourcePath = "locale/" + fileName;
                if (this.liteEco.getResource(resourcePath) != null) {
                    this.liteEco.saveResource(resourcePath, false);
                } else {
                    this.getLogger().warn("\u26a0\ufe0f Translation resource '" + resourcePath + "' not found. Falling back to en_us.");
                    if (!Intrinsics.areEqual((Object)normalizedLocale, (Object)"en_us")) {
                        FileConfiguration fileConfiguration = this.fallbackYml;
                        if (fileConfiguration == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"fallbackYml");
                            fileConfiguration = null;
                        }
                        this.langYml = fileConfiguration;
                        return true;
                    }
                    return false;
                }
            }
            ConfigUpdater.update((Plugin)((Plugin)this.liteEco), (String)("locale/" + fileName), (File)file, (String[])new String[0]);
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(...)");
            this.langYml = (FileConfiguration)yamlConfiguration;
            this.getConfig().set("plugin.translation", (Object)normalizedLocale);
            this.liteEco.saveConfig();
            this.getLogger().info("\u2705 Translation loaded: " + fileName);
            bl = true;
        }
        catch (Exception exception) {
            this.getLogger().warn("\u26a0\ufe0f Failed to load translation for " + localeCode);
            if (this.fallbackYml != null) {
                FileConfiguration fileConfiguration = this.fallbackYml;
                if (fileConfiguration == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"fallbackYml");
                    fileConfiguration = null;
                }
                this.langYml = fileConfiguration;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String getMessage(@NotNull String key) {
        String raw;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        FileConfiguration fileConfiguration = this.langYml;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"langYml");
            fileConfiguration = null;
        }
        if ((raw = fileConfiguration.getString(key)) == null && this.fallbackYml != null) {
            FileConfiguration fileConfiguration2 = this.fallbackYml;
            if (fileConfiguration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fallbackYml");
                fileConfiguration2 = null;
            }
            raw = fileConfiguration2.getString(key);
        }
        if (raw == null) {
            String missingFormat;
            Object object;
            String string;
            String missingKey = "messages.admin.translation_missing";
            FileConfiguration fileConfiguration3 = this.langYml;
            if (fileConfiguration3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"langYml");
                fileConfiguration3 = null;
            }
            if ((string = fileConfiguration3.getString(missingKey)) == null) {
                FileConfiguration fileConfiguration4 = this.fallbackYml;
                if (fileConfiguration4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"fallbackYml");
                    fileConfiguration4 = null;
                }
                string = fileConfiguration4.getString(missingKey);
            }
            if ((object = (missingFormat = string)) == null || (object = StringsKt.replace$default((String)object, (String)"<key>", (String)key, (boolean)false, (int)4, null)) == null || (object = StringsKt.replace$default((String)object, (String)"<prefix>", (String)this.getPrefix(), (boolean)false, (int)4, null)) == null) {
                object = "Translation missing: " + key;
            }
            return object;
        }
        return StringsKt.replace$default((String)raw, (String)"<prefix>", (String)this.getPrefix(), (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getList(String key) {
        List list;
        List list2;
        List list3;
        FileConfiguration fileConfiguration = this.langYml;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"langYml");
            fileConfiguration = null;
        }
        if ((list3 = fileConfiguration.getList(key)) == null) {
            if (this.fallbackYml != null) {
                FileConfiguration fileConfiguration2 = this.fallbackYml;
                if (fileConfiguration2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"fallbackYml");
                    fileConfiguration2 = null;
                }
                list3 = fileConfiguration2.getList(key);
            } else {
                list3 = null;
            }
        }
        List list4 = list2 = list3;
        if (list4 != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list4;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl2 = false;
                Object t = it;
                if ((t != null && (t = t.toString()) != null ? StringsKt.replace$default(t, (String)"<prefix>", (String)this.getPrefix(), (boolean)false, (int)4, null) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void reloadCurrentLocale() {
        CharSequence charSequence;
        String string = this.getConfig().getString("plugin.translation");
        if (string == null) {
            string = "";
        }
        String current = string;
        Locales locales = this;
        CharSequence charSequence2 = current;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            Locales locales2 = locales;
            boolean bl = false;
            charSequence = "en_us";
            locales = locales2;
        } else {
            charSequence = charSequence2;
        }
        locales.setLocale((String)charSequence);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<String> availableLocales() {
        block9: {
            block8: {
                var2_1 = this;
                try {
                    $this$availableLocales_u24lambda_u240 = var2_1;
                    $i$a$-runCatching-Locales$availableLocales$fromJar$1 = false;
                    $this$availableLocales_u24lambda_u240 = Result.constructor-impl(super.availableLocalesFromJar());
                }
                catch (Throwable $i$a$-runCatching-Locales$availableLocales$fromJar$1) {
                    $this$availableLocales_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-Locales$availableLocales$fromJar$1));
                }
                var2_1 = $this$availableLocales_u24lambda_u240;
                v0 = Result.exceptionOrNull-impl((Object)var2_1);
                if (v0 == null) {
                    v1 = var2_1;
                } else {
                    it = v0;
                    $i$a$-getOrElse-Locales$availableLocales$fromJar$2 = false;
                    v1 = CollectionsKt.emptyList();
                }
                fromJar = (List)v1;
                var3_2 = this.localeDir.listFiles();
                if (var3_2 == null) break block8;
                var5_6 = var3_2;
                $i$f$filter = false;
                var7_9 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    it = element$iv$iv;
                    $i$a$-filter-Locales$availableLocales$fromDisk$1 = false;
                    if (!it.isFile()) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)it);
                    if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"yml")) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $i$f$filter = (List)destination$iv$iv;
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (File)item$iv$iv;
                    var15_20 = destination$iv$iv;
                    $i$a$-map-Locales$availableLocales$fromDisk$2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    v3 = FilesKt.getNameWithoutExtension((File)it).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
                    var15_20.add(v3);
                }
                v4 = (List)destination$iv$iv;
                break block9;
            }
            v4 = CollectionsKt.emptyList();
        }
        fromDisk = v4;
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)fromJar, (Iterable)fromDisk));
    }

    public final boolean isLocaleAvailable(@NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string = locale.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String normalized = string;
        return this.availableLocales().contains(normalized) || this.liteEco.getResource("locale/" + normalized + ".yml") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> availableLocalesFromJar() {
        List locales = new ArrayList();
        URL jarUrl = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        JarFile jarFile = new JarFile(new File(jarUrl.toURI()));
        Closeable closeable = jarFile;
        Throwable throwable = null;
        try {
            JarFile jar = (JarFile)closeable;
            boolean bl = false;
            Enumeration<JarEntry> enumeration = jar.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            Iterator iterator2 = CollectionsKt.iterator(enumeration);
            while (iterator2.hasNext()) {
                JarEntry entry = (JarEntry)iterator2.next();
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"locale/", (boolean)false, (int)2, null)) continue;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string2, (String)".yml", (boolean)false, (int)2, null)) continue;
                String string3 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                String localeName = StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)string3, (String)"locale/", null, (int)2, null), (String)".yml", null, (int)2, null);
                String string4 = localeName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                locales.add(string4);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return locales;
    }
}

