/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.commands.admin.subcommands;

import com.github.encryptsl.lite.eco.commands.internal.CommandFeature;
import com.github.encryptsl.lite.eco.common.database.models.DatabaseEcoModel;
import com.github.encryptsl.lite.eco.utils.Helper;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.incendo.cloud.Command;
import org.incendo.cloud.bukkit.parser.OfflinePlayerParser;
import org.incendo.cloud.bukkit.parser.PlayerParser;
import org.incendo.cloud.component.DefaultValue;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.paper.PaperCommandManager;
import org.incendo.cloud.paper.util.sender.Source;
import org.incendo.cloud.parser.standard.IntegerParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/encryptsl/lite/eco/commands/admin/subcommands/EcoDebugCmd;", "Lcom/github/encryptsl/lite/eco/commands/internal/CommandFeature;", "helper", "Lcom/github/encryptsl/lite/eco/utils/Helper;", "<init>", "(Lcom/github/encryptsl/lite/eco/utils/Helper;)V", "register", "", "commandManager", "Lorg/incendo/cloud/paper/PaperCommandManager;", "Lorg/incendo/cloud/paper/util/sender/Source;", "base", "Lorg/incendo/cloud/Command$Builder;", "LiteEco"})
public final class EcoDebugCmd
implements CommandFeature {
    @NotNull
    private final Helper helper;

    public EcoDebugCmd(@NotNull Helper helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        this.helper = helper;
    }

    @Override
    public void register(@NotNull PaperCommandManager<Source> commandManager, @NotNull Command.Builder<Source> base) {
        Intrinsics.checkNotNullParameter(commandManager, (String)"commandManager");
        Intrinsics.checkNotNullParameter(base, (String)"base");
        Command.Builder builder = base.literal("debug", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"literal(...)");
        Command.Builder debugSubCommand = builder;
        commandManager.command(debugSubCommand.literal("failmode", new String[0]).commandDescription(Description.description((String)"Toggle database failure simulation (writes will fail).")).permission("lite.eco.admin.debug.failmode").handler(EcoDebugCmd::register$lambda$0));
        commandManager.command(debugSubCommand.literal("test-janitor", new String[0]).commandDescription(Description.description((String)"Run automated persistence test (failMode + deposit).")).required("target", PlayerParser.playerParser()).permission("lite.eco.admin.debug.testjanitor").handler(arg_0 -> EcoDebugCmd.register$lambda$1(this, arg_0)));
        commandManager.command(debugSubCommand.literal("janitor", new String[0]).commandDescription(Description.description((String)"Force immediate synchronization of all offline players in cache.")).permission("lite.eco.admin.debug.janitor").handler(arg_0 -> EcoDebugCmd.register$lambda$2(this, arg_0)));
        commandManager.command(debugSubCommand.literal("inspect", new String[0]).commandDescription(Description.description((String)"View detailed cache content (failed currencies) for a player.")).required("target", OfflinePlayerParser.offlinePlayerParser()).permission("lite.eco.admin.debug.inspect").handler(arg_0 -> EcoDebugCmd.register$lambda$3(this, arg_0)));
        commandManager.command(debugSubCommand.literal("stress", new String[0]).commandDescription(Description.description((String)"Run simultaneous stress test of transaction atomicity.")).required("target", PlayerParser.playerParser()).optional("iterations", IntegerParser.integerParser((int)1, (int)1000), DefaultValue.constant((Object)100)).permission("lite.eco.admin.debug.stress").handler(arg_0 -> EcoDebugCmd.register$lambda$4(this, arg_0)));
    }

    private static final void register$lambda$0(CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DatabaseEcoModel.Companion.setDebugFailMode(!DatabaseEcoModel.Companion.getDebugFailMode());
        String status = DatabaseEcoModel.Companion.getDebugFailMode() ? "\u00a7cENABLED (Error)" : "\u00a7aDISABLED (OK)";
        ((Source)context.sender()).source().sendMessage("\u00a78[\u00a7bLiteEco\u00a78] \u00a77Simulated DB failure: " + status);
    }

    private static final void register$lambda$1(EcoDebugCmd this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.get("target");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Player target = (Player)object;
        this$0.helper.executeJanitorTest$LiteEco(target);
    }

    private static final void register$lambda$2(EcoDebugCmd this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Helper helper = this$0.helper;
        CommandSender commandSender = ((Source)context.sender()).source();
        Intrinsics.checkNotNullExpressionValue((Object)commandSender, (String)"source(...)");
        helper.forceJanitorSync$LiteEco(commandSender);
    }

    private static final void register$lambda$3(EcoDebugCmd this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.get("target");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        OfflinePlayer target = (OfflinePlayer)object;
        Helper helper = this$0.helper;
        CommandSender commandSender = ((Source)context.sender()).source();
        Intrinsics.checkNotNullExpressionValue((Object)commandSender, (String)"source(...)");
        UUID uUID = target.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        helper.inspectCache$LiteEco(commandSender, uUID);
    }

    private static final void register$lambda$4(EcoDebugCmd this$0, CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.get("target");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Player target = (Player)object;
        Object object2 = context.get("iterations");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        int iterations = ((Number)object2).intValue();
        this$0.helper.executeStressTest$LiteEco(target, 1.0, iterations);
    }
}

