/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.api;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.metrics.bukkit.Metrics;
import com.github.encryptsl.metrics.charts.AdvancedPie;
import com.github.encryptsl.metrics.charts.SingleLineChart;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/github/encryptsl/lite/eco/api/MetricsCollector;", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "serviceId", "", "transactions", "", "", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;ILjava/util/Map;)V", "metrics", "Lcom/github/encryptsl/metrics/bukkit/Metrics;", "getMetrics", "()Lcom/github/encryptsl/metrics/bukkit/Metrics;", "metrics$delegate", "Lkotlin/Lazy;", "setupMetrics", "", "setupMetrics$LiteEco", "registerCharts", "LiteEco"})
public final class MetricsCollector {
    @NotNull
    private final LiteEco liteEco;
    private final int serviceId;
    @NotNull
    private final Map<String, Integer> transactions;
    @NotNull
    private final Lazy metrics$delegate;

    public MetricsCollector(@NotNull LiteEco liteEco, int serviceId, @NotNull Map<String, Integer> transactions) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        Intrinsics.checkNotNullParameter(transactions, (String)"transactions");
        this.liteEco = liteEco;
        this.serviceId = serviceId;
        this.transactions = transactions;
        this.metrics$delegate = LazyKt.lazy(() -> MetricsCollector.metrics_delegate$lambda$0(this));
    }

    private final Metrics getMetrics() {
        Lazy lazy = this.metrics$delegate;
        return (Metrics)lazy.getValue();
    }

    public final void setupMetrics$LiteEco() {
        if (this.liteEco.getConfig().getBoolean("plugin.metrics", true)) {
            this.registerCharts();
        }
    }

    private final void registerCharts() {
        this.getMetrics().addCustomChart(new SingleLineChart("transactions", () -> MetricsCollector.registerCharts$lambda$0(this)));
        this.getMetrics().addCustomChart(new AdvancedPie("used_language", () -> MetricsCollector.registerCharts$lambda$1(this)));
    }

    private static final Metrics metrics_delegate$lambda$0(MetricsCollector this$0) {
        return new Metrics((Plugin)this$0.liteEco, this$0.serviceId);
    }

    private static final Integer registerCharts$lambda$0(MetricsCollector this$0) {
        return this$0.transactions.get("transactions");
    }

    private static final Map registerCharts$lambda$1(MetricsCollector this$0) {
        Map map2 = new LinkedHashMap();
        String string = this$0.liteEco.getConfig().getString("plugin.translation");
        if (string == null) {
            string = "en_us";
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String lang = string2;
        map2.put(lang, 1);
        return map2;
    }
}

