/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.listeners;

import com.github.encryptsl.lite.eco.LiteEco;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/encryptsl/lite/eco/listeners/PlayerListeners;", "Lorg/bukkit/event/Listener;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "preventSync", "", "Ljava/util/UUID;", "onPreLogin", "", "event", "Lorg/bukkit/event/player/AsyncPlayerPreLoginEvent;", "onKick", "Lorg/bukkit/event/player/PlayerKickEvent;", "onQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "LiteEco"})
public final class PlayerListeners
implements Listener {
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    private final Set<UUID> preventSync;

    public PlayerListeners(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
        this.preventSync = new LinkedHashSet();
    }

    @EventHandler
    public final void onPreLogin(@NotNull AsyncPlayerPreLoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UUID uUID = event.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        UUID uuid = uUID;
        String string = event.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String username = string;
        this.liteEco.getAccountManager().createOrUpdateAndCache(uuid, username);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onKick(@NotNull PlayerKickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = PlainTextComponentSerializer.plainText().serialize(event.reason());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        String reason = string;
        if (StringsKt.contains((CharSequence)reason, (CharSequence)"logged in from another location", (boolean)true)) {
            UUID uUID = event.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            this.preventSync.add(uUID);
        }
    }

    @EventHandler
    public final void onQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        UUID uuid = uUID;
        if (this.preventSync.contains(uuid)) {
            this.preventSync.remove(uuid);
            this.liteEco.getLogger().info("Skipping account sync for " + player2.getName() + " (Duplicate login detected - data protection).");
            return;
        }
        if (event.getReason() == PlayerQuitEvent.QuitReason.ERRONEOUS_STATE) {
            this.liteEco.getLogger().warn("Skipping account sync for " + player2.getName() + " (Erroneous connection state).");
            return;
        }
        this.liteEco.getAccountManager().syncAccount(uuid);
    }
}

