/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.manager.importer;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.interfaces.EconomyImporter;
import com.github.encryptsl.lite.eco.common.manager.importer.EconomyImportResults;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.BetterEconomyImporter;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.EssentialsXImporter;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.EzEconomyImporter;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.PlayerPointsImporter;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.ScruffyBoyImporter;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.SimpleEconomyImporter;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.TheosisEconomyImporter;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0086@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/github/encryptsl/lite/eco/common/manager/importer/ImportEconomy;", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "importers", "", "", "Lcom/github/encryptsl/lite/eco/api/interfaces/EconomyImporter;", "getImporters$LiteEco", "()Ljava/util/Map;", "registerImporter", "", "importer", "import", "Lcom/github/encryptsl/lite/eco/common/manager/importer/EconomyImportResults;", "pluginName", "intoCurrency", "fromCurrency", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "LiteEco"})
public final class ImportEconomy {
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    private final Map<String, EconomyImporter> importers;

    public ImportEconomy(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
        this.importers = new LinkedHashMap();
        this.registerImporter(new EssentialsXImporter(this.liteEco));
        this.registerImporter(new PlayerPointsImporter(this.liteEco));
        this.registerImporter(new BetterEconomyImporter(this.liteEco));
        this.registerImporter(new ScruffyBoyImporter(this.liteEco));
        this.registerImporter(new EzEconomyImporter(this.liteEco));
        this.registerImporter(new SimpleEconomyImporter(this.liteEco));
        this.registerImporter(new TheosisEconomyImporter(this.liteEco));
    }

    @NotNull
    public final Map<String, EconomyImporter> getImporters$LiteEco() {
        return this.importers;
    }

    private final void registerImporter(EconomyImporter importer) {
        this.importers.put(importer.getName(), importer);
    }

    @Nullable
    public final Object import(@NotNull String pluginName, @NotNull String intoCurrency, @Nullable String fromCurrency, @NotNull Continuation<? super EconomyImportResults> $completion) {
        if (!this.liteEco.getDatabaseEcoModel().getUUIDNameMap(intoCurrency).isEmpty()) {
            throw new Exception("lite_eco_" + intoCurrency + " table is not empty !");
        }
        EconomyImporter economyImporter = this.importers.get(pluginName);
        if (economyImporter == null) {
            throw new IllegalArgumentException("Importer " + pluginName + " not found");
        }
        EconomyImporter importer = economyImporter;
        if (importer.isMultiCurrency() && fromCurrency == null) {
            throw new IllegalArgumentException("The plugin '" + pluginName + "' requires a source currency. Usage: /eco database import " + pluginName + " " + intoCurrency + " --from <currency>");
        }
        return importer.import(pluginName, intoCurrency, fromCurrency, $completion);
    }
}

