/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.hook.economy.bettereconomy;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.common.hook.HookListener;
import com.github.encryptsl.lite.eco.utils.ClassUtil;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.hsgamer.bettereconomy.BetterEconomy;
import me.hsgamer.bettereconomy.holder.EconomyHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/economy/bettereconomy/BetterEconomyHook;", "Lcom/github/encryptsl/lite/eco/common/hook/HookListener;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "economyHandler", "Lme/hsgamer/bettereconomy/holder/EconomyHolder;", "getEconomyHandler", "()Lme/hsgamer/bettereconomy/holder/EconomyHolder;", "canRegister", "", "register", "", "unregister", "getBalance", "", "uuid", "Ljava/util/UUID;", "Companion", "LiteEco"})
public final class BetterEconomyHook
extends HookListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    public static final String PLUGIN_NAME = "BetterEconomy";

    public BetterEconomyHook(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        super(PLUGIN_NAME, "You can now export economy from plugin BetterEconomy to LiteEco with /eco database import BetterEconomy <into_currency>");
        this.liteEco = liteEco;
    }

    private final EconomyHolder getEconomyHandler() {
        EconomyHolder economyHolder;
        if (Companion.isBetterEconomyPresent()) {
            BetterEconomy instance;
            Plugin plugin = this.liteEco.getPluginManager().getPlugin(PLUGIN_NAME);
            BetterEconomy betterEconomy = instance = plugin instanceof BetterEconomy ? (BetterEconomy)plugin : null;
            economyHolder = betterEconomy != null ? (EconomyHolder)betterEconomy.get(EconomyHolder.class) : null;
        } else {
            economyHolder = null;
        }
        return economyHolder;
    }

    @Override
    public boolean canRegister() {
        Plugin plugin = this.liteEco.getPluginManager().getPlugin(PLUGIN_NAME);
        return !this.getRegistered() && plugin != null && Companion.isBetterEconomyPresent();
    }

    @Override
    public void register() {
        this.setRegistered(this.getEconomyHandler() != null);
    }

    @Override
    public void unregister() {
    }

    public final double getBalance(@NotNull UUID uuid) {
        double d;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        try {
            EconomyHolder economyHolder = this.getEconomyHandler();
            d = economyHolder != null ? economyHolder.get(uuid) : 0.0;
        }
        catch (Exception e) {
            this.liteEco.getComponentLogger().warn("Failed to get BetterEconomy balance for " + uuid + ": " + e.getMessage());
            d = 0.0;
        }
        return d;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/economy/bettereconomy/BetterEconomyHook$Companion;", "", "<init>", "()V", "PLUGIN_NAME", "", "isBetterEconomyPresent", "", "LiteEco"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isBetterEconomyPresent() {
            return ClassUtil.INSTANCE.isValidClasspath("me.hsgamer.bettereconomy.BetterEconomy");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

