/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.database.models.legacy;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.migrator.entity.PlayerBalances;
import com.github.encryptsl.lite.eco.common.database.tables.legacy.LegacyAccountTable;
import com.github.encryptsl.lite.eco.common.extensions.DatabaseLoggerTransactionKt;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.FieldSet;
import org.jetbrains.exposed.v1.core.ResultRow;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.dao.id.EntityID;
import org.jetbrains.exposed.v1.jdbc.MetadataQueriesKt;
import org.jetbrains.exposed.v1.jdbc.QueriesKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/encryptsl/lite/eco/common/database/models/legacy/LegacyDatabaseEcoModel;", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "playersBalances", "", "Ljava/util/UUID;", "Lcom/github/encryptsl/lite/eco/api/migrator/entity/PlayerBalances$PlayerBalance;", "getPlayerBalances", "getPlayerBalances$LiteEco", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nLegacyDatabaseEcoModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyDatabaseEcoModel.kt\ncom/github/encryptsl/lite/eco/common/database/models/legacy/LegacyDatabaseEcoModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1915#2,2:35\n*S KotlinDebug\n*F\n+ 1 LegacyDatabaseEcoModel.kt\ncom/github/encryptsl/lite/eco/common/database/models/legacy/LegacyDatabaseEcoModel\n*L\n20#1:35,2\n*E\n"})
public final class LegacyDatabaseEcoModel {
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    private final Map<UUID, PlayerBalances.PlayerBalance> playersBalances;

    public LegacyDatabaseEcoModel(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
        this.playersBalances = new LinkedHashMap();
    }

    @NotNull
    public final Map<UUID, PlayerBalances.PlayerBalance> getPlayerBalances$LiteEco() {
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> LegacyDatabaseEcoModel.getPlayerBalances$lambda$0(this, arg_0), 1, null);
        return this.playersBalances;
    }

    private static final Unit getPlayerBalances$lambda$0(LegacyDatabaseEcoModel this$0, Transaction $this$loggedTransaction) {
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        if (MetadataQueriesKt.exists((Table)((Table)LegacyAccountTable.INSTANCE))) {
            Iterable $this$forEach$iv = (Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)LegacyAccountTable.INSTANCE));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResultRow row = (ResultRow)element$iv;
                boolean bl = false;
                Map<UUID, PlayerBalances.PlayerBalance> map2 = this$0.playersBalances;
                UUID uUID = UUID.fromString((String)row.get((Expression)LegacyAccountTable.INSTANCE.getUuid()));
                int n = (int)((Number)((EntityID)row.get((Expression)LegacyAccountTable.INSTANCE.getId())).getValue()).longValue();
                UUID uUID2 = UUID.fromString((String)row.get((Expression)LegacyAccountTable.INSTANCE.getUuid()));
                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(...)");
                PlayerBalances.PlayerBalance playerBalance = new PlayerBalances.PlayerBalance(n, uUID2, (String)row.get((Expression)LegacyAccountTable.INSTANCE.getUsername()), new BigDecimal(String.valueOf(((Number)row.get((Expression)LegacyAccountTable.INSTANCE.getMoney())).doubleValue())));
                map2.put(uUID, playerBalance);
            }
        } else {
            this$0.liteEco.getLogger().error("Legacy table does not exist, skipping migration.");
        }
        return Unit.INSTANCE;
    }
}

