/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.database.models;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.interfaces.PlayerSQL;
import com.github.encryptsl.lite.eco.common.database.entity.UserEntity;
import com.github.encryptsl.lite.eco.common.database.tables.Account;
import com.github.encryptsl.lite.eco.common.extensions.DatabaseLoggerTransactionKt;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnSet;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import org.jetbrains.exposed.v1.core.FieldSet;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.OpBuilderKt;
import org.jetbrains.exposed.v1.core.ResultRow;
import org.jetbrains.exposed.v1.core.SortOrder;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.BatchInsertStatement;
import org.jetbrains.exposed.v1.core.statements.UpdateBuilder;
import org.jetbrains.exposed.v1.core.statements.UpdateStatement;
import org.jetbrains.exposed.v1.exceptions.ExposedSQLException;
import org.jetbrains.exposed.v1.jdbc.QueriesKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010\n\u001a\u00020\u0007H\u0016J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0016J0\u0010 \u001a\u00020\u00052\u001e\u0010!\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0#0\"2\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a8\u0006%"}, d2={"Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel;", "Lcom/github/encryptsl/lite/eco/api/interfaces/PlayerSQL;", "<init>", "()V", "createPlayerAccount", "", "username", "", "uuid", "Ljava/util/UUID;", "currency", "money", "Ljava/math/BigDecimal;", "updatePlayerName", "getUserByUUID", "Lcom/github/encryptsl/lite/eco/common/database/entity/UserEntity;", "getBalance", "deletePlayerAccount", "getExistPlayerAccount", "", "getTopBalance", "", "getUUIDNameMap", "getPlayersIds", "", "deposit", "withdraw", "set", "purgeAccounts", "purgeDefaultAccounts", "defaultMoney", "purgeInvalidAccounts", "batchInsert", "importData", "", "Lkotlin/Triple;", "Companion", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nDatabaseEcoModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseEcoModel.kt\ncom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,212:1\n1205#2,2:213\n1282#2,4:215\n1205#2,2:219\n1282#2,4:221\n1586#2:225\n1661#2,3:226\n11705#3:229\n12052#3,3:230\n*S KotlinDebug\n*F\n+ 1 DatabaseEcoModel.kt\ncom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel\n*L\n99#1:213,2\n99#1:215,4\n106#1:219,2\n106#1:221,4\n115#1:225\n115#1:226,3\n190#1:229\n190#1:230,3\n*E\n"})
public final class DatabaseEcoModel
implements PlayerSQL {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean debugFailMode;

    @Override
    public void createPlayerAccount(@NotNull String username, @NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal money) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)money, (String)"money");
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.createPlayerAccount$lambda$0(currency, username, uuid, money, arg_0), 1, null);
    }

    @Override
    public void updatePlayerName(@NotNull UUID uuid, @NotNull String username, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.updatePlayerName$lambda$0(currency, uuid, username, arg_0), 1, null);
    }

    @Override
    @Nullable
    public UserEntity getUserByUUID(@NotNull UUID uuid, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return (UserEntity)DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.getUserByUUID$lambda$0(currency, uuid, arg_0), 1, null);
    }

    @Override
    @NotNull
    public BigDecimal getBalance(@NotNull UUID uuid, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Object object = DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.getBalance$lambda$0(currency, uuid, arg_0), 1, null);
        Intrinsics.checkNotNull((Object)object);
        return (BigDecimal)object;
    }

    @Override
    public void deletePlayerAccount(@NotNull UUID uuid, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.deletePlayerAccount$lambda$0(currency, uuid, arg_0), 1, null);
    }

    @Override
    public boolean getExistPlayerAccount(@NotNull UUID uuid, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return (Boolean)DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.getExistPlayerAccount$lambda$0(currency, uuid, arg_0), 1, null);
    }

    @Override
    @NotNull
    public Map<String, UserEntity> getTopBalance(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return (Map)DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.getTopBalance$lambda$0(currency, arg_0), 1, null);
    }

    @Override
    @NotNull
    public Map<UUID, String> getUUIDNameMap(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return (Map)DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.getUUIDNameMap$lambda$0(currency, arg_0), 1, null);
    }

    @Override
    @NotNull
    public Collection<UUID> getPlayersIds(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return (Collection)DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.getPlayersIds$lambda$0(currency, arg_0), 1, null);
    }

    @Override
    public void deposit(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal money) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)money, (String)"money");
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.deposit$lambda$0(currency, uuid, money, arg_0), 1, null);
    }

    @Override
    public void withdraw(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal money) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)money, (String)"money");
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.withdraw$lambda$0(currency, uuid, money, arg_0), 1, null);
    }

    @Override
    public void set(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal money) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)money, (String)"money");
        if (debugFailMode) {
            System.out.println((Object)("[DEBUG] I am throwing out a false error for " + uuid));
            throw new SQLException("DEBUG: Database is currently in fail-mode.");
        }
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.set$lambda$0(currency, uuid, money, arg_0), 1, null);
    }

    @Override
    public void purgeAccounts(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.purgeAccounts$lambda$0(currency, arg_0), 1, null);
    }

    @Override
    public void purgeDefaultAccounts(@NotNull BigDecimal defaultMoney, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)defaultMoney, (String)"defaultMoney");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.purgeDefaultAccounts$lambda$0(currency, defaultMoney, arg_0), 1, null);
    }

    @Override
    public void purgeInvalidAccounts(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.purgeInvalidAccounts$lambda$0(currency, arg_0), 1, null);
    }

    @Override
    public void batchInsert(@NotNull List<? extends Triple<UUID, String, ? extends BigDecimal>> importData, @NotNull String currency) {
        Intrinsics.checkNotNullParameter(importData, (String)"importData");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> DatabaseEcoModel.batchInsert$lambda$0(currency, importData, arg_0), 1, null);
    }

    private static final Unit createPlayerAccount$lambda$0$0(Account $table, String $username, UUID $uuid, BigDecimal $money, Account $this$insertIgnore, UpdateBuilder it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$insertIgnore), (String)"$this$insertIgnore");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($table.getUsername(), (Object)$username);
        it.set($table.getUuid(), (Object)$uuid);
        it.set($table.getMoney(), (Object)$money);
        return Unit.INSTANCE;
    }

    private static final Object createPlayerAccount$lambda$0(String $currency, String $username, UUID $uuid, BigDecimal $money, Transaction $this$loggedTransaction) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            Account table = new Account($currency);
            unit = QueriesKt.insertIgnore((Table)((Table)table), (arg_0, arg_1) -> DatabaseEcoModel.createPlayerAccount$lambda$0$0(table, $username, $uuid, $money, arg_0, arg_1));
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    private static final Op updatePlayerName$lambda$0$0(Account $table, UUID $uuid) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)$table.getUuid()), (Object)$uuid);
    }

    private static final Unit updatePlayerName$lambda$0$1(Account $table, String $username, Account $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($table.getUsername(), (Object)$username);
        return Unit.INSTANCE;
    }

    private static final Object updatePlayerName$lambda$0(String $currency, UUID $uuid, String $username, Transaction $this$loggedTransaction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            Account table = new Account($currency);
            object = QueriesKt.update$default((Table)((Table)table), () -> DatabaseEcoModel.updatePlayerName$lambda$0$0(table, $uuid), null, (arg_0, arg_1) -> DatabaseEcoModel.updatePlayerName$lambda$0$1(table, $username, arg_0, arg_1), (int)2, null);
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            object = Unit.INSTANCE;
        }
        return object;
    }

    private static final UserEntity getUserByUUID$lambda$0(String $currency, UUID $uuid, Transaction $this$loggedTransaction) {
        UserEntity userEntity;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        Account table = new Account($currency);
        Expression[] expressionArray = new Expression[]{table.getUsername(), table.getMoney()};
        ResultRow resultRow = (ResultRow)CollectionsKt.singleOrNull((Iterable)((Iterable)QueriesKt.select((ColumnSet)((ColumnSet)table), (Expression)((Expression)table.getUuid()), (Expression[])expressionArray).where(OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)table.getUuid()), (Object)$uuid))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            userEntity = new UserEntity((String)it.get((Expression)table.getUsername()), (UUID)it.get((Expression)table.getUuid()), (BigDecimal)it.get((Expression)table.getMoney()));
        } else {
            userEntity = null;
        }
        return userEntity;
    }

    private static final Op getBalance$lambda$0$0(Account $table, UUID $uuid) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)$table.getUuid()), (Object)$uuid);
    }

    private static final BigDecimal getBalance$lambda$0(String $currency, UUID $uuid, Transaction $this$loggedTransaction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            Account table = new Account($currency);
            Expression[] expressionArray = new Expression[]{table.getMoney()};
            ResultRow row = (ResultRow)CollectionsKt.singleOrNull((Iterable)((Iterable)QueriesKt.select((ColumnSet)((ColumnSet)table), (Expression)((Expression)table.getUuid()), (Expression[])expressionArray).where(() -> DatabaseEcoModel.getBalance$lambda$0$0(table, $uuid))));
            Object object2 = row;
            if (object2 == null || (object2 = (BigDecimal)object2.getOrNull((Expression)table.getMoney())) == null) {
                object2 = BigDecimal.ZERO;
            }
            object = object2;
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            throw e;
        }
        return object;
    }

    private static final Op deletePlayerAccount$lambda$0$0(Account $table, UUID $uuid, Account $this$deleteWhere) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$deleteWhere), (String)"$this$deleteWhere");
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)$table.getUuid()), (Object)$uuid);
    }

    private static final Object deletePlayerAccount$lambda$0(String $currency, UUID $uuid, Transaction $this$loggedTransaction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            Account table = new Account($currency);
            object = QueriesKt.deleteWhere$default((Table)((Table)table), null, arg_0 -> DatabaseEcoModel.deletePlayerAccount$lambda$0$0(table, $uuid, arg_0), (int)1, null);
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            object = Unit.INSTANCE;
        }
        return object;
    }

    private static final boolean getExistPlayerAccount$lambda$0(String $currency, UUID $uuid, Transaction $this$loggedTransaction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            Account table = new Account($currency);
            bl = !QueriesKt.select((ColumnSet)((ColumnSet)table), (Expression)((Expression)table.getUuid()), (Expression[])new Expression[0]).where(OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)table.getUuid()), (Object)$uuid)).empty();
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getTopBalance$lambda$0(String $currency, Transaction $this$loggedTransaction) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        Account table = new Account($currency);
        Iterable $this$associate$iv = (Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)table)).orderBy((Expression)table.getMoney(), SortOrder.DESC);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            ResultRow it = (ResultRow)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.get((Expression)table.getUsername()), (Object)new UserEntity((String)it.get((Expression)table.getUsername()), (UUID)it.get((Expression)table.getUuid()), (BigDecimal)it.get((Expression)table.getMoney())));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getUUIDNameMap$lambda$0(String $currency, Transaction $this$loggedTransaction) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        Account table = new Account($currency);
        Iterable $this$associate$iv = (Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)table));
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            ResultRow it = (ResultRow)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.get((Expression)table.getUuid()), (Object)it.get((Expression)table.getUsername()));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPlayersIds$lambda$0(String $currency, Transaction $this$loggedTransaction) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            void $this$mapTo$iv$iv;
            Account table = new Account($currency);
            Iterable $this$map$iv = (Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)table));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResultRow resultRow = (ResultRow)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((UUID)it.get((Expression)table.getUuid()));
            }
            list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            list = new ArrayList();
        }
        return list;
    }

    private static final Op deposit$lambda$0$0(Account $table, UUID $uuid) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)$table.getUuid()), (Object)$uuid);
    }

    private static final Unit deposit$lambda$0$1(Account $table, BigDecimal $money, Account $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($table.getMoney(), (Expression)OpBuilderKt.plus((ExpressionWithColumnType)((ExpressionWithColumnType)$table.getMoney()), (Object)$money));
        return Unit.INSTANCE;
    }

    private static final Object deposit$lambda$0(String $currency, UUID $uuid, BigDecimal $money, Transaction $this$loggedTransaction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            Account table = new Account($currency);
            object = QueriesKt.update$default((Table)((Table)table), () -> DatabaseEcoModel.deposit$lambda$0$0(table, $uuid), null, (arg_0, arg_1) -> DatabaseEcoModel.deposit$lambda$0$1(table, $money, arg_0, arg_1), (int)2, null);
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            object = Unit.INSTANCE;
        }
        return object;
    }

    private static final Op withdraw$lambda$0$0(Account $table, UUID $uuid) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)$table.getUuid()), (Object)$uuid);
    }

    private static final Unit withdraw$lambda$0$1(Account $table, BigDecimal $money, Account $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($table.getMoney(), (Expression)OpBuilderKt.minus((ExpressionWithColumnType)((ExpressionWithColumnType)$table.getMoney()), (Object)$money));
        return Unit.INSTANCE;
    }

    private static final Object withdraw$lambda$0(String $currency, UUID $uuid, BigDecimal $money, Transaction $this$loggedTransaction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            Account table = new Account($currency);
            object = QueriesKt.update$default((Table)((Table)table), () -> DatabaseEcoModel.withdraw$lambda$0$0(table, $uuid), null, (arg_0, arg_1) -> DatabaseEcoModel.withdraw$lambda$0$1(table, $money, arg_0, arg_1), (int)2, null);
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            object = Unit.INSTANCE;
        }
        return object;
    }

    private static final Op set$lambda$0$0(Account $table, UUID $uuid) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)$table.getUuid()), (Object)$uuid);
    }

    private static final Unit set$lambda$0$1(Account $table, BigDecimal $money, Account $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($table.getMoney(), (Object)$money);
        return Unit.INSTANCE;
    }

    private static final Object set$lambda$0(String $currency, UUID $uuid, BigDecimal $money, Transaction $this$loggedTransaction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            Account table = new Account($currency);
            object = QueriesKt.update$default((Table)((Table)table), () -> DatabaseEcoModel.set$lambda$0$0(table, $uuid), null, (arg_0, arg_1) -> DatabaseEcoModel.set$lambda$0$1(table, $money, arg_0, arg_1), (int)2, null);
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            object = Unit.INSTANCE;
        }
        return object;
    }

    private static final Object purgeAccounts$lambda$0(String $currency, Transaction $this$loggedTransaction) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            n = QueriesKt.deleteAll((Table)((Table)new Account($currency)));
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            n = Unit.INSTANCE;
        }
        return n;
    }

    private static final Op purgeDefaultAccounts$lambda$0$0(BigDecimal $defaultMoney, Account $this$deleteWhere) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$deleteWhere), (String)"$this$deleteWhere");
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)$this$deleteWhere.getMoney()), (Object)$defaultMoney);
    }

    private static final Object purgeDefaultAccounts$lambda$0(String $currency, BigDecimal $defaultMoney, Transaction $this$loggedTransaction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            object = QueriesKt.deleteWhere$default((Table)((Table)new Account($currency)), null, arg_0 -> DatabaseEcoModel.purgeDefaultAccounts$lambda$0$0($defaultMoney, arg_0), (int)1, null);
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            object = Unit.INSTANCE;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Op purgeInvalidAccounts$lambda$0$0(Account $this$deleteWhere) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$deleteWhere), (String)"$this$deleteWhere");
        ExpressionWithColumnType expressionWithColumnType = (ExpressionWithColumnType)$this$deleteWhere.getUuid();
        OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayerArray, (String)"getOfflinePlayers(...)");
        Object[] objectArray = offlinePlayerArray;
        ExpressionWithColumnType expressionWithColumnType2 = expressionWithColumnType;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OfflinePlayer offlinePlayer = (OfflinePlayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UUID uUID = it.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            collection.add(uUID);
        }
        return (Op)OpBuilderKt.notInList((ExpressionWithColumnType)expressionWithColumnType2, (Iterable)((List)destination$iv$iv));
    }

    private static final Object purgeInvalidAccounts$lambda$0(String $currency, Transaction $this$loggedTransaction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            object = QueriesKt.deleteWhere$default((Table)((Table)new Account($currency)), null, DatabaseEcoModel::purgeInvalidAccounts$lambda$0$0, (int)1, null);
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            object = Unit.INSTANCE;
        }
        return object;
    }

    private static final Unit batchInsert$lambda$0$0(Account $table, BatchInsertStatement $this$batchInsert, Triple triple) {
        Intrinsics.checkNotNullParameter((Object)$this$batchInsert, (String)"$this$batchInsert");
        Intrinsics.checkNotNullParameter((Object)triple, (String)"<destruct>");
        UUID uuid = (UUID)triple.component1();
        String username = (String)triple.component2();
        BigDecimal money = (BigDecimal)triple.component3();
        $this$batchInsert.set($table.getUuid(), (Object)uuid);
        $this$batchInsert.set($table.getUsername(), (Object)username);
        $this$batchInsert.set($table.getMoney(), (Object)money);
        return Unit.INSTANCE;
    }

    private static final Object batchInsert$lambda$0(String $currency, List $importData, Transaction $this$loggedTransaction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        try {
            Account table = new Account($currency);
            object = QueriesKt.batchInsert$default((Table)((Table)table), (Iterable)$importData, (boolean)false, (boolean)false, (arg_0, arg_1) -> DatabaseEcoModel.batchInsert$lambda$0$0(table, arg_0, arg_1), (int)6, null);
        }
        catch (ExposedSQLException e) {
            ComponentLogger componentLogger = LiteEco.Companion.getInstance().getComponentLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            componentLogger.error(string);
            object = Unit.INSTANCE;
        }
        return object;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel$Companion;", "", "<init>", "()V", "debugFailMode", "", "getDebugFailMode", "()Z", "setDebugFailMode", "(Z)V", "LiteEco"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getDebugFailMode() {
            return debugFailMode;
        }

        public final void setDebugFailMode(boolean bl) {
            debugFailMode = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

