/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.commands.player;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.commands.internal.CommandFeature;
import com.github.encryptsl.lite.eco.commands.parsers.AmountValidatorParser;
import com.github.encryptsl.lite.eco.commands.parsers.CurrencyParser;
import com.github.encryptsl.lite.eco.common.manager.economy.PlayerEconomyPayHandler;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.incendo.cloud.Command;
import org.incendo.cloud.bukkit.parser.OfflinePlayerParser;
import org.incendo.cloud.component.DefaultValue;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.paper.PaperCommandManager;
import org.incendo.cloud.paper.util.sender.PlayerSource;
import org.incendo.cloud.paper.util.sender.Source;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.SuggestionProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J&\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/encryptsl/lite/eco/commands/player/MoneyPayCmd;", "Lcom/github/encryptsl/lite/eco/commands/internal/CommandFeature;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "economyPay", "Lcom/github/encryptsl/lite/eco/common/manager/economy/PlayerEconomyPayHandler;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;Lcom/github/encryptsl/lite/eco/common/manager/economy/PlayerEconomyPayHandler;)V", "register", "", "commandManager", "Lorg/incendo/cloud/paper/PaperCommandManager;", "Lorg/incendo/cloud/paper/util/sender/Source;", "base", "Lorg/incendo/cloud/Command$Builder;", "payCommand", "sender", "Lorg/bukkit/entity/Player;", "target", "Lorg/bukkit/OfflinePlayer;", "amount", "Ljava/math/BigDecimal;", "currency", "", "LiteEco"})
public final class MoneyPayCmd
implements CommandFeature {
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    private final PlayerEconomyPayHandler economyPay;

    public MoneyPayCmd(@NotNull LiteEco liteEco, @NotNull PlayerEconomyPayHandler economyPay) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        Intrinsics.checkNotNullParameter((Object)economyPay, (String)"economyPay");
        this.liteEco = liteEco;
        this.economyPay = economyPay;
    }

    @Override
    public void register(@NotNull PaperCommandManager<Source> commandManager, @NotNull Command.Builder<Source> base) {
        Intrinsics.checkNotNullParameter(commandManager, (String)"commandManager");
        Intrinsics.checkNotNullParameter(base, (String)"base");
        Command.Builder builder = base.literal("pay", new String[0]).senderType(PlayerSource.class).permission("lite.eco.pay").required("target", OfflinePlayerParser.offlinePlayerParser(), (SuggestionProvider)commandManager.parserRegistry().getSuggestionProvider("players").get()).required("amount", commandManager.componentBuilder(BigDecimal.class, "amount").parser((ArgumentParser)new AmountValidatorParser(null, 1, null))).optional("currency", commandManager.componentBuilder(String.class, "currency").parser((ArgumentParser)new CurrencyParser()).defaultValue(DefaultValue.parsed((String)"dollars"))).handler(arg_0 -> MoneyPayCmd.register$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"handler(...)");
        Command.Builder pay = builder;
        commandManager.command(pay);
        commandManager.command(commandManager.commandBuilder("pay", new String[0]).proxies(pay.build()));
    }

    public final void payCommand(@NotNull Player sender, @NotNull OfflinePlayer target, @NotNull BigDecimal amount, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        if (!sender.hasPermission("lite.eco.pay." + currency) && !sender.hasPermission("lite.eco.pay.*")) {
            sender.sendMessage(this.liteEco.getLocale().translation("messages.error.missing_currency_permission"));
            return;
        }
        if (Intrinsics.areEqual((Object)sender.getUniqueId(), (Object)target.getUniqueId())) {
            sender.sendMessage(this.liteEco.getLocale().translation("messages.error.self_pay"));
            return;
        }
        this.economyPay.onPlayerPay(sender, target, amount, currency);
    }

    private static final void register$lambda$0(MoneyPayCmd this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Player player = ((PlayerSource)ctx.sender()).source();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"source(...)");
        Player sender = player;
        Object object = ctx.get("target");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        OfflinePlayer target = (OfflinePlayer)object;
        Object object2 = ctx.get("amount");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        BigDecimal amount = (BigDecimal)object2;
        Object object3 = ctx.get("currency");
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        String currency = (String)object3;
        if (Intrinsics.areEqual((Object)sender.getUniqueId(), (Object)target.getUniqueId())) {
            sender.sendMessage(this$0.liteEco.getLocale().translation("messages.error.self_pay"));
            return;
        }
        if (!sender.hasPermission("lite.eco.pay." + currency) && !sender.hasPermission("lite.eco.pay.*")) {
            sender.sendMessage(this$0.liteEco.getLocale().translation("messages.error.missing_currency_permission"));
            return;
        }
        this$0.payCommand(sender, target, amount, currency);
    }
}

