/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco;

import com.github.encryptsl.lite.eco.api.ConfigAPI;
import com.github.encryptsl.lite.eco.api.MetricsCollector;
import com.github.encryptsl.lite.eco.api.UpdateNotifier;
import com.github.encryptsl.lite.eco.api.account.PlayerAccount;
import com.github.encryptsl.lite.eco.api.economy.Currency;
import com.github.encryptsl.lite.eco.api.economy.SuspendLiteEcoEconomyWrapper;
import com.github.encryptsl.lite.eco.api.objects.ModernText;
import com.github.encryptsl.lite.eco.commands.CommandFeatureManager;
import com.github.encryptsl.lite.eco.common.AccountManager;
import com.github.encryptsl.lite.eco.common.config.Locales;
import com.github.encryptsl.lite.eco.common.database.DatabaseConnector;
import com.github.encryptsl.lite.eco.common.database.models.DatabaseEcoModel;
import com.github.encryptsl.lite.eco.common.database.models.DatabaseMonologModel;
import com.github.encryptsl.lite.eco.common.hook.HookManager;
import com.github.encryptsl.lite.eco.listeners.PlayerListeners;
import com.github.encryptsl.lite.eco.utils.ClassUtil;
import com.github.encryptsl.lite.eco.utils.Debugger;
import com.github.encryptsl.lite.eco.utils.PlaceholderHelper;
import com.tchristofferson.configupdater.ConfigUpdater;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 e2\u00020\u0001:\u0001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010^\u001a\u00020_H\u0016J\b\u0010`\u001a\u00020_H\u0016J\b\u0010a\u001a\u00020_H\u0016J\u000e\u0010b\u001a\u00020_2\u0006\u0010c\u001a\u00020\u0010J\b\u0010d\u001a\u00020_H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0016\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010!\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0016\u001a\u0004\b#\u0010$R\u001b\u0010&\u001a\u00020'8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0016\u001a\u0004\b(\u0010)R\u001b\u0010+\u001a\u00020,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u0016\u001a\u0004\b-\u0010.R\u001b\u00100\u001a\u0002018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0016\u001a\u0004\b2\u00103R\u001b\u00105\u001a\u0002068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010\u0016\u001a\u0004\b7\u00108R\u001b\u0010:\u001a\u00020;8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010\u0016\u001a\u0004\b<\u0010=R\u001b\u0010?\u001a\u00020@8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010\u0016\u001a\u0004\bA\u0010BR\u001b\u0010D\u001a\u00020E8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u0010\u0016\u001a\u0004\bF\u0010GR\u0011\u0010I\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u001b\u0010M\u001a\u00020N8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bQ\u0010\u0016\u001a\u0004\bO\u0010PR\u001b\u0010R\u001a\u00020S8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bV\u0010\u0016\u001a\u0004\bT\u0010UR\u001b\u0010W\u001a\u00020X8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b[\u0010\u0016\u001a\u0004\bY\u0010ZR\u000e\u0010\\\u001a\u00020]X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/github/encryptsl/lite/eco/LiteEco;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "pluginManager", "Lorg/bukkit/plugin/PluginManager;", "getPluginManager", "()Lorg/bukkit/plugin/PluginManager;", "logger", "Lnet/kyori/adventure/text/logger/slf4j/ComponentLogger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lnet/kyori/adventure/text/logger/slf4j/ComponentLogger;", "countTransactions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "updateNotifier", "Lcom/github/encryptsl/lite/eco/api/UpdateNotifier;", "getUpdateNotifier", "()Lcom/github/encryptsl/lite/eco/api/UpdateNotifier;", "updateNotifier$delegate", "Lkotlin/Lazy;", "metricsCollector", "Lcom/github/encryptsl/lite/eco/api/MetricsCollector;", "getMetricsCollector", "()Lcom/github/encryptsl/lite/eco/api/MetricsCollector;", "metricsCollector$delegate", "api", "Lcom/github/encryptsl/lite/eco/api/economy/SuspendLiteEcoEconomyWrapper;", "getApi", "()Lcom/github/encryptsl/lite/eco/api/economy/SuspendLiteEcoEconomyWrapper;", "api$delegate", "locale", "Lcom/github/encryptsl/lite/eco/common/config/Locales;", "getLocale", "()Lcom/github/encryptsl/lite/eco/common/config/Locales;", "locale$delegate", "databaseEcoModel", "Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel;", "getDatabaseEcoModel", "()Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel;", "databaseEcoModel$delegate", "loggerModel", "Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseMonologModel;", "getLoggerModel", "()Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseMonologModel;", "loggerModel$delegate", "currencyImpl", "Lcom/github/encryptsl/lite/eco/api/economy/Currency;", "getCurrencyImpl", "()Lcom/github/encryptsl/lite/eco/api/economy/Currency;", "currencyImpl$delegate", "databaseConnector", "Lcom/github/encryptsl/lite/eco/common/database/DatabaseConnector;", "getDatabaseConnector", "()Lcom/github/encryptsl/lite/eco/common/database/DatabaseConnector;", "databaseConnector$delegate", "accountManager", "Lcom/github/encryptsl/lite/eco/common/AccountManager;", "getAccountManager", "()Lcom/github/encryptsl/lite/eco/common/AccountManager;", "accountManager$delegate", "debugger", "Lcom/github/encryptsl/lite/eco/utils/Debugger;", "getDebugger", "()Lcom/github/encryptsl/lite/eco/utils/Debugger;", "debugger$delegate", "placeholderHelper", "Lcom/github/encryptsl/lite/eco/utils/PlaceholderHelper;", "getPlaceholderHelper", "()Lcom/github/encryptsl/lite/eco/utils/PlaceholderHelper;", "placeholderHelper$delegate", "pluginScope", "Lkotlinx/coroutines/CoroutineScope;", "getPluginScope", "()Lkotlinx/coroutines/CoroutineScope;", "configAPI", "Lcom/github/encryptsl/lite/eco/api/ConfigAPI;", "getConfigAPI", "()Lcom/github/encryptsl/lite/eco/api/ConfigAPI;", "configAPI$delegate", "hookManager", "Lcom/github/encryptsl/lite/eco/common/hook/HookManager;", "getHookManager", "()Lcom/github/encryptsl/lite/eco/common/hook/HookManager;", "hookManager$delegate", "commandFeatureManager", "Lcom/github/encryptsl/lite/eco/commands/CommandFeatureManager;", "getCommandFeatureManager", "()Lcom/github/encryptsl/lite/eco/commands/CommandFeatureManager;", "commandFeatureManager$delegate", "configFile", "Ljava/io/File;", "onLoad", "", "onEnable", "onDisable", "increaseTransactions", "value", "registerListeners", "Companion", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nLiteEco.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiteEco.kt\ncom/github/encryptsl/lite/eco/LiteEco\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,136:1\n29#2,3:137\n29#2,3:140\n*S KotlinDebug\n*F\n+ 1 LiteEco.kt\ncom/github/encryptsl/lite/eco/LiteEco\n*L\n82#1:137,3\n129#1:140,3\n*E\n"})
public final class LiteEco
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final ComponentLogger logger;
    @NotNull
    private final ConcurrentHashMap<String, Integer> countTransactions;
    @NotNull
    private final Lazy updateNotifier$delegate;
    @NotNull
    private final Lazy metricsCollector$delegate;
    @NotNull
    private final Lazy api$delegate;
    @NotNull
    private final Lazy locale$delegate;
    @NotNull
    private final Lazy databaseEcoModel$delegate;
    @NotNull
    private final Lazy loggerModel$delegate;
    @NotNull
    private final Lazy currencyImpl$delegate;
    @NotNull
    private final Lazy databaseConnector$delegate;
    @NotNull
    private final Lazy accountManager$delegate;
    @NotNull
    private final Lazy debugger$delegate;
    @NotNull
    private final Lazy placeholderHelper$delegate;
    @NotNull
    private final CoroutineScope pluginScope;
    @NotNull
    private final Lazy configAPI$delegate;
    @NotNull
    private final Lazy hookManager$delegate;
    @NotNull
    private final Lazy commandFeatureManager$delegate;
    @NotNull
    private final File configFile;
    @NotNull
    public static final String PAPI_VERSION = "2.0.5";
    private static LiteEco instance;

    public LiteEco() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager, (String)"getPluginManager(...)");
        this.pluginManager = pluginManager;
        ComponentLogger componentLogger = this.getComponentLogger();
        Intrinsics.checkNotNullExpressionValue((Object)componentLogger, (String)"getComponentLogger(...)");
        this.logger = componentLogger;
        this.countTransactions = new ConcurrentHashMap();
        this.updateNotifier$delegate = LazyKt.lazy(() -> LiteEco.updateNotifier_delegate$lambda$0(this));
        this.metricsCollector$delegate = LazyKt.lazy(() -> LiteEco.metricsCollector_delegate$lambda$0(this));
        this.api$delegate = LazyKt.lazy(LiteEco::api_delegate$lambda$0);
        this.locale$delegate = LazyKt.lazy(() -> LiteEco.locale_delegate$lambda$0(this));
        this.databaseEcoModel$delegate = LazyKt.lazy(LiteEco::databaseEcoModel_delegate$lambda$0);
        this.loggerModel$delegate = LazyKt.lazy(() -> LiteEco.loggerModel_delegate$lambda$0(this));
        this.currencyImpl$delegate = LazyKt.lazy(() -> LiteEco.currencyImpl_delegate$lambda$0(this));
        this.databaseConnector$delegate = LazyKt.lazy(() -> LiteEco.databaseConnector_delegate$lambda$0(this));
        this.accountManager$delegate = LazyKt.lazy(() -> LiteEco.accountManager_delegate$lambda$0(this));
        this.debugger$delegate = LazyKt.lazy(() -> LiteEco.debugger_delegate$lambda$0(this));
        this.placeholderHelper$delegate = LazyKt.lazy(() -> LiteEco.placeholderHelper_delegate$lambda$0(this));
        this.pluginScope = CoroutineScopeKt.CoroutineScope(SupervisorKt.SupervisorJob$default(null, 1, null).plus((CoroutineContext)Dispatchers.getDefault()));
        this.configAPI$delegate = LazyKt.lazy(() -> LiteEco.configAPI_delegate$lambda$0(this));
        this.hookManager$delegate = LazyKt.lazy(() -> LiteEco.hookManager_delegate$lambda$0(this));
        this.commandFeatureManager$delegate = LazyKt.lazy(() -> LiteEco.commandFeatureManager_delegate$lambda$0(this));
        this.configFile = new File(this.getDataFolder(), "config.yml");
    }

    @NotNull
    public final PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @NotNull
    public final ComponentLogger getLogger() {
        return this.logger;
    }

    private final UpdateNotifier getUpdateNotifier() {
        Lazy lazy = this.updateNotifier$delegate;
        return (UpdateNotifier)lazy.getValue();
    }

    private final MetricsCollector getMetricsCollector() {
        Lazy lazy = this.metricsCollector$delegate;
        return (MetricsCollector)lazy.getValue();
    }

    @NotNull
    public final SuspendLiteEcoEconomyWrapper getApi() {
        Lazy lazy = this.api$delegate;
        return (SuspendLiteEcoEconomyWrapper)lazy.getValue();
    }

    @NotNull
    public final Locales getLocale() {
        Lazy lazy = this.locale$delegate;
        return (Locales)lazy.getValue();
    }

    @NotNull
    public final DatabaseEcoModel getDatabaseEcoModel() {
        Lazy lazy = this.databaseEcoModel$delegate;
        return (DatabaseEcoModel)lazy.getValue();
    }

    @NotNull
    public final DatabaseMonologModel getLoggerModel() {
        Lazy lazy = this.loggerModel$delegate;
        return (DatabaseMonologModel)lazy.getValue();
    }

    @NotNull
    public final Currency getCurrencyImpl() {
        Lazy lazy = this.currencyImpl$delegate;
        return (Currency)lazy.getValue();
    }

    @NotNull
    public final DatabaseConnector getDatabaseConnector() {
        Lazy lazy = this.databaseConnector$delegate;
        return (DatabaseConnector)lazy.getValue();
    }

    @NotNull
    public final AccountManager getAccountManager() {
        Lazy lazy = this.accountManager$delegate;
        return (AccountManager)lazy.getValue();
    }

    @NotNull
    public final Debugger getDebugger() {
        Lazy lazy = this.debugger$delegate;
        return (Debugger)lazy.getValue();
    }

    @NotNull
    public final PlaceholderHelper getPlaceholderHelper() {
        Lazy lazy = this.placeholderHelper$delegate;
        return (PlaceholderHelper)lazy.getValue();
    }

    @NotNull
    public final CoroutineScope getPluginScope() {
        return this.pluginScope;
    }

    private final ConfigAPI getConfigAPI() {
        Lazy lazy = this.configAPI$delegate;
        return (ConfigAPI)lazy.getValue();
    }

    private final HookManager getHookManager() {
        Lazy lazy = this.hookManager$delegate;
        return (HookManager)lazy.getValue();
    }

    private final CommandFeatureManager getCommandFeatureManager() {
        Lazy lazy = this.commandFeatureManager$delegate;
        return (CommandFeatureManager)lazy.getValue();
    }

    public void onLoad() {
        instance = this;
        this.getConfigAPI().create("database.db").createConfig("config.yml");
        this.getLocale().load();
        this.getDatabaseConnector().onLoad();
    }

    public void onEnable() {
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        String[] stringArray = new String[]{"Towny"};
        this.getHookManager().blockPlugin(stringArray);
        this.getHookManager().registerHooks();
        this.getMetricsCollector().setupMetrics$LiteEco();
        this.getUpdateNotifier().checkForUpdateAsync();
        this.getCommandFeatureManager().createCommandManager$LiteEco();
        this.registerListeners();
        long timeTaken = System.currentTimeMillis() - start$iv;
        try {
            String[] $i$f$measureTimeMillis2 = new String[]{"economy.currencies", "database.connection", "formatting.placeholders"};
            ConfigUpdater.update((Plugin)((Plugin)this), (String)"config.yml", (File)this.configFile, (String[])$i$f$measureTimeMillis2);
            this.logger.info(ModernText.miniModernText("<green>Config was updated on current version !"));
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            this.logger.error(string);
        }
        PlayerAccount.INSTANCE.startJanitor(this);
        String pluginRunningOnFolia = Companion.isFolia() ? "<blue>[Folia]</blue>" : "<yellow>[PaperMC]</yellow>";
        this.logger.info(ModernText.miniModernText("Contribute to other updates <yellow>https://ko-fi.com/encryptsl"));
        this.logger.info(ModernText.miniModernText("<green>Plugin enabled on " + pluginRunningOnFolia + " in time " + timeTaken + " ms"));
    }

    public void onDisable() {
        if (!Companion.isFolia()) {
            Bukkit.getScheduler().cancelTasks((Plugin)this);
        } else {
            Bukkit.getAsyncScheduler().cancelTasks((Plugin)this);
        }
        this.getHookManager().unregisterHooks();
        this.getApi().syncAccounts();
        CoroutineScopeKt.cancel$default(this.pluginScope, null, 1, null);
        this.getDatabaseConnector().onDisable();
        this.logger.info("Plugin is disabled");
    }

    public final void increaseTransactions(int value) {
        Map map2 = this.countTransactions;
        String string = "transactions";
        Integer n = this.countTransactions.get("transactions");
        Integer n2 = (n != null ? n : 0) + value;
        map2.put(string, n2);
    }

    private final void registerListeners() {
        PlayerListeners[] playerListenersArray = new PlayerListeners[]{new PlayerListeners(this)};
        PlayerListeners[] listeners = playerListenersArray;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        int n = listeners.length;
        for (int i = 0; i < n; ++i) {
            PlayerListeners listener = listeners[i];
            this.pluginManager.registerEvents((Listener)listener, (Plugin)this);
        }
        long timeTaken = System.currentTimeMillis() - start$iv;
        this.logger.info(ModernText.miniModernText("Registering <yellow>(" + listeners.length + ")</yellow> of listeners took <yellow>" + timeTaken + " ms</yellow> -> ok"));
    }

    private static final UpdateNotifier updateNotifier_delegate$lambda$0(LiteEco this$0) {
        String string = this$0.getPluginMeta().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        return new UpdateNotifier(this$0, "101934", string);
    }

    private static final MetricsCollector metricsCollector_delegate$lambda$0(LiteEco this$0) {
        return new MetricsCollector(this$0, 15144, (Map<String, Integer>)this$0.countTransactions);
    }

    private static final SuspendLiteEcoEconomyWrapper api_delegate$lambda$0() {
        return new SuspendLiteEcoEconomyWrapper();
    }

    private static final Locales locale_delegate$lambda$0(LiteEco this$0) {
        return new Locales(this$0);
    }

    private static final DatabaseEcoModel databaseEcoModel_delegate$lambda$0() {
        return new DatabaseEcoModel();
    }

    private static final DatabaseMonologModel loggerModel_delegate$lambda$0(LiteEco this$0) {
        return new DatabaseMonologModel((Plugin)this$0);
    }

    private static final Currency currencyImpl_delegate$lambda$0(LiteEco this$0) {
        return new Currency(this$0);
    }

    private static final DatabaseConnector databaseConnector_delegate$lambda$0(LiteEco this$0) {
        return new DatabaseConnector(this$0);
    }

    private static final AccountManager accountManager_delegate$lambda$0(LiteEco this$0) {
        return new AccountManager(this$0);
    }

    private static final Debugger debugger_delegate$lambda$0(LiteEco this$0) {
        return new Debugger(this$0);
    }

    private static final PlaceholderHelper placeholderHelper_delegate$lambda$0(LiteEco this$0) {
        return new PlaceholderHelper(this$0);
    }

    private static final ConfigAPI configAPI_delegate$lambda$0(LiteEco this$0) {
        return new ConfigAPI(this$0);
    }

    private static final HookManager hookManager_delegate$lambda$0(LiteEco this$0) {
        return new HookManager(this$0);
    }

    private static final CommandFeatureManager commandFeatureManager_delegate$lambda$0(LiteEco this$0) {
        return new CommandFeatureManager(this$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/github/encryptsl/lite/eco/LiteEco$Companion;", "", "<init>", "()V", "PAPI_VERSION", "", "value", "Lcom/github/encryptsl/lite/eco/LiteEco;", "instance", "getInstance", "()Lcom/github/encryptsl/lite/eco/LiteEco;", "isFolia", "", "LiteEco"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LiteEco getInstance() {
            LiteEco liteEco = instance;
            if (liteEco != null) {
                return liteEco;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        public final boolean isFolia() {
            return ClassUtil.INSTANCE.isValidClasspath("io.papermc.paper.threadedregions.RegionizedServer");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

