/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.database.models;

import com.github.encryptsl.lite.eco.api.enums.TypeLogger;
import com.github.encryptsl.lite.eco.api.interfaces.TransactionLogger;
import com.github.encryptsl.lite.eco.common.database.entity.TransactionContextEntity;
import com.github.encryptsl.lite.eco.common.database.models.DatabaseMonologModel;
import com.github.encryptsl.lite.eco.common.database.tables.MonologTable;
import com.github.encryptsl.lite.eco.common.extensions.DatabaseLoggerTransactionKt;
import com.github.encryptsl.lite.eco.common.extensions.KotlinHelperKt;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.time.Instant;
import kotlinx.coroutines.CoroutineScope;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import org.jetbrains.exposed.v1.core.FieldSet;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.OpBuilderKt;
import org.jetbrains.exposed.v1.core.ResultRow;
import org.jetbrains.exposed.v1.core.SortOrder;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.jdbc.QueriesKt;
import org.jetbrains.exposed.v1.jdbc.Query;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J:\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0016\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\f\u0010\u001f\u001a\u00020\u000e*\u00020 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006!"}, d2={"Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseMonologModel;", "Lcom/github/encryptsl/lite/eco/api/interfaces/TransactionLogger;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "isLoggingEnabled", "", "()Z", "logging", "", "ctx", "Lcom/github/encryptsl/lite/eco/common/database/entity/TransactionContextEntity;", "(Lcom/github/encryptsl/lite/eco/common/database/entity/TransactionContextEntity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearLogs", "hasLogs", "targetFilter", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLog", "", "getLogPage", "Lkotlin/Pair;", "", "page", "pageSize", "(Ljava/lang/String;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createQuery", "Lorg/jetbrains/exposed/v1/jdbc/Query;", "toEconomyLog", "Lorg/jetbrains/exposed/v1/core/ResultRow;", "LiteEco"})
public final class DatabaseMonologModel
implements TransactionLogger {
    @NotNull
    private final Plugin plugin;

    public DatabaseMonologModel(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
    }

    @NotNull
    public final Plugin getPlugin() {
        return this.plugin;
    }

    private final boolean isLoggingEnabled() {
        return this.plugin.getConfig().getBoolean("economy.monolog_activity", true);
    }

    @Override
    @Nullable
    public Object logging(@NotNull TransactionContextEntity ctx, @NotNull Continuation<? super Unit> $completion) {
        if (!this.isLoggingEnabled()) {
            return Unit.INSTANCE;
        }
        Object object = KotlinHelperKt.io((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this, ctx, null){
            int label;
            final /* synthetic */ DatabaseMonologModel this$0;
            final /* synthetic */ TransactionContextEntity $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> logging.2.invokeSuspend$lambda$0(this.this$0, this.$ctx, arg_0), 1, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0$0(TransactionContextEntity $ctx, MonologTable $this$insert, InsertStatement it) {
                it.set($this$insert.getAction(), (Object)$ctx.getType().name());
                it.set($this$insert.getSender(), (Object)$ctx.getSender());
                it.set($this$insert.getTarget(), (Object)$ctx.getTarget());
                it.set($this$insert.getCurrency(), (Object)$ctx.getCurrency());
                it.set($this$insert.getPreviousBalance(), (Object)$ctx.getPreviousBalance());
                it.set($this$insert.getNewBalance(), (Object)$ctx.getNewBalance());
                it.set($this$insert.getTimestamp(), (Object)$ctx.getTimestamp());
                return Unit.INSTANCE;
            }

            private static final Object invokeSuspend$lambda$0(DatabaseMonologModel this$0, TransactionContextEntity $ctx, Transaction $this$loggedTransaction) {
                InsertStatement insertStatement;
                try {
                    insertStatement = QueriesKt.insert((Table)((Table)MonologTable.INSTANCE), (arg_0, arg_1) -> logging.2.invokeSuspend$lambda$0$0($ctx, arg_0, arg_1));
                }
                catch (Exception e) {
                    this$0.getPlugin().getComponentLogger().warn("Failed to log transaction: " + e.getMessage());
                    insertStatement = Unit.INSTANCE;
                }
                return insertStatement;
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void clearLogs() {
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, DatabaseMonologModel::clearLogs$lambda$0, 1, null);
    }

    @Override
    @Nullable
    public Object hasLogs(@Nullable String targetFilter, @NotNull Continuation<? super Boolean> $completion) {
        return KotlinHelperKt.io((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, targetFilter, null){
            int label;
            final /* synthetic */ DatabaseMonologModel this$0;
            final /* synthetic */ String $targetFilter;
            {
                this.this$0 = $receiver;
                this.$targetFilter = $targetFilter;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> hasLogs.2.invokeSuspend$lambda$0(this.this$0, this.$targetFilter, arg_0), 1, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$0(DatabaseMonologModel this$0, String $targetFilter, Transaction $this$loggedTransaction) {
                return !DatabaseMonologModel.access$createQuery(this$0, $targetFilter).empty();
            }
        }, $completion);
    }

    @Override
    @Nullable
    public Object getLog(@Nullable String targetFilter, @NotNull Continuation<? super List<TransactionContextEntity>> $completion) {
        return KotlinHelperKt.io((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends TransactionContextEntity>>, Object>(this, targetFilter, null){
            int label;
            final /* synthetic */ DatabaseMonologModel this$0;
            final /* synthetic */ String $targetFilter;
            {
                this.this$0 = $receiver;
                this.$targetFilter = $targetFilter;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> getLog.2.invokeSuspend$lambda$0(this.this$0, this.$targetFilter, arg_0), 1, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<TransactionContextEntity>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - void declaration
             */
            private static final List invokeSuspend$lambda$0(DatabaseMonologModel this$0, String $targetFilter, Transaction $this$loggedTransaction) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)DatabaseMonologModel.access$createQuery(this$0, $targetFilter).orderBy((Expression)MonologTable.INSTANCE.getTimestamp(), SortOrder.DESC);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResultRow resultRow = (ResultRow)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(DatabaseMonologModel.access$toEconomyLog(this$0, (ResultRow)it));
                }
                return (List)destination$iv$iv;
            }
        }, $completion);
    }

    @Override
    @Nullable
    public Object getLogPage(@Nullable String targetFilter, int page, int pageSize, @NotNull Continuation<? super Pair<? extends List<TransactionContextEntity>, Integer>> $completion) {
        return KotlinHelperKt.io((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends List<? extends TransactionContextEntity>, ? extends Integer>>, Object>(this, targetFilter, pageSize, page, null){
            int label;
            final /* synthetic */ DatabaseMonologModel this$0;
            final /* synthetic */ String $targetFilter;
            final /* synthetic */ int $pageSize;
            final /* synthetic */ int $page;
            {
                this.this$0 = $receiver;
                this.$targetFilter = $targetFilter;
                this.$pageSize = $pageSize;
                this.$page = $page;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> getLogPage.2.invokeSuspend$lambda$0(this.this$0, this.$targetFilter, this.$pageSize, this.$page, arg_0), 1, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Pair<? extends List<TransactionContextEntity>, Integer>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - void declaration
             */
            private static final Pair invokeSuspend$lambda$0(DatabaseMonologModel this$0, String $targetFilter, int $pageSize, int $page, Transaction $this$loggedTransaction) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Query query = DatabaseMonologModel.access$createQuery(this$0, $targetFilter);
                long totalCount = query.count();
                int totalPages = RangesKt.coerceAtLeast((int)((int)Math.ceil((double)totalCount / (double)$pageSize)), (int)1);
                long offsetValue = RangesKt.coerceAtLeast((int)($page - 1), (int)0) * $pageSize;
                Iterable iterable = (Iterable)query.copy().orderBy((Expression)MonologTable.INSTANCE.getTimestamp(), SortOrder.DESC).limit($pageSize).offset(offsetValue);
                boolean $i$f$map = false;
                void var14_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResultRow resultRow = (ResultRow)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(DatabaseMonologModel.access$toEconomyLog(this$0, (ResultRow)it));
                }
                List logs = (List)destination$iv$iv;
                return new Pair((Object)logs, (Object)totalPages);
            }
        }, $completion);
    }

    private final Query createQuery(String targetFilter) {
        return targetFilter != null && !Intrinsics.areEqual((Object)targetFilter, (Object)"all") ? QueriesKt.selectAll((FieldSet)((FieldSet)MonologTable.INSTANCE)).where(() -> DatabaseMonologModel.createQuery$lambda$0(targetFilter)) : QueriesKt.selectAll((FieldSet)((FieldSet)MonologTable.INSTANCE));
    }

    private final TransactionContextEntity toEconomyLog(ResultRow $this$toEconomyLog) {
        TypeLogger typeLogger;
        try {
            typeLogger = TypeLogger.valueOf((String)$this$toEconomyLog.get((Expression)MonologTable.INSTANCE.getAction()));
        }
        catch (Exception exception) {
            typeLogger = TypeLogger.UNKNOWN;
        }
        Instant instant = (Instant)$this$toEconomyLog.get((Expression)MonologTable.INSTANCE.getTimestamp());
        BigDecimal bigDecimal = (BigDecimal)$this$toEconomyLog.get((Expression)MonologTable.INSTANCE.getNewBalance());
        BigDecimal bigDecimal2 = (BigDecimal)$this$toEconomyLog.get((Expression)MonologTable.INSTANCE.getPreviousBalance());
        String string = (String)$this$toEconomyLog.get((Expression)MonologTable.INSTANCE.getCurrency());
        String string2 = (String)$this$toEconomyLog.get((Expression)MonologTable.INSTANCE.getTarget());
        String string3 = (String)$this$toEconomyLog.get((Expression)MonologTable.INSTANCE.getSender());
        TypeLogger typeLogger2 = typeLogger;
        return new TransactionContextEntity(typeLogger2, string3, string2, string, bigDecimal2, bigDecimal, instant);
    }

    private static final int clearLogs$lambda$0(Transaction $this$loggedTransaction) {
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        return QueriesKt.deleteAll((Table)((Table)MonologTable.INSTANCE));
    }

    private static final Op createQuery$lambda$0(String $targetFilter) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)MonologTable.INSTANCE.getTarget()), (Object)$targetFilter);
    }

    public static final /* synthetic */ Query access$createQuery(DatabaseMonologModel $this, String targetFilter) {
        return $this.createQuery(targetFilter);
    }

    public static final /* synthetic */ TransactionContextEntity access$toEconomyLog(DatabaseMonologModel $this, ResultRow $receiver) {
        return $this.toEconomyLog($receiver);
    }
}

