/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.commands.parsers;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.enums.CheckLevel;
import com.github.encryptsl.lite.eco.common.extensions.MoneyFormatKt;
import com.github.encryptsl.lite.eco.common.extensions.NumberControlKt;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.paper.util.sender.Source;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.SuggestionProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/github/encryptsl/lite/eco/commands/parsers/AmountValidatorParser;", "Lorg/incendo/cloud/parser/ArgumentParser;", "Lorg/incendo/cloud/paper/util/sender/Source;", "Ljava/math/BigDecimal;", "level", "Lcom/github/encryptsl/lite/eco/api/enums/CheckLevel;", "<init>", "(Lcom/github/encryptsl/lite/eco/api/enums/CheckLevel;)V", "getLevel", "()Lcom/github/encryptsl/lite/eco/api/enums/CheckLevel;", "parse", "Lorg/incendo/cloud/parser/ArgumentParseResult;", "commandContext", "Lorg/incendo/cloud/context/CommandContext;", "commandInput", "Lorg/incendo/cloud/context/CommandInput;", "suggestionProvider", "Lorg/incendo/cloud/suggestion/SuggestionProvider;", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nAmountValidatorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmountValidatorParser.kt\ncom/github/encryptsl/lite/eco/commands/parsers/AmountValidatorParser\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n437#2:84\n513#2,5:85\n1586#3:90\n1661#3,3:91\n*S KotlinDebug\n*F\n+ 1 AmountValidatorParser.kt\ncom/github/encryptsl/lite/eco/commands/parsers/AmountValidatorParser\n*L\n46#1:84\n46#1:85,5\n54#1:90\n54#1:91,3\n*E\n"})
public final class AmountValidatorParser
implements ArgumentParser<Source, BigDecimal> {
    @NotNull
    private final CheckLevel level;

    public AmountValidatorParser(@NotNull CheckLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.level = level;
    }

    public /* synthetic */ AmountValidatorParser(CheckLevel checkLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            checkLevel = CheckLevel.FULL;
        }
        this(checkLevel);
    }

    @NotNull
    public final CheckLevel getLevel() {
        return this.level;
    }

    @NotNull
    public ArgumentParseResult<BigDecimal> parse(@NotNull CommandContext<Source> commandContext, @NotNull CommandInput commandInput) {
        Intrinsics.checkNotNullParameter(commandContext, (String)"commandContext");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"commandInput");
        String string = commandInput.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String amountStr = string;
        BigDecimal bigDecimal = MoneyFormatKt.toValidDecimal(amountStr);
        if (bigDecimal == null) {
            ArgumentParseResult argumentParseResult = ArgumentParseResult.failure((Throwable)new Exception(LiteEco.Companion.getInstance().getLocale().getMessage("messages.parser.error.format_amount")));
            Intrinsics.checkNotNullExpressionValue((Object)argumentParseResult, (String)"failure(...)");
            return argumentParseResult;
        }
        BigDecimal amount = bigDecimal;
        boolean isInvalid = switch (WhenMappings.$EnumSwitchMapping$0[this.level.ordinal()]) {
            case 1 -> NumberControlKt.isNegative(amount);
            case 2 -> NumberControlKt.isApproachingZero(amount);
            default -> throw new NoWhenBranchMatchedException();
        };
        if (isInvalid) {
            ArgumentParseResult argumentParseResult = ArgumentParseResult.failure((Throwable)new Exception(LiteEco.Companion.getInstance().getLocale().getMessage("messages.parser.error.negative_amount")));
            Intrinsics.checkNotNullExpressionValue((Object)argumentParseResult, (String)"failure(...)");
            return argumentParseResult;
        }
        ArgumentParseResult argumentParseResult = ArgumentParseResult.success((Object)amount);
        Intrinsics.checkNotNullExpressionValue((Object)argumentParseResult, (String)"success(...)");
        return argumentParseResult;
    }

    @NotNull
    public SuggestionProvider<Source> suggestionProvider() {
        SuggestionProvider suggestionProvider = SuggestionProvider.blockingStrings(AmountValidatorParser::suggestionProvider$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)suggestionProvider, (String)"blockingStrings(...)");
        return suggestionProvider;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable suggestionProvider$lambda$0(CommandContext commandContext, CommandInput input) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.lastRemainingToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lastRemainingToken(...)");
        String $this$filter$iv = string;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Object[] destination$iv$iv = (Object[])new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String raw = ((StringBuilder)destination$iv$iv).toString();
        if (StringsKt.isBlank((CharSequence)raw)) {
            return CollectionsKt.emptyList();
        }
        Long l = StringsKt.toLongOrNull((String)raw);
        if (l == null) {
            return CollectionsKt.emptyList();
        }
        long base = l;
        destination$iv$iv = new Long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L};
        List multipliers = CollectionsKt.listOf((Object[])destination$iv$iv);
        Iterable $this$map$iv = multipliers;
        boolean $i$f$map = false;
        Iterable index$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void multiplier;
            long l2 = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            long value = base * multiplier;
            collection.add(Suggestion.suggestion((String)String.valueOf(value)).toString());
        }
        return (List)destination$iv$iv2;
    }

    public AmountValidatorParser() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CheckLevel.values().length];
            try {
                nArray[CheckLevel.ONLY_NEGATIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckLevel.FULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

