/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.api.account;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.account.CachedAccount;
import com.github.encryptsl.lite.eco.api.interfaces.AccountAPI;
import com.github.encryptsl.lite.eco.common.database.models.DatabaseEcoModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\fH\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/github/encryptsl/lite/eco/api/account/PlayerAccount;", "Lcom/github/encryptsl/lite/eco/api/interfaces/AccountAPI;", "<init>", "()V", "databaseEcoModel", "Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel;", "getDatabaseEcoModel", "()Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel;", "databaseEcoModel$delegate", "Lkotlin/Lazy;", "cache", "", "Ljava/util/UUID;", "Lcom/github/encryptsl/lite/eco/api/account/CachedAccount;", "getCache$LiteEco", "()Ljava/util/Map;", "startJanitor", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "cacheAccount", "uuid", "currency", "", "value", "Ljava/math/BigDecimal;", "getBalance", "syncAccount", "syncAccounts", "clearFromCache", "isAccountCached", "", "isPlayerOnline", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nPlayerAccount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerAccount.kt\ncom/github/encryptsl/lite/eco/api/account/PlayerAccount\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n383#2,7:106\n221#3,2:113\n221#3,2:115\n1#4:117\n777#5:118\n873#5,2:119\n1915#5,2:121\n*S KotlinDebug\n*F\n+ 1 PlayerAccount.kt\ncom/github/encryptsl/lite/eco/api/account/PlayerAccount\n*L\n31#1:106,7\n51#1:113,2\n79#1:115,2\n20#1:118\n20#1:119,2\n22#1:121,2\n*E\n"})
public final class PlayerAccount
implements AccountAPI {
    @NotNull
    public static final PlayerAccount INSTANCE = new PlayerAccount();
    @NotNull
    private static final Lazy databaseEcoModel$delegate = LazyKt.lazy(PlayerAccount::databaseEcoModel_delegate$lambda$0);
    @NotNull
    private static final Map<UUID, CachedAccount> cache = new LinkedHashMap();

    private PlayerAccount() {
    }

    private final DatabaseEcoModel getDatabaseEcoModel() {
        Lazy lazy = databaseEcoModel$delegate;
        return (DatabaseEcoModel)lazy.getValue();
    }

    @NotNull
    public final Map<UUID, CachedAccount> getCache$LiteEco() {
        return cache;
    }

    @Override
    public void startJanitor(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)liteEco, PlayerAccount::startJanitor$lambda$0, 6000L, 6000L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cacheAccount(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal value) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map<UUID, CachedAccount> map2 = cache;
        UUID key$iv = uuid;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            CachedAccount answer$iv = new CachedAccount();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        CachedAccount account = (CachedAccount)object;
        account.getBalances().put(currency, value);
        account.setSuccessfullyLoaded(true);
    }

    @Override
    @NotNull
    public BigDecimal getBalance(@NotNull UUID uuid, @NotNull String currency) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
                object = cache.get(uuid);
                if (object == null || (object = ((CachedAccount)object).getBalances()) == null) break block2;
                BigDecimal bigDecimal = BigDecimal.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
                if ((object = object.getOrDefault(currency, bigDecimal)) != null) break block3;
            }
            BigDecimal bigDecimal = BigDecimal.ZERO;
            object = bigDecimal;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        }
        return object;
    }

    @Override
    public void syncAccount(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        LiteEco.Companion.getInstance().getLogger().info("Attempting synchronization for UUID: " + uuid);
        CachedAccount cachedAccount = cache.get(uuid);
        if (cachedAccount == null) {
            return;
        }
        CachedAccount account = cachedAccount;
        if (!account.isSuccessfullyLoaded()) {
            LiteEco.Companion.getInstance().getLogger().severe("Sync BLOCKED for " + uuid + ": Data integrity risk (isSuccessfullyLoaded = false).");
            return;
        }
        List failedCurrencies = new ArrayList();
        Map<String, BigDecimal> $this$forEach$iv = account.getBalances();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, BigDecimal>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, BigDecimal> element$iv;
            Map.Entry<String, BigDecimal> entry = element$iv = iterator2.next();
            boolean bl = false;
            String currency = entry.getKey();
            BigDecimal amount = entry.getValue();
            try {
                if (amount.compareTo(BigDecimal.ZERO) < 0) continue;
                INSTANCE.getDatabaseEcoModel().set(uuid, currency, amount);
                LiteEco.Companion.getInstance().getDebugger().debug(PlayerAccount.class, "Sync OK: " + uuid + " -> " + currency + " (" + amount + ")");
            }
            catch (Exception e) {
                failedCurrencies.add(currency);
                LiteEco.Companion.getInstance().getLogger().severe("Sync FAIL: " + uuid + " -> " + currency + ". Data preserved in cache for next cycle. Error: " + e.getMessage());
            }
        }
        Object object = failedCurrencies.isEmpty() ? cache.remove(uuid) : Boolean.valueOf(account.getBalances().keySet().retainAll(CollectionsKt.toSet((Iterable)failedCurrencies)));
    }

    @Override
    public void syncAccounts() {
        List uuids = CollectionsKt.toList((Iterable)cache.keySet());
        for (UUID uuid : uuids) {
            CachedAccount account;
            if (cache.get(uuid) == null) continue;
            if (!account.isSuccessfullyLoaded()) {
                LiteEco.Companion.getInstance().getLogger().warning("Skipping shutdown sync for " + uuid + ": Data integrity flag is FALSE.");
                continue;
            }
            Map<String, BigDecimal> $this$forEach$iv = account.getBalances();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, BigDecimal>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, BigDecimal> element$iv;
                Map.Entry<String, BigDecimal> entry = element$iv = iterator2.next();
                boolean bl = false;
                String currency = entry.getKey();
                BigDecimal amount = entry.getValue();
                try {
                    INSTANCE.getDatabaseEcoModel().set(uuid, currency, amount);
                }
                catch (Exception e) {
                    LiteEco.Companion.getInstance().getLogger().severe("CRITICAL LOSS: Could not save " + uuid + " (" + currency + ") during shutdown! Error: " + e.getMessage());
                }
            }
        }
        cache.clear();
    }

    @Override
    public void clearFromCache(@NotNull UUID uuid) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Iterable iterable = cache.keySet();
            for (Object t : iterable) {
                UUID key = (UUID)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)key, (Object)uuid)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        UUID uUID = v0;
        if (uUID == null) {
            return;
        }
        UUID player = uUID;
        cache.remove(player);
    }

    @Override
    public boolean isAccountCached(@NotNull UUID uuid, @Nullable String currency) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CachedAccount cachedAccount = cache.get(uuid);
        if (cachedAccount == null) {
            return false;
        }
        CachedAccount account = cachedAccount;
        if (currency == null) {
            return true;
        }
        return account.getBalances().containsKey(currency);
    }

    @Override
    public boolean isPlayerOnline(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return Bukkit.getPlayer((UUID)uuid) != null;
    }

    private static final DatabaseEcoModel databaseEcoModel_delegate$lambda$0() {
        return new DatabaseEcoModel();
    }

    /*
     * WARNING - void declaration
     */
    private static final void startJanitor$lambda$0() {
        void $this$filterTo$iv$iv;
        if (cache.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv = cache.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UUID uuid = (UUID)element$iv$iv;
            boolean bl = false;
            if (!(Bukkit.getPlayer((UUID)uuid) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List offlineUUIDs = (List)destination$iv$iv;
        Iterable $this$forEach$iv = offlineUUIDs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) != null) continue;
            INSTANCE.syncAccount(uuid);
        }
    }
}

