/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.api;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.objects.ModernText;
import com.github.encryptsl.lite.eco.common.config.Locales;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001 B4\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001d\b\u0002\u0010\u0005\u001a\u0017\u0012\b\u0012\u00060\u0007R\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000eJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u000eJ\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/github/encryptsl/lite/eco/api/ComponentPaginator;", "", "components", "", "Lnet/kyori/adventure/text/Component;", "options", "Lkotlin/Function1;", "Lcom/github/encryptsl/lite/eco/api/ComponentPaginator$PaginationOptions;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "paginationOptions", "maxPages", "", "getMaxPages", "()I", "currentPage", "isAboveMaxPage", "", "page", "newPage", "display", "displayPage", "navigationBar", "commandLabel", "", "param", "header", "injectIntoFormat", "format", "paginationComponent", "PaginationOptions", "LiteEco"})
public final class ComponentPaginator {
    @NotNull
    private final List<Component> components;
    @NotNull
    private final PaginationOptions paginationOptions;

    public ComponentPaginator(@NotNull List<? extends Component> components, @NotNull Function1<? super PaginationOptions, Unit> options) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.components = components;
        PaginationOptions paginationOptions = new PaginationOptions(this, 0, 0, null, null, null, 31, null);
        options.invoke((Object)paginationOptions);
        this.paginationOptions = paginationOptions;
    }

    public /* synthetic */ ComponentPaginator(List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = ComponentPaginator::_init_$lambda$0;
        }
        this(list, (Function1<? super PaginationOptions, Unit>)function1);
    }

    public final int getMaxPages() {
        Integer n = this.paginationOptions.getManualMaxPages();
        return n != null ? n : (int)Math.ceil((double)this.components.size() / (double)this.paginationOptions.getItemsPerPage());
    }

    public final int currentPage() {
        return this.paginationOptions.getSelectedPage();
    }

    public final boolean isAboveMaxPage(int page) {
        return page > this.getMaxPages();
    }

    public final void page(int newPage) {
        int targetPage = Math.min(Math.max(newPage, 1), this.getMaxPages());
        this.paginationOptions.setSelectedPage(targetPage);
    }

    @NotNull
    public final List<Component> display() {
        int selectedPage = this.paginationOptions.getSelectedPage();
        int itemsPerPage = this.paginationOptions.getItemsPerPage();
        if (this.components.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int indexStart = (selectedPage - 1) * itemsPerPage;
        int indexEnd = Math.min(indexStart + itemsPerPage, this.components.size());
        return this.components.subList(indexStart, indexEnd);
    }

    @NotNull
    public final List<Component> displayPage(int page) {
        int targetPage = Math.min(Math.max(page, 1), this.getMaxPages());
        int indexStart = (targetPage - 1) * this.paginationOptions.getItemsPerPage();
        int indexEnd = Math.min(indexStart + this.paginationOptions.getItemsPerPage(), this.components.size());
        return this.components.subList(indexStart, indexEnd);
    }

    @NotNull
    public final Component navigationBar(@NotNull String commandLabel, @NotNull String param) {
        Intrinsics.checkNotNullParameter((Object)commandLabel, (String)"commandLabel");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        int page = this.currentPage();
        int prevPage = page - 1;
        int nextPage = page + 1;
        Component component = page > 1 ? LiteEco.Companion.getInstance().getLocale().translation("messages.pagination.previous").color((TextColor)NamedTextColor.GRAY).clickEvent(ClickEvent.runCommand((String)("/" + commandLabel + " " + prevPage + " " + param))).decorate(TextDecoration.UNDERLINED) : LiteEco.Companion.getInstance().getLocale().translation("messages.pagination.previous").color((TextColor)NamedTextColor.DARK_GRAY);
        Intrinsics.checkNotNull((Object)component);
        Component prevComponent = component;
        Component component2 = page < this.getMaxPages() ? LiteEco.Companion.getInstance().getLocale().translation("messages.pagination.next").color((TextColor)NamedTextColor.GRAY).clickEvent(ClickEvent.runCommand((String)("/" + commandLabel + " " + nextPage + " " + param))).decorate(TextDecoration.UNDERLINED) : LiteEco.Companion.getInstance().getLocale().translation("messages.pagination.next").color((TextColor)NamedTextColor.DARK_GRAY);
        Intrinsics.checkNotNull((Object)component2);
        Component nextComponent = component2;
        Locales locales = LiteEco.Companion.getInstance().getLocale();
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.parsed((String)"page", (String)String.valueOf(page)), Placeholder.parsed((String)"max_page", (String)String.valueOf(this.getMaxPages()))};
        TagResolver tagResolver = TagResolver.resolver((TagResolver[])tagResolverArray);
        Intrinsics.checkNotNullExpressionValue((Object)tagResolver, (String)"resolver(...)");
        Component center = locales.translation("messages.pagination.center", tagResolver);
        Object[] objectArray = new Component[]{prevComponent, center, nextComponent};
        Component component3 = Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)((ComponentLike)Component.space())), (Iterable)CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"join(...)");
        Component joined = component3;
        return this.injectIntoFormat(this.paginationOptions.getNavigationFormat(), joined);
    }

    public static /* synthetic */ Component navigationBar$default(ComponentPaginator componentPaginator, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return componentPaginator.navigationBar(string, string2);
    }

    @NotNull
    public final Component header(@NotNull String commandLabel) {
        Intrinsics.checkNotNullParameter((Object)commandLabel, (String)"commandLabel");
        String headerFormat = this.paginationOptions.getHeaderFormat();
        Component baseNav = ComponentPaginator.navigationBar$default(this, commandLabel, null, 2, null);
        return this.injectIntoFormat(headerFormat, baseNav);
    }

    private final Component injectIntoFormat(String format, Component paginationComponent) {
        String template = StringsKt.replace$default((String)format, (String)"<pagination>", (String)"<insertion>", (boolean)false, (int)4, null);
        Component built = ModernText.miniModernText(template);
        Component component = built.replaceText(arg_0 -> ComponentPaginator.injectIntoFormat$lambda$0(paginationComponent, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"replaceText(...)");
        return component;
    }

    private static final Unit _init_$lambda$0(PaginationOptions paginationOptions) {
        Intrinsics.checkNotNullParameter((Object)paginationOptions, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final void injectIntoFormat$lambda$0(Component $paginationComponent, TextReplacementConfig.Builder it) {
        it.matchLiteral("<insertion>").replacement((ComponentLike)$paginationComponent);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0086\u0004\u0018\u00002\u00020\u0001B;\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/github/encryptsl/lite/eco/api/ComponentPaginator$PaginationOptions;", "", "selectedPage", "", "itemsPerPage", "manualMaxPages", "navigationFormat", "", "headerFormat", "<init>", "(Lcom/github/encryptsl/lite/eco/api/ComponentPaginator;IILjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)V", "getSelectedPage", "()I", "setSelectedPage", "(I)V", "getItemsPerPage", "setItemsPerPage", "getManualMaxPages", "()Ljava/lang/Integer;", "setManualMaxPages", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getNavigationFormat", "()Ljava/lang/String;", "setNavigationFormat", "(Ljava/lang/String;)V", "getHeaderFormat", "setHeaderFormat", "LiteEco"})
    public final class PaginationOptions {
        private int selectedPage;
        private int itemsPerPage;
        @Nullable
        private Integer manualMaxPages;
        @NotNull
        private String navigationFormat;
        @NotNull
        private String headerFormat;
        final /* synthetic */ ComponentPaginator this$0;

        public PaginationOptions(ComponentPaginator this$0, int selectedPage, @Nullable int itemsPerPage, @NotNull Integer manualMaxPages, @NotNull String navigationFormat, String headerFormat) {
            Intrinsics.checkNotNullParameter((Object)navigationFormat, (String)"navigationFormat");
            Intrinsics.checkNotNullParameter((Object)headerFormat, (String)"headerFormat");
            this.this$0 = this$0;
            this.selectedPage = selectedPage;
            this.itemsPerPage = itemsPerPage;
            this.manualMaxPages = manualMaxPages;
            this.navigationFormat = navigationFormat;
            this.headerFormat = headerFormat;
        }

        public /* synthetic */ PaginationOptions(ComponentPaginator componentPaginator, int n, int n2, Integer n3, String string, String string2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 1;
            }
            if ((n4 & 2) != 0) {
                n2 = 10;
            }
            if ((n4 & 4) != 0) {
                n3 = null;
            }
            if ((n4 & 8) != 0) {
                string = "<gray><st>\u2500\u2501\u2501\u2501\u2501\u2501\u2501\u2500</st> <blue>[ <yellow><pagination><blue> ] <gray><st>\u2500\u2501\u2501\u2501\u2501\u2501\u2501\u2500</st>";
            }
            if ((n4 & 0x10) != 0) {
                string2 = "<gray><st>\u2500\u2501\u2501\u2501\u2501\u2501\u2501\u2500</st> <blue>[ <yellow>LiteEco<blue> ] <gray><st>\u2500\u2501\u2501\u2501\u2501\u2501\u2501\u2500</st>";
            }
            this(componentPaginator, n, n2, n3, string, string2);
        }

        public final int getSelectedPage() {
            return this.selectedPage;
        }

        public final void setSelectedPage(int n) {
            this.selectedPage = n;
        }

        public final int getItemsPerPage() {
            return this.itemsPerPage;
        }

        public final void setItemsPerPage(int n) {
            this.itemsPerPage = n;
        }

        @Nullable
        public final Integer getManualMaxPages() {
            return this.manualMaxPages;
        }

        public final void setManualMaxPages(@Nullable Integer n) {
            this.manualMaxPages = n;
        }

        @NotNull
        public final String getNavigationFormat() {
            return this.navigationFormat;
        }

        public final void setNavigationFormat(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.navigationFormat = string;
        }

        @NotNull
        public final String getHeaderFormat() {
            return this.headerFormat;
        }

        public final void setHeaderFormat(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.headerFormat = string;
        }
    }
}

