/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.utils;

import com.github.encryptsl.lite.eco.LiteEco;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u0014\u001a\u00020\u000eJ#\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/encryptsl/lite/eco/utils/PlaceholderHelper;", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "getBalance", "Ljava/math/BigDecimal;", "uuid", "Ljava/util/UUID;", "currency", "", "getNameByRank", "rank", "", "getBalanceByRank", "getTotalBalance", "parseCurrency", "args", "", "index", "parseRank", "(Ljava/util/List;I)Ljava/lang/Integer;", "queue", "Lnet/kyori/adventure/text/minimessage/tag/resolver/ArgumentQueue;", "parseRankAndCurrency", "Lkotlin/Pair;", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nPlaceholderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaceholderHelper.kt\ncom/github/encryptsl/lite/eco/utils/PlaceholderHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class PlaceholderHelper {
    @NotNull
    private final LiteEco liteEco;

    public PlaceholderHelper(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
    }

    @NotNull
    public final BigDecimal getBalance(@NotNull UUID uuid, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return (BigDecimal)BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super BigDecimal>, Object>(this, uuid, currency, null){
            int label;
            final /* synthetic */ PlaceholderHelper this$0;
            final /* synthetic */ UUID $uuid;
            final /* synthetic */ String $currency;
            {
                this.this$0 = $receiver;
                this.$uuid = $uuid;
                this.$currency = $currency;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = PlaceholderHelper.access$getLiteEco$p(this.this$0).getApi().getBalance(this.$uuid, this.$currency, (Continuation<? super BigDecimal>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BigDecimal> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    @NotNull
    public final String getNameByRank(int rank, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Map<String, BigDecimal> top = this.liteEco.getApi().getTopBalance(currency);
        String string = (String)CollectionsKt.elementAtOrNull((Iterable)top.keySet(), (int)(rank - 1));
        if (string == null) {
            String string2 = this.liteEco.getConfig().getString("formatting.placeholders.empty-name", "EMPTY");
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        return string;
    }

    @NotNull
    public final BigDecimal getBalanceByRank(int rank, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Map<String, BigDecimal> top = this.liteEco.getApi().getTopBalance(currency);
        BigDecimal bigDecimal = (BigDecimal)CollectionsKt.elementAtOrNull((Iterable)top.values(), (int)(rank - 1));
        if (bigDecimal == null) {
            BigDecimal bigDecimal2 = BigDecimal.ZERO;
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"ZERO");
        }
        return bigDecimal;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BigDecimal getTotalBalance(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Iterable iterable = this.liteEco.getApi().getTopBalance(currency).values();
        BigDecimal bigDecimal = BigDecimal.valueOf(0L);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : iterable) {
            void it;
            BigDecimal bigDecimal4 = bigDecimal2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4.add((BigDecimal)it), (String)"add(...)");
        }
        return bigDecimal2;
    }

    @NotNull
    public final String parseCurrency(@NotNull List<String> args, int index) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String string = (String)CollectionsKt.getOrNull(args, (int)index);
        if (string == null) {
            string = this.liteEco.getCurrencyImpl().defaultCurrency();
        }
        String name = string;
        return this.liteEco.getCurrencyImpl().getCurrencyNameExist(name) ? name : this.liteEco.getCurrencyImpl().defaultCurrency();
    }

    @Nullable
    public final Integer parseRank(@NotNull List<String> args, int index) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String string = (String)CollectionsKt.getOrNull(args, (int)index);
        return string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    @NotNull
    public final String parseCurrency(@NotNull ArgumentQueue queue) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        String string = queue.hasNext() ? queue.pop().value() : this.liteEco.getCurrencyImpl().defaultCurrency();
        Intrinsics.checkNotNull((Object)string);
        String name = string;
        return this.liteEco.getCurrencyImpl().getCurrencyNameExist(name) ? name : this.liteEco.getCurrencyImpl().defaultCurrency();
    }

    @Nullable
    public final Pair<Integer, String> parseRankAndCurrency(@NotNull ArgumentQueue queue) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        String string = queue.popOr("Missing context").value();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
        String[] stringArray = new String[]{"_"};
        List arg = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Object object = (String)CollectionsKt.getOrNull((List)arg, (int)0);
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            return null;
        }
        int rank = (Integer)object;
        String string2 = (String)CollectionsKt.getOrNull((List)arg, (int)1);
        if (string2 == null) {
            string2 = this.liteEco.getCurrencyImpl().defaultCurrency();
        }
        String currency = string2;
        String finalCurrency = this.liteEco.getCurrencyImpl().getCurrencyNameExist(currency) ? currency : this.liteEco.getCurrencyImpl().defaultCurrency();
        return TuplesKt.to((Object)rank, (Object)finalCurrency);
    }

    public static final /* synthetic */ LiteEco access$getLiteEco$p(PlaceholderHelper $this) {
        return $this.liteEco;
    }
}

