/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.hook.placeholderapi;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.utils.PlaceholderHelper;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/placeholderapi/EconomyPlaceholderAPI;", "Lme/clip/placeholderapi/expansion/PlaceholderExpansion;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "extVersion", "", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;Ljava/lang/String;)V", "getIdentifier", "getAuthor", "getVersion", "getRequiredPlugin", "persist", "", "canRegister", "onRequest", "player", "Lorg/bukkit/OfflinePlayer;", "identifier", "LiteEco"})
public final class EconomyPlaceholderAPI
extends PlaceholderExpansion {
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    private final String extVersion;

    public EconomyPlaceholderAPI(@NotNull LiteEco liteEco, @NotNull String extVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        Intrinsics.checkNotNullParameter((Object)extVersion, (String)"extVersion");
        this.liteEco = liteEco;
        this.extVersion = extVersion;
    }

    @NotNull
    public String getIdentifier() {
        return "liteeco";
    }

    @NotNull
    public String getAuthor() {
        return "EncryptSL";
    }

    @NotNull
    public String getVersion() {
        return this.extVersion;
    }

    @NotNull
    public String getRequiredPlugin() {
        String string = this.liteEco.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return this.liteEco.getServer().getPluginManager().isPluginEnabled(this.getRequiredPlugin());
    }

    @Nullable
    public String onRequest(@Nullable OfflinePlayer player, @NotNull String identifier) {
        String string;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        if (player == null) {
            return null;
        }
        String[] stringArray = new String[]{"_"};
        List args = StringsKt.split$default((CharSequence)identifier, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        PlaceholderHelper helper = this.liteEco.getPlaceholderHelper();
        if (StringsKt.startsWith$default((String)identifier, (String)"total_balance", (boolean)false, (int)2, null)) {
            String curr = helper.parseCurrency(args, 2);
            string = this.liteEco.getCurrencyImpl().formatted(helper.getTotalBalance(curr));
        } else if (StringsKt.startsWith$default((String)identifier, (String)"balance", (boolean)false, (int)2, null)) {
            boolean isFormatted = StringsKt.contains$default((CharSequence)identifier, (CharSequence)"formatted", (boolean)false, (int)2, null);
            boolean isCompacted = StringsKt.contains$default((CharSequence)identifier, (CharSequence)"compacted", (boolean)false, (int)2, null);
            int currencyIndex = isFormatted || isCompacted ? 2 : 1;
            String curr = helper.parseCurrency(args, currencyIndex);
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            BigDecimal bal = helper.getBalance(uUID, curr);
            string = isFormatted ? this.liteEco.getCurrencyImpl().fullFormatting(bal, curr) : (isCompacted ? this.liteEco.getCurrencyImpl().compacted(bal) : bal.toPlainString());
        } else if (StringsKt.startsWith$default((String)identifier, (String)"top_", (boolean)false, (int)2, null)) {
            Integer n = helper.parseRank(args, 2);
            if (n == null) {
                return null;
            }
            int rank = n;
            String curr = helper.parseCurrency(args, 3);
            BigDecimal bal = helper.getBalanceByRank(rank, curr);
            string = StringsKt.startsWith$default((String)identifier, (String)"top_formatted", (boolean)false, (int)2, null) ? this.liteEco.getCurrencyImpl().fullFormatting(bal, curr) : (StringsKt.startsWith$default((String)identifier, (String)"top_compacted", (boolean)false, (int)2, null) ? this.liteEco.getCurrencyImpl().compacted(bal) : (StringsKt.startsWith$default((String)identifier, (String)"top_balance", (boolean)false, (int)2, null) ? bal.toPlainString() : (StringsKt.startsWith$default((String)identifier, (String)"top_player", (boolean)false, (int)2, null) ? helper.getNameByRank(rank, curr) : null)));
        } else if (StringsKt.startsWith$default((String)identifier, (String)"top_rank_player", (boolean)false, (int)2, null)) {
            String curr = helper.parseCurrency(args, 3);
            string = helper.getNameByRank(1, curr);
        } else {
            string = null;
        }
        return string;
    }
}

