/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.api.economy;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.objects.ModernText;
import com.github.encryptsl.lite.eco.common.config.Locales;
import com.github.encryptsl.lite.eco.common.extensions.MoneyFormatKt;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0007J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018J\u0016\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\tJ\u0018\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/encryptsl/lite/eco/api/economy/Currency;", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "defaultCurrency", "", "defaultStartBalance", "Ljava/math/BigDecimal;", "getCurrencyPlural", "currency", "getCurrencySingular", "getCurrencyFormat", "getCurrencyStartBalance", "getCurrencyLimit", "getCheckBalanceLimit", "", "amount", "currentBalance", "getCurrencyLimitEnabled", "isCurrencyDisplayCompactEnabled", "getCurrencyNameExist", "getCurrenciesKeys", "", "currencyModularNameConvert", "value", "compacted", "formatted", "fullFormatting", "LiteEco"})
public final class Currency {
    @NotNull
    private final LiteEco liteEco;

    public Currency(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
    }

    @NotNull
    public final String defaultCurrency() {
        return (String)CollectionsKt.first((Iterable)this.getCurrenciesKeys());
    }

    @NotNull
    public final BigDecimal defaultStartBalance() {
        return new BigDecimal(String.valueOf(this.liteEco.getConfig().getDouble("economy.currencies." + this.defaultCurrency() + ".starting_balance", 30.0)));
    }

    @NotNull
    public final String getCurrencyPlural(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return String.valueOf(this.liteEco.getConfig().getString("economy.currencies." + currency + ".currency_plural_name"));
    }

    @NotNull
    public final String getCurrencySingular(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return String.valueOf(this.liteEco.getConfig().getString("economy.currencies." + currency + ".currency_singular_name"));
    }

    private final String getCurrencyFormat(String currency) {
        return String.valueOf(this.liteEco.getConfig().getString("economy.currencies." + currency + ".currency_format"));
    }

    @NotNull
    public final BigDecimal getCurrencyStartBalance(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return new BigDecimal(String.valueOf(this.liteEco.getConfig().getDouble("economy.currencies." + currency + ".starting_balance", 30.0)));
    }

    @NotNull
    public final BigDecimal getCurrencyLimit(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return new BigDecimal(String.valueOf(this.liteEco.getConfig().getDouble("economy.currencies." + currency + ".balance_limit", 0.0)));
    }

    public final boolean getCheckBalanceLimit(@NotNull BigDecimal amount, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return amount.compareTo(this.getCurrencyLimit(currency)) > 0 && this.getCurrencyLimitEnabled(currency);
    }

    public static /* synthetic */ boolean getCheckBalanceLimit$default(Currency currency, BigDecimal bigDecimal, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "dollars";
        }
        return currency.getCheckBalanceLimit(bigDecimal, string);
    }

    public final boolean getCheckBalanceLimit(@NotNull BigDecimal currentBalance, @NotNull String currency, @NotNull BigDecimal amount) {
        Intrinsics.checkNotNullParameter((Object)currentBalance, (String)"currentBalance");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        BigDecimal bigDecimal = currentBalance.add(amount);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"add(...)");
        return bigDecimal.compareTo(this.getCurrencyLimit(currency)) > 0 && this.getCurrencyLimitEnabled(currency);
    }

    public static /* synthetic */ boolean getCheckBalanceLimit$default(Currency currency, BigDecimal bigDecimal, String string, BigDecimal bigDecimal2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "dollars";
        }
        return currency.getCheckBalanceLimit(bigDecimal, string, bigDecimal2);
    }

    public final boolean getCurrencyLimitEnabled(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return this.liteEco.getConfig().getBoolean("economy.currencies." + currency + ".balance_limit_check");
    }

    public final boolean isCurrencyDisplayCompactEnabled(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return this.liteEco.getConfig().getBoolean("economy.currencies." + currency + ".compact_display");
    }

    public final boolean getCurrencyNameExist(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return this.getCurrenciesKeys().contains(currency);
    }

    @NotNull
    public final Set<String> getCurrenciesKeys() {
        Object object = this.liteEco.getConfig().getConfigurationSection("economy.currencies");
        if (object == null || (object = object.getKeys(false)) == null) {
            object = new LinkedHashSet();
        }
        return object;
    }

    @NotNull
    public final String currencyModularNameConvert(@NotNull String currency, @NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.compareTo(BigDecimal.ONE) == 0 ? this.getCurrencySingular(currency) : this.getCurrencyPlural(currency);
    }

    @NotNull
    public final String compacted(@NotNull BigDecimal amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return MoneyFormatKt.compactFormat(amount, String.valueOf(this.liteEco.getConfig().getString("formatting.currency_pattern")), String.valueOf(this.liteEco.getConfig().getString("formatting.compacted_pattern")), String.valueOf(this.liteEco.getConfig().getString("formatting.currency_locale")));
    }

    @NotNull
    public final String formatted(@NotNull BigDecimal amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return MoneyFormatKt.moneyFormat(amount, String.valueOf(this.liteEco.getConfig().getString("formatting.currency_pattern")), String.valueOf(this.liteEco.getConfig().getString("formatting.currency_locale")));
    }

    @NotNull
    public final String fullFormatting(@NotNull BigDecimal amount, @NotNull String currency) {
        String string;
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        boolean bl = this.isCurrencyDisplayCompactEnabled(currency);
        if (bl) {
            string = this.compacted(amount);
        } else if (!bl) {
            string = this.formatted(amount);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String value = string;
        Locales locales = this.liteEco.getLocale();
        String string2 = this.getCurrencyFormat(currency);
        TagResolver.Single single2 = Placeholder.parsed((String)"money", (String)value);
        Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"parsed(...)");
        return locales.plainTextTranslation(ModernText.miniModernText(string2, (TagResolver)single2));
    }

    public static /* synthetic */ String fullFormatting$default(Currency currency, BigDecimal bigDecimal, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "dollars";
        }
        return currency.fullFormatting(bigDecimal, string);
    }
}

