/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco;

import com.github.encryptsl.lite.eco.api.ConfigAPI;
import com.github.encryptsl.lite.eco.api.MetricsCollector;
import com.github.encryptsl.lite.eco.api.UpdateNotifier;
import com.github.encryptsl.lite.eco.api.account.PlayerAccount;
import com.github.encryptsl.lite.eco.api.economy.Currency;
import com.github.encryptsl.lite.eco.api.economy.SuspendLiteEcoEconomyWrapper;
import com.github.encryptsl.lite.eco.api.enums.ExportKeys;
import com.github.encryptsl.lite.eco.api.enums.PurgeKey;
import com.github.encryptsl.lite.eco.api.objects.ModernText;
import com.github.encryptsl.lite.eco.commands.EcoCMD;
import com.github.encryptsl.lite.eco.commands.InternalCmd;
import com.github.encryptsl.lite.eco.commands.MoneyCMD;
import com.github.encryptsl.lite.eco.common.AccountManager;
import com.github.encryptsl.lite.eco.common.config.Locales;
import com.github.encryptsl.lite.eco.common.database.DatabaseConnector;
import com.github.encryptsl.lite.eco.common.database.models.DatabaseEcoModel;
import com.github.encryptsl.lite.eco.common.database.models.DatabaseMonologModel;
import com.github.encryptsl.lite.eco.common.hook.HookManager;
import com.github.encryptsl.lite.eco.listeners.PlayerListeners;
import com.github.encryptsl.lite.eco.utils.BukkitDispatchers;
import com.github.encryptsl.lite.eco.utils.Debugger;
import com.github.encryptsl.lite.eco.utils.PlaceholderHelper;
import com.github.encryptsl.metrics.bukkit.Metrics;
import com.tchristofferson.configupdater.ConfigUpdater;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.minecraft.extras.MinecraftExceptionHandler;
import org.incendo.cloud.paper.PaperCommandManager;
import org.incendo.cloud.paper.util.sender.PaperSimpleSenderMapper;
import org.incendo.cloud.paper.util.sender.Source;
import org.incendo.cloud.suggestion.Suggestion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 e2\u00020\u0001:\u0001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020QH\u0016J\b\u0010S\u001a\u00020QH\u0016J\u000e\u0010T\u001a\u00020Q2\u0006\u0010U\u001a\u00020\u0011J\b\u0010V\u001a\u00020QH\u0002J\b\u0010W\u001a\u00020QH\u0002J\b\u0010X\u001a\u00020QH\u0002J\b\u0010Y\u001a\u00020QH\u0002J\b\u0010Z\u001a\u00020QH\u0002J\b\u0010[\u001a\u00020QH\u0002J\u0016\u0010\\\u001a\u00020Q2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^H\u0002J\u0016\u0010`\u001a\u00020Q2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^H\u0002J\u0014\u0010a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020d0c0bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0017\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0017\u001a\u0004\b$\u0010%R\u001b\u0010'\u001a\u00020(8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u0017\u001a\u0004\b)\u0010*R\u001b\u0010,\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0017\u001a\u0004\b.\u0010/R\u001b\u00101\u001a\u0002028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u0017\u001a\u0004\b3\u00104R\u001b\u00106\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\u0017\u001a\u0004\b8\u00109R\u001b\u0010;\u001a\u00020<8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\u0017\u001a\u0004\b=\u0010>R\u0011\u0010@\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u001b\u0010D\u001a\u00020E8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u0010\u0017\u001a\u0004\bF\u0010GR\u001b\u0010I\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u0010\u0017\u001a\u0004\bK\u0010LR\u000e\u0010N\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/github/encryptsl/lite/eco/LiteEco;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "pluginManager", "Lorg/bukkit/plugin/PluginManager;", "getPluginManager", "()Lorg/bukkit/plugin/PluginManager;", "bukkitDispatchers", "Lcom/github/encryptsl/lite/eco/utils/BukkitDispatchers;", "getBukkitDispatchers", "()Lcom/github/encryptsl/lite/eco/utils/BukkitDispatchers;", "setBukkitDispatchers", "(Lcom/github/encryptsl/lite/eco/utils/BukkitDispatchers;)V", "countTransactions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "api", "Lcom/github/encryptsl/lite/eco/api/economy/SuspendLiteEcoEconomyWrapper;", "getApi", "()Lcom/github/encryptsl/lite/eco/api/economy/SuspendLiteEcoEconomyWrapper;", "api$delegate", "Lkotlin/Lazy;", "locale", "Lcom/github/encryptsl/lite/eco/common/config/Locales;", "getLocale", "()Lcom/github/encryptsl/lite/eco/common/config/Locales;", "locale$delegate", "databaseEcoModel", "Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel;", "getDatabaseEcoModel", "()Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel;", "databaseEcoModel$delegate", "loggerModel", "Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseMonologModel;", "getLoggerModel", "()Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseMonologModel;", "loggerModel$delegate", "currencyImpl", "Lcom/github/encryptsl/lite/eco/api/economy/Currency;", "getCurrencyImpl", "()Lcom/github/encryptsl/lite/eco/api/economy/Currency;", "currencyImpl$delegate", "databaseConnector", "Lcom/github/encryptsl/lite/eco/common/database/DatabaseConnector;", "getDatabaseConnector", "()Lcom/github/encryptsl/lite/eco/common/database/DatabaseConnector;", "databaseConnector$delegate", "accountManager", "Lcom/github/encryptsl/lite/eco/common/AccountManager;", "getAccountManager", "()Lcom/github/encryptsl/lite/eco/common/AccountManager;", "accountManager$delegate", "debugger", "Lcom/github/encryptsl/lite/eco/utils/Debugger;", "getDebugger", "()Lcom/github/encryptsl/lite/eco/utils/Debugger;", "debugger$delegate", "placeholderHelper", "Lcom/github/encryptsl/lite/eco/utils/PlaceholderHelper;", "getPlaceholderHelper", "()Lcom/github/encryptsl/lite/eco/utils/PlaceholderHelper;", "placeholderHelper$delegate", "pluginScope", "Lkotlinx/coroutines/CoroutineScope;", "getPluginScope", "()Lkotlinx/coroutines/CoroutineScope;", "configAPI", "Lcom/github/encryptsl/lite/eco/api/ConfigAPI;", "getConfigAPI", "()Lcom/github/encryptsl/lite/eco/api/ConfigAPI;", "configAPI$delegate", "hookManager", "Lcom/github/encryptsl/lite/eco/common/hook/HookManager;", "getHookManager", "()Lcom/github/encryptsl/lite/eco/common/hook/HookManager;", "hookManager$delegate", "configFile", "Ljava/io/File;", "onLoad", "", "onEnable", "onDisable", "increaseTransactions", "value", "blockPlugins", "hookRegistration", "setupMetrics", "checkUpdates", "registerListeners", "createCommandManager", "registerMinecraftExceptionHandler", "commandManager", "Lorg/incendo/cloud/paper/PaperCommandManager;", "Lorg/incendo/cloud/paper/util/sender/Source;", "registerSuggestionModernProviders", "modifiableSuggestionPlayerSuggestion", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/incendo/cloud/suggestion/Suggestion;", "Companion", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nLiteEco.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiteEco.kt\ncom/github/encryptsl/lite/eco/LiteEco\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,205:1\n29#2,3:206\n29#2,3:209\n1869#3,2:212\n1563#3:218\n1634#3,3:219\n1563#3:222\n1634#3,3:223\n1563#3:226\n1634#3,3:227\n11561#4:214\n11896#4,3:215\n*S KotlinDebug\n*F\n+ 1 LiteEco.kt\ncom/github/encryptsl/lite/eco/LiteEco\n*L\n86#1:206,3\n148#1:209,3\n170#1:212,2\n200#1:218\n200#1:219,3\n188#1:222\n188#1:223,3\n191#1:226\n191#1:227,3\n198#1:214\n198#1:215,3\n*E\n"})
public final class LiteEco
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginManager pluginManager;
    public BukkitDispatchers bukkitDispatchers;
    @NotNull
    private final ConcurrentHashMap<String, Integer> countTransactions;
    @NotNull
    private final Lazy api$delegate;
    @NotNull
    private final Lazy locale$delegate;
    @NotNull
    private final Lazy databaseEcoModel$delegate;
    @NotNull
    private final Lazy loggerModel$delegate;
    @NotNull
    private final Lazy currencyImpl$delegate;
    @NotNull
    private final Lazy databaseConnector$delegate;
    @NotNull
    private final Lazy accountManager$delegate;
    @NotNull
    private final Lazy debugger$delegate;
    @NotNull
    private final Lazy placeholderHelper$delegate;
    @NotNull
    private final CoroutineScope pluginScope;
    @NotNull
    private final Lazy configAPI$delegate;
    @NotNull
    private final Lazy hookManager$delegate;
    @NotNull
    private final File configFile;
    @NotNull
    public static final String PAPI_VERSION = "2.0.5";
    private static LiteEco instance;

    public LiteEco() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager, (String)"getPluginManager(...)");
        this.pluginManager = pluginManager;
        this.countTransactions = new ConcurrentHashMap();
        this.api$delegate = LazyKt.lazy(LiteEco::api_delegate$lambda$0);
        this.locale$delegate = LazyKt.lazy(() -> LiteEco.locale_delegate$lambda$0(this));
        this.databaseEcoModel$delegate = LazyKt.lazy(LiteEco::databaseEcoModel_delegate$lambda$0);
        this.loggerModel$delegate = LazyKt.lazy(() -> LiteEco.loggerModel_delegate$lambda$0(this));
        this.currencyImpl$delegate = LazyKt.lazy(() -> LiteEco.currencyImpl_delegate$lambda$0(this));
        this.databaseConnector$delegate = LazyKt.lazy(() -> LiteEco.databaseConnector_delegate$lambda$0(this));
        this.accountManager$delegate = LazyKt.lazy(() -> LiteEco.accountManager_delegate$lambda$0(this));
        this.debugger$delegate = LazyKt.lazy(() -> LiteEco.debugger_delegate$lambda$0(this));
        this.placeholderHelper$delegate = LazyKt.lazy(() -> LiteEco.placeholderHelper_delegate$lambda$0(this));
        this.pluginScope = CoroutineScopeKt.CoroutineScope(SupervisorKt.SupervisorJob$default(null, 1, null).plus((CoroutineContext)Dispatchers.getDefault()));
        this.configAPI$delegate = LazyKt.lazy(() -> LiteEco.configAPI_delegate$lambda$0(this));
        this.hookManager$delegate = LazyKt.lazy(() -> LiteEco.hookManager_delegate$lambda$0(this));
        this.configFile = new File(this.getDataFolder(), "config.yml");
    }

    @NotNull
    public final PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @NotNull
    public final BukkitDispatchers getBukkitDispatchers() {
        BukkitDispatchers bukkitDispatchers = this.bukkitDispatchers;
        if (bukkitDispatchers != null) {
            return bukkitDispatchers;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bukkitDispatchers");
        return null;
    }

    public final void setBukkitDispatchers(@NotNull BukkitDispatchers bukkitDispatchers) {
        Intrinsics.checkNotNullParameter((Object)bukkitDispatchers, (String)"<set-?>");
        this.bukkitDispatchers = bukkitDispatchers;
    }

    @NotNull
    public final SuspendLiteEcoEconomyWrapper getApi() {
        Lazy lazy = this.api$delegate;
        return (SuspendLiteEcoEconomyWrapper)lazy.getValue();
    }

    @NotNull
    public final Locales getLocale() {
        Lazy lazy = this.locale$delegate;
        return (Locales)lazy.getValue();
    }

    @NotNull
    public final DatabaseEcoModel getDatabaseEcoModel() {
        Lazy lazy = this.databaseEcoModel$delegate;
        return (DatabaseEcoModel)lazy.getValue();
    }

    @NotNull
    public final DatabaseMonologModel getLoggerModel() {
        Lazy lazy = this.loggerModel$delegate;
        return (DatabaseMonologModel)lazy.getValue();
    }

    @NotNull
    public final Currency getCurrencyImpl() {
        Lazy lazy = this.currencyImpl$delegate;
        return (Currency)lazy.getValue();
    }

    @NotNull
    public final DatabaseConnector getDatabaseConnector() {
        Lazy lazy = this.databaseConnector$delegate;
        return (DatabaseConnector)lazy.getValue();
    }

    @NotNull
    public final AccountManager getAccountManager() {
        Lazy lazy = this.accountManager$delegate;
        return (AccountManager)lazy.getValue();
    }

    @NotNull
    public final Debugger getDebugger() {
        Lazy lazy = this.debugger$delegate;
        return (Debugger)lazy.getValue();
    }

    @NotNull
    public final PlaceholderHelper getPlaceholderHelper() {
        Lazy lazy = this.placeholderHelper$delegate;
        return (PlaceholderHelper)lazy.getValue();
    }

    @NotNull
    public final CoroutineScope getPluginScope() {
        return this.pluginScope;
    }

    private final ConfigAPI getConfigAPI() {
        Lazy lazy = this.configAPI$delegate;
        return (ConfigAPI)lazy.getValue();
    }

    private final HookManager getHookManager() {
        Lazy lazy = this.hookManager$delegate;
        return (HookManager)lazy.getValue();
    }

    public void onLoad() {
        instance = this;
        this.getConfigAPI().create("database.db").createConfig("config.yml");
        this.getLocale().load();
        this.getDatabaseConnector().onLoad();
    }

    public void onEnable() {
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.setBukkitDispatchers(new BukkitDispatchers((Plugin)this));
        this.blockPlugins();
        this.hookRegistration();
        this.setupMetrics();
        this.checkUpdates();
        this.createCommandManager();
        this.registerListeners();
        long timeTaken = System.currentTimeMillis() - start$iv;
        try {
            String[] $i$f$measureTimeMillis2 = new String[]{"economy.currencies", "database.connection", "formatting.placeholders"};
            ConfigUpdater.update((Plugin)((Plugin)this), (String)"config.yml", (File)this.configFile, (String[])$i$f$measureTimeMillis2);
            this.getComponentLogger().info(ModernText.miniModernText("<green>Config was updated on current version !"));
        }
        catch (Exception e) {
            Logger logger = this.getLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            logger.severe(string);
        }
        PlayerAccount.INSTANCE.startJanitor(this);
        this.getComponentLogger().info(ModernText.miniModernText("Contribute to other updates <yellow>https://ko-fi.com/encryptsl"));
        this.getComponentLogger().info(ModernText.miniModernText("<green>Plugin enabled in time " + timeTaken + " ms"));
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.getHookManager().unregisterHooks();
        this.getApi().syncAccounts();
        CoroutineScopeKt.cancel$default(this.pluginScope, null, 1, null);
        this.getDatabaseConnector().onDisable();
        this.getLogger().info("Plugin is disabled");
    }

    public final void increaseTransactions(int value) {
        Map map2 = this.countTransactions;
        String string = "transactions";
        Integer n = this.countTransactions.get("transactions");
        Integer n2 = (n != null ? n : 0) + value;
        map2.put(string, n2);
    }

    private final void blockPlugins() {
        String[] stringArray = new String[]{"Towny"};
        this.getHookManager().blockPlugin(stringArray);
    }

    private final void hookRegistration() {
        this.getHookManager().registerHooks();
    }

    private final void setupMetrics() {
        if (this.getConfig().getBoolean("plugin.metrics", true)) {
            Metrics metrics = new Metrics((Plugin)this, 15144);
            MetricsCollector collector2 = new MetricsCollector(metrics, this, (Map<String, Integer>)this.countTransactions);
            collector2.registerCharts$LiteEco();
        }
    }

    private final void checkUpdates() {
        String string = this.getPluginMeta().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        UpdateNotifier updateNotifier = new UpdateNotifier(this, "101934", string);
        updateNotifier.checkForUpdateAsync();
    }

    private final void registerListeners() {
        PlayerListeners[] playerListenersArray = new PlayerListeners[]{new PlayerListeners(this)};
        PlayerListeners[] listeners = playerListenersArray;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        int n = listeners.length;
        for (int i = 0; i < n; ++i) {
            PlayerListeners listener = listeners[i];
            this.pluginManager.registerEvents((Listener)listener, (Plugin)this);
        }
        long timeTaken = System.currentTimeMillis() - start$iv;
        this.getComponentLogger().info(ModernText.miniModernText("Registering <yellow>(" + listeners.length + ")</yellow> of listeners took <yellow>" + timeTaken + " ms</yellow> -> ok"));
    }

    private final void createCommandManager() {
        this.getComponentLogger().info(ModernText.miniModernText("<blue>Registering commands with Cloud Command Framework !"));
        PaperCommandManager paperCommandManager = PaperCommandManager.builder((SenderMapper)((SenderMapper)PaperSimpleSenderMapper.simpleSenderMapper())).executionCoordinator(ExecutionCoordinator.simpleCoordinator()).buildOnEnable((Plugin)this);
        Intrinsics.checkNotNullExpressionValue((Object)paperCommandManager, (String)"buildOnEnable(...)");
        PaperCommandManager commandManager = paperCommandManager;
        this.registerMinecraftExceptionHandler((PaperCommandManager<Source>)commandManager);
        this.registerSuggestionModernProviders((PaperCommandManager<Source>)commandManager);
        Object[] objectArray = new InternalCmd[]{new MoneyCMD(this), new EcoCMD(this)};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InternalCmd it = (InternalCmd)element$iv;
            boolean bl = false;
            it.execute((PaperCommandManager<Source>)commandManager);
        }
    }

    private final void registerMinecraftExceptionHandler(PaperCommandManager<Source> commandManager) {
        MinecraftExceptionHandler.create(LiteEco::registerMinecraftExceptionHandler$lambda$0).defaultHandlers().decorator(arg_0 -> LiteEco.registerMinecraftExceptionHandler$lambda$1(this, arg_0)).registerTo((CommandManager)commandManager);
    }

    private final void registerSuggestionModernProviders(PaperCommandManager<Source> commandManager) {
        commandManager.parserRegistry().registerSuggestionProvider("players", (arg_0, arg_1) -> LiteEco.registerSuggestionModernProviders$lambda$0(this, arg_0, arg_1));
        commandManager.parserRegistry().registerSuggestionProvider("purgeKeys", LiteEco::registerSuggestionModernProviders$lambda$1);
        commandManager.parserRegistry().registerSuggestionProvider("exportKeys", LiteEco::registerSuggestionModernProviders$lambda$2);
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<List<Suggestion>> modifiableSuggestionPlayerSuggestion() {
        CompletableFuture<List<Suggestion>> completableFuture;
        if (this.getConfig().getBoolean("plugin.offline-suggestion-players", true)) {
            OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
            Intrinsics.checkNotNullExpressionValue((Object)offlinePlayerArray, (String)"getOfflinePlayers(...)");
            $this$map$iv = offlinePlayerArray;
            $i$f$map = false;
            Object object = $this$map$iv;
            destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                OfflinePlayer offlinePlayer = (OfflinePlayer)item$iv$iv;
                var12_14 = destination$iv$iv;
                boolean bl = false;
                var12_14.add(Suggestion.suggestion((String)String.valueOf(it.getName())));
            }
            completableFuture = CompletableFuture.completedFuture((List)destination$iv$iv);
        } else {
            Collection collection = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
            $this$map$iv = collection;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv;
                Object item$iv$iv2 = iterator2.next();
                item$iv$iv = (Player)item$iv$iv2;
                var12_14 = destination$iv$iv;
                boolean bl = false;
                var12_14.add(Suggestion.suggestion((String)it.getName()));
            }
            completableFuture = CompletableFuture.completedFuture((List)destination$iv$iv);
        }
        CompletableFuture<List<Suggestion>> suggestion = completableFuture;
        Intrinsics.checkNotNull(suggestion);
        return suggestion;
    }

    private static final SuspendLiteEcoEconomyWrapper api_delegate$lambda$0() {
        return new SuspendLiteEcoEconomyWrapper();
    }

    private static final Locales locale_delegate$lambda$0(LiteEco this$0) {
        return new Locales(this$0);
    }

    private static final DatabaseEcoModel databaseEcoModel_delegate$lambda$0() {
        return new DatabaseEcoModel();
    }

    private static final DatabaseMonologModel loggerModel_delegate$lambda$0(LiteEco this$0) {
        return new DatabaseMonologModel((Plugin)this$0);
    }

    private static final Currency currencyImpl_delegate$lambda$0(LiteEco this$0) {
        return new Currency(this$0);
    }

    private static final DatabaseConnector databaseConnector_delegate$lambda$0(LiteEco this$0) {
        return new DatabaseConnector(this$0);
    }

    private static final AccountManager accountManager_delegate$lambda$0(LiteEco this$0) {
        return new AccountManager(this$0);
    }

    private static final Debugger debugger_delegate$lambda$0(LiteEco this$0) {
        return new Debugger(this$0);
    }

    private static final PlaceholderHelper placeholderHelper_delegate$lambda$0(LiteEco this$0) {
        return new PlaceholderHelper(this$0);
    }

    private static final ConfigAPI configAPI_delegate$lambda$0(LiteEco this$0) {
        return new ConfigAPI(this$0);
    }

    private static final HookManager hookManager_delegate$lambda$0(LiteEco this$0) {
        return new HookManager(this$0);
    }

    private static final Audience registerMinecraftExceptionHandler$lambda$0(Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return (Audience)source.source();
    }

    private static final ComponentLike registerMinecraftExceptionHandler$lambda$1(LiteEco this$0, Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return (ComponentLike)ModernText.miniModernText(String.valueOf(this$0.getConfig().getString("plugin.prefix", "<red>[!]"))).appendSpace().append(component);
    }

    private static final CompletableFuture registerSuggestionModernProviders$lambda$0(LiteEco this$0, CommandContext commandContext, CommandInput commandInput) {
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        return this$0.modifiableSuggestionPlayerSuggestion();
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture registerSuggestionModernProviders$lambda$1(CommandContext commandContext, CommandInput commandInput) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        Iterable $this$map$iv = (Iterable)PurgeKey.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PurgeKey purgeKey = (PurgeKey)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion((String)it.name()));
        }
        return CompletableFuture.completedFuture((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture registerSuggestionModernProviders$lambda$2(CommandContext commandContext, CommandInput commandInput) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandInput, (String)"<unused var>");
        Iterable $this$map$iv = (Iterable)ExportKeys.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExportKeys exportKeys = (ExportKeys)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Suggestion.suggestion((String)it.name()));
        }
        return CompletableFuture.completedFuture((List)destination$iv$iv);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/github/encryptsl/lite/eco/LiteEco$Companion;", "", "<init>", "()V", "PAPI_VERSION", "", "value", "Lcom/github/encryptsl/lite/eco/LiteEco;", "instance", "getInstance", "()Lcom/github/encryptsl/lite/eco/LiteEco;", "LiteEco"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LiteEco getInstance() {
            LiteEco liteEco = instance;
            if (liteEco != null) {
                return liteEco;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

