/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.manager;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.common.config.Locales;
import com.github.encryptsl.lite.eco.common.manager.importer.EconomyImportResults;
import com.github.encryptsl.lite.eco.common.manager.importer.ImportEconomy;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u0004\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/encryptsl/lite/eco/common/manager/ImportManager;", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "importEconomy", "Lcom/github/encryptsl/lite/eco/common/manager/importer/ImportEconomy;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;Lcom/github/encryptsl/lite/eco/common/manager/importer/ImportEconomy;)V", "", "sender", "Lorg/bukkit/command/CommandSender;", "economyName", "", "currency", "LiteEco"})
public final class ImportManager {
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    private final ImportEconomy importEconomy;

    public ImportManager(@NotNull LiteEco liteEco, @NotNull ImportEconomy importEconomy) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        Intrinsics.checkNotNullParameter((Object)importEconomy, (String)"importEconomy");
        this.liteEco = liteEco;
        this.importEconomy = importEconomy;
    }

    public final void importEconomy(@NotNull CommandSender sender, @NotNull String economyName, @NotNull String currency) {
        EconomyImportResults economyImportResults;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)economyName, (String)"economyName");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        try {
            economyImportResults = this.importEconomy.import(economyName, currency);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            sender.sendMessage(this.liteEco.getLocale().translation("messages.error.import_failed"));
            return;
        }
        EconomyImportResults economyImportResults2 = economyImportResults;
        int converted = economyImportResults2.component1();
        BigDecimal balances = economyImportResults2.component2();
        if (converted == 0) {
            sender.sendMessage(this.liteEco.getLocale().translation("messages.error.import_failed"));
            return;
        }
        Locales locales = this.liteEco.getLocale();
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.parsed((String)"economy", (String)economyName), Placeholder.parsed((String)"converted", (String)String.valueOf(converted)), Placeholder.parsed((String)"balances", (String)balances.toPlainString())};
        TagResolver tagResolver = TagResolver.resolver((TagResolver[])tagResolverArray);
        Intrinsics.checkNotNullExpressionValue((Object)tagResolver, (String)"resolver(...)");
        sender.sendMessage(locales.translation("messages.admin.import_success", tagResolver));
    }
}

