/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.hook.vault.legacy;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.PlayerAccount;
import com.github.encryptsl.lite.eco.api.economy.Currency;
import com.github.encryptsl.lite.eco.api.economy.SuspendLiteEcoEconomyWrapper;
import com.github.encryptsl.lite.eco.api.interfaces.LiteEconomyAPI;
import com.github.encryptsl.lite.eco.common.database.models.DatabaseEcoModel;
import com.github.encryptsl.lite.eco.common.extensions.NumberControlKt;
import com.github.encryptsl.lite.eco.common.hook.vault.legacy.LegacyDeprecatedEconomy;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001a\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\u0018\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0018\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u001c\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001c\u0010\u001c\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u001f\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010 \u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010!\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\"\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010#\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010$\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001c\u0010%\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/vault/legacy/LegacyEconomyVaultAPI;", "Lcom/github/encryptsl/lite/eco/common/hook/vault/legacy/LegacyDeprecatedEconomy;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "isEnabled", "", "getName", "", "hasBankSupport", "fractionalDigits", "", "format", "amount", "", "currencyNamePlural", "currencyNameSingular", "hasAccount", "player", "Lorg/bukkit/OfflinePlayer;", "worldName", "getBalance", "world", "has", "withdrawPlayer", "Lnet/milkbowl/vault/economy/EconomyResponse;", "depositPlayer", "createPlayerAccount", "createBank", "name", "deleteBank", "bankBalance", "bankHas", "bankWithdraw", "bankDeposit", "isBankOwner", "isBankMember", "getBanks", "", "Companion", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nLegacyEconomyVaultAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyEconomyVaultAPI.kt\ncom/github/encryptsl/lite/eco/common/hook/vault/legacy/LegacyEconomyVaultAPI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class LegacyEconomyVaultAPI
extends LegacyDeprecatedEconomy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    private static final String BANK_NOT_SUPPORTED_MESSAGE = "LiteEco does not support bank accounts!";
    @NotNull
    private static final String FAIL_REACHED_BALANCE_LIMIT = "LiteEco you reach limit of balance.";

    public LegacyEconomyVaultAPI(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
    }

    public boolean isEnabled() {
        return this.liteEco.isEnabled();
    }

    @NotNull
    public String getName() {
        String string = this.liteEco.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return -1;
    }

    @NotNull
    public String format(double amount) {
        return Currency.fullFormatting$default(this.liteEco.getCurrencyImpl(), new BigDecimal(String.valueOf(amount)), null, 2, null);
    }

    @Nullable
    public String currencyNamePlural() {
        return null;
    }

    @Nullable
    public String currencyNameSingular() {
        return null;
    }

    public boolean hasAccount(@NotNull OfflinePlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LiteEconomyAPI liteEconomyAPI = this.liteEco.getApi();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        return LiteEconomyAPI.hasAccount$default(liteEconomyAPI, uUID, null, 2, null);
    }

    public boolean hasAccount(@NotNull OfflinePlayer player, @Nullable String worldName) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.hasAccount(player);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getBalance(@Nullable OfflinePlayer player) {
        try {
            double d;
            OfflinePlayer offlinePlayer = player;
            if (offlinePlayer == null) return 0.0;
            OfflinePlayer it = offlinePlayer;
            boolean bl = false;
            UUID uUID = it.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            if (PlayerAccount.INSTANCE.isPlayerOnline(uUID)) {
                d = ((Number)BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super Double>, Object>(this, it, null){
                    int label;
                    final /* synthetic */ LegacyEconomyVaultAPI this$0;
                    final /* synthetic */ OfflinePlayer $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                LiteEconomyAPI liteEconomyAPI = LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getApi();
                                UUID uUID = this.$it.getUniqueId();
                                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                                this.label = 1;
                                Object object2 = LiteEconomyAPI.getBalance$default(liteEconomyAPI, uUID, null, (Continuation)this, 2, null);
                                if (object2 != object) return Boxing.boxDouble((double)((BigDecimal)object2).doubleValue());
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Boxing.boxDouble((double)((BigDecimal)object2).doubleValue());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Double> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null)).doubleValue();
                return d;
            } else {
                DatabaseEcoModel databaseEcoModel = this.liteEco.getDatabaseEcoModel();
                UUID uUID2 = it.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUniqueId(...)");
                d = databaseEcoModel.getBalance(uUID2, this.liteEco.getCurrencyImpl().defaultCurrency()).doubleValue();
            }
            return d;
        }
        catch (Exception exception) {
            OfflinePlayer offlinePlayer = player;
            Object object = offlinePlayer;
            if (offlinePlayer == null) return 0.0;
            OfflinePlayer it = object;
            boolean bl = false;
            DatabaseEcoModel databaseEcoModel = this.liteEco.getDatabaseEcoModel();
            UUID uUID = it.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            Double d = Optional.ofNullable(databaseEcoModel.getBalance(uUID, this.liteEco.getCurrencyImpl().defaultCurrency()).doubleValue()).orElse(0.0);
            object = d;
            if (d == null) return 0.0;
            double d2 = (Double)object;
            return d2;
        }
    }

    public double getBalance(@NotNull OfflinePlayer player, @Nullable String world) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getBalance(player);
    }

    public boolean has(@Nullable OfflinePlayer player, double amount) {
        boolean bl;
        if (player != null) {
            SuspendLiteEcoEconomyWrapper suspendLiteEcoEconomyWrapper = this.liteEco.getApi();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            bl = suspendLiteEcoEconomyWrapper.has(uUID, this.liteEco.getCurrencyImpl().defaultCurrency(), new BigDecimal(String.valueOf(amount)));
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean has(@Nullable OfflinePlayer player, @Nullable String worldName, double amount) {
        return this.has(player, amount);
    }

    @NotNull
    public EconomyResponse withdrawPlayer(@Nullable OfflinePlayer player, double amount) {
        EconomyResponse economyResponse;
        OfflinePlayer offlinePlayer = player;
        this.liteEco.getDebugger().debug(LegacyEconomyVaultAPI.class, "try withdraw from " + (offlinePlayer != null ? offlinePlayer.getName() : null) + " amount " + amount);
        if (player == null || NumberControlKt.isApproachingZero(new BigDecimal(String.valueOf(amount)))) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, null);
        }
        if (this.has(player, amount)) {
            this.liteEco.getDebugger().debug(LegacyEconomyVaultAPI.class, "successfully withdraw " + player.getName() + " from his balance " + this.getBalance(player) + " amount " + amount);
            BuildersKt.launch$default(this.liteEco.getPluginScope(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, player, amount, null){
                int label;
                final /* synthetic */ LegacyEconomyVaultAPI this$0;
                final /* synthetic */ OfflinePlayer $player;
                final /* synthetic */ double $amount;
                {
                    this.this$0 = $receiver;
                    this.$player = $player;
                    this.$amount = $amount;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            SuspendLiteEcoEconomyWrapper suspendLiteEcoEconomyWrapper = LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getApi();
                            UUID uUID = this.$player.getUniqueId();
                            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                            this.label = 1;
                            Object object2 = suspendLiteEcoEconomyWrapper.withdraw(uUID, LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getCurrencyImpl().defaultCurrency(), new BigDecimal(String.valueOf(this.$amount)), (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
            economyResponse = new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.SUCCESS, null);
        } else {
            economyResponse = new EconomyResponse(0.0, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, null);
        }
        return economyResponse;
    }

    @NotNull
    public EconomyResponse withdrawPlayer(@Nullable OfflinePlayer player, @Nullable String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    @NotNull
    public EconomyResponse depositPlayer(@Nullable OfflinePlayer player, double amount) {
        OfflinePlayer offlinePlayer = player;
        this.liteEco.getDebugger().debug(LegacyEconomyVaultAPI.class, "try deposit to " + (offlinePlayer != null ? offlinePlayer.getName() : null) + " amount " + amount);
        if (player == null || !this.hasAccount(player) || NumberControlKt.isApproachingZero(new BigDecimal(String.valueOf(amount))) || Currency.getCheckBalanceLimit$default(this.liteEco.getCurrencyImpl(), new BigDecimal(String.valueOf(this.getBalance(player))), null, new BigDecimal(String.valueOf(amount)), 2, null)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, null);
        }
        this.liteEco.getDebugger().debug(LegacyEconomyVaultAPI.class, "successfully deposit " + player.getName() + " to his balance " + this.getBalance(player) + " amount " + amount);
        BuildersKt.launch$default(this.liteEco.getPluginScope(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, player, amount, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ LegacyEconomyVaultAPI this$0;
            final /* synthetic */ OfflinePlayer $player;
            final /* synthetic */ double $amount;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                this.$amount = $amount;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        currencyName = LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getCurrencyImpl().defaultCurrency();
                        v0 = LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getApi();
                        v1 = this.$player.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getUniqueId(...)");
                        this.L$0 = currencyName;
                        this.label = 1;
                        v2 = v0.getBalance(v1, currencyName, (Continuation<? super BigDecimal>)((Continuation)this));
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        currencyName = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl19:
                        // 2 sources

                        currentBalance = (BigDecimal)v2;
                        if (LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getCurrencyImpl().getCheckBalanceLimit(currentBalance, currencyName, new BigDecimal(String.valueOf(this.$amount)))) {
                            new EconomyResponse(this.$amount, this.this$0.getBalance(this.$player), EconomyResponse.ResponseType.FAILURE, "LiteEco you reach limit of balance.");
                            return Unit.INSTANCE;
                        }
                        v3 = LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getApi();
                        v4 = this.$player.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getUniqueId(...)");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)currencyName);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)currentBalance);
                        this.label = 2;
                        v5 = v3.deposit(v4, LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getCurrencyImpl().defaultCurrency(), new BigDecimal(String.valueOf(this.$amount)), (Continuation<? super Unit>)((Continuation)this));
                        if (v5 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl39
                    }
                    case 2: {
                        currentBalance = (BigDecimal)this.L$1;
                        currencyName = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl39:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @NotNull
    public EconomyResponse depositPlayer(@Nullable OfflinePlayer player, @Nullable String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public boolean createPlayerAccount(@Nullable OfflinePlayer player) {
        return (Boolean)BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, player, null){
            int label;
            final /* synthetic */ LegacyEconomyVaultAPI this$0;
            final /* synthetic */ OfflinePlayer $player;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LiteEconomyAPI liteEconomyAPI = LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getApi();
                        OfflinePlayer offlinePlayer = this.$player;
                        Intrinsics.checkNotNull((Object)offlinePlayer);
                        UUID uUID = offlinePlayer.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                        this.label = 1;
                        Object object2 = LiteEconomyAPI.createOrUpdateAccount$default(liteEconomyAPI, uUID, String.valueOf(this.$player.getName()), LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getCurrencyImpl().defaultCurrency(), LegacyEconomyVaultAPI.access$getLiteEco$p(this.this$0).getCurrencyImpl().defaultStartBalance(), false, (Continuation)this, 16, null);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    public boolean createPlayerAccount(@Nullable OfflinePlayer player, @Nullable String worldName) {
        return this.createPlayerAccount(player);
    }

    @NotNull
    public EconomyResponse createBank(@Nullable String name, @Nullable OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, BANK_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public EconomyResponse deleteBank(@Nullable String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, BANK_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public EconomyResponse bankBalance(@Nullable String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, BANK_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public EconomyResponse bankHas(@Nullable String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, BANK_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public EconomyResponse bankWithdraw(@Nullable String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, BANK_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public EconomyResponse bankDeposit(@Nullable String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, BANK_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public EconomyResponse isBankOwner(@Nullable String name, @Nullable OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, BANK_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public EconomyResponse isBankMember(@Nullable String name, @Nullable OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, BANK_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public List<String> getBanks() {
        List<String> list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
        return list;
    }

    public static final /* synthetic */ LiteEco access$getLiteEco$p(LegacyEconomyVaultAPI $this) {
        return $this.liteEco;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/vault/legacy/LegacyEconomyVaultAPI$Companion;", "", "<init>", "()V", "BANK_NOT_SUPPORTED_MESSAGE", "", "FAIL_REACHED_BALANCE_LIMIT", "LiteEco"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

