/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.ktor.utils.io.core;

import com.github.encryptsl.ktor.utils.io.charsets.CharsetJVMKt;
import com.github.encryptsl.ktor.utils.io.charsets.EncodingKt;
import com.github.encryptsl.ktor.utils.io.core.BytePacketBuilderKt;
import java.io.EOFException;
import java.nio.charset.Charset;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io.Utf8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\u001a\u001f\u0010\u0005\u001a\u00020\u0004*\u00020\u00002\f\b\u0002\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a9\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\f\b\u0002\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002H\u0007\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0013\u0010\u000e\u001a\u00020\u0004*\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001b\u0010\u000e\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u0010\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0011\u001a)\u0010\u0013\u001a\u00020\u0000*\u00020\r2\f\b\u0002\u0010\u0003\u001a\u00060\u0001j\u0002`\u00022\b\b\u0002\u0010\u0012\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a)\u0010\u0016\u001a\u00020\u0000*\u00020\r2\f\b\u0002\u0010\u0003\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0015\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0014\u001a'\u0010\u0018\u001a\u00020\u0000*\u00020\r2\u0006\u0010\u0017\u001a\u00020\b2\f\b\u0002\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a;\u0010 \u001a\u00020\u001f*\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\b2\b\b\u0002\u0010\u001e\u001a\u00020\b2\f\b\u0002\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b \u0010!\u001a;\u0010 \u001a\u00020\u001f*\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\"2\b\b\u0002\u0010\u001d\u001a\u00020\b2\b\b\u0002\u0010\u001e\u001a\u00020\b2\f\b\u0002\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b \u0010#\u001a\u0017\u0010%\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b%\u0010&\u00a8\u0006'"}, d2={"", "Ljava/nio/charset/Charset;", "Lcom/github/encryptsl/ktor/utils/io/charsets/Charset;", "charset", "", "toByteArray", "(Ljava/lang/String;Ljava/nio/charset/Charset;)[B", "bytes", "", "offset", "length", "String", "([BIILjava/nio/charset/Charset;)Ljava/lang/String;", "Lkotlinx/io/Source;", "readBytes", "(Lkotlinx/io/Source;)[B", "count", "(Lkotlinx/io/Source;I)[B", "max", "readText", "(Lkotlinx/io/Source;Ljava/nio/charset/Charset;I)Ljava/lang/String;", "n", "readTextExact", "charactersCount", "readTextExactCharacters", "(Lkotlinx/io/Source;ILjava/nio/charset/Charset;)Ljava/lang/String;", "Lkotlinx/io/Sink;", "", "text", "fromIndex", "toIndex", "", "writeText", "(Lkotlinx/io/Sink;Ljava/lang/CharSequence;IILjava/nio/charset/Charset;)V", "", "(Lkotlinx/io/Sink;[CIILjava/nio/charset/Charset;)V", "", "prematureEndOfStreamToReadChars", "(I)Ljava/lang/Void;", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Strings.kt\nio/ktor/utils/io/core/StringsKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n*L\n1#1,141:1\n21#2,3:142\n*S KotlinDebug\n*F\n+ 1 Strings.kt\nio/ktor/utils/io/core/StringsKt\n*L\n35#1:142,3\n*E\n"})
public final class StringsKt {
    @NotNull
    public static final byte[] toByteArray(@NotNull String $this$toByteArray, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (Intrinsics.areEqual((Object)charset, (Object)Charsets.UTF_8)) {
            return kotlin.text.StringsKt.encodeToByteArray$default((String)$this$toByteArray, (int)0, (int)0, (boolean)true, (int)3, null);
        }
        return CharsetJVMKt.encodeToByteArray(charset.newEncoder(), $this$toByteArray, 0, $this$toByteArray.length());
    }

    public static /* synthetic */ byte[] toByteArray$default(String string, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return StringsKt.toByteArray(string, charset);
    }

    @Deprecated(message="Use decodeToString instead", replaceWith=@ReplaceWith(expression="bytes.decodeToString(offset, offset + length)", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public static final String String(@NotNull byte[] bytes, int offset, int length, @NotNull Charset charset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (Intrinsics.areEqual((Object)charset, (Object)Charsets.UTF_8)) {
            string = kotlin.text.StringsKt.decodeToString$default((byte[])bytes, (int)offset, (int)(offset + length), (boolean)false, (int)4, null);
        } else {
            boolean $i$f$buildPacket = false;
            Buffer builder$iv = new Buffer();
            Sink $this$String_u24lambda_u240 = builder$iv;
            boolean bl = false;
            BytePacketBuilderKt.writeFully($this$String_u24lambda_u240, bytes, offset, length);
            string = StringsKt.readText$default(builder$iv, charset, 0, 2, null);
        }
        return string;
    }

    public static /* synthetic */ String String$default(byte[] byArray, int n, int n2, Charset charset, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        if ((n3 & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        return StringsKt.String(byArray, n, n2, charset);
    }

    @Deprecated(message="Use readByteArray instead", replaceWith=@ReplaceWith(expression="this.readByteArray()", imports={"kotlinx.io.readByteArray"}))
    @NotNull
    public static final byte[] readBytes(@NotNull Source $this$readBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        return SourcesKt.readByteArray($this$readBytes);
    }

    @Deprecated(message="Use readByteArray instead", replaceWith=@ReplaceWith(expression="this.readByteArray(count)", imports={}))
    @NotNull
    public static final byte[] readBytes(@NotNull Source $this$readBytes, int count2) {
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        return SourcesKt.readByteArray($this$readBytes, count2);
    }

    @NotNull
    public static final String readText(@NotNull Source $this$readText, @NotNull Charset charset, int max) {
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (Intrinsics.areEqual((Object)charset, (Object)Charsets.UTF_8)) {
            if (max == Integer.MAX_VALUE) {
                return Utf8Kt.readString($this$readText);
            }
            long count2 = Math.min($this$readText.getBuffer().getSize(), (long)max);
            return Utf8Kt.readString($this$readText, count2);
        }
        return EncodingKt.decode(charset.newDecoder(), $this$readText, max);
    }

    public static /* synthetic */ String readText$default(Source source, Charset charset, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return StringsKt.readText(source, charset, n);
    }

    @Deprecated(message="Use readTextExactCharacters instead.", replaceWith=@ReplaceWith(expression="readTextExactCharacters(n, charset)", imports={}))
    @NotNull
    public static final String readTextExact(@NotNull Source $this$readTextExact, @NotNull Charset charset, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$readTextExact, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return StringsKt.readTextExactCharacters($this$readTextExact, n, charset);
    }

    public static /* synthetic */ String readTextExact$default(Source source, Charset charset, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return StringsKt.readTextExact(source, charset, n);
    }

    @NotNull
    public static final String readTextExactCharacters(@NotNull Source $this$readTextExactCharacters, int charactersCount, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readTextExactCharacters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String s = StringsKt.readText($this$readTextExactCharacters, charset, charactersCount);
        if (s.length() < charactersCount) {
            StringsKt.prematureEndOfStreamToReadChars(charactersCount);
            throw new KotlinNothingValueException();
        }
        return s;
    }

    public static /* synthetic */ String readTextExactCharacters$default(Source source, int n, Charset charset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return StringsKt.readTextExactCharacters(source, n, charset);
    }

    public static final void writeText(@NotNull Sink $this$writeText, @NotNull CharSequence text, int fromIndex, int toIndex, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$writeText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (charset == Charsets.UTF_8) {
            Utf8Kt.writeString($this$writeText, ((Object)text).toString(), fromIndex, toIndex);
            return;
        }
        EncodingKt.encodeToImpl(charset.newEncoder(), $this$writeText, text, fromIndex, toIndex);
    }

    public static /* synthetic */ void writeText$default(Sink sink, CharSequence charSequence, int n, int n2, Charset charset, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        if ((n3 & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        StringsKt.writeText(sink, charSequence, n, n2, charset);
    }

    public static final void writeText(@NotNull Sink $this$writeText, @NotNull char[] text, int fromIndex, int toIndex, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$writeText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (charset == Charsets.UTF_8) {
            String string = kotlin.text.StringsKt.concatToString((char[])text, (int)fromIndex, (int)(fromIndex + toIndex));
            Utf8Kt.writeString($this$writeText, string, 0, toIndex - fromIndex);
            return;
        }
        EncodingKt.encode(charset.newEncoder(), text, fromIndex, toIndex, $this$writeText);
    }

    public static /* synthetic */ void writeText$default(Sink sink, char[] cArray, int n, int n2, Charset charset, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = cArray.length;
        }
        if ((n3 & 8) != 0) {
            charset = Charsets.UTF_8;
        }
        StringsKt.writeText(sink, cArray, n, n2, charset);
    }

    private static final Void prematureEndOfStreamToReadChars(int charactersCount) {
        throw new EOFException("Not enough input bytes to read " + charactersCount + " characters.");
    }
}

