/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.hook.economy.simpleeconomy;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.common.hook.HookListener;
import com.github.encryptsl.lite.eco.utils.ClassUtil;
import it.alzy.simpleeconomy.plugin.SimpleEconomy;
import it.alzy.simpleeconomy.plugin.storage.Storage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/economy/simpleeconomy/SimpleEconomyHook;", "Lcom/github/encryptsl/lite/eco/common/hook/HookListener;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "economyHandler", "Lit/alzy/simpleeconomy/plugin/storage/Storage;", "canRegister", "", "register", "", "unregister", "getBalance", "Ljava/util/concurrent/CompletableFuture;", "", "uuid", "Ljava/util/UUID;", "getAccounts", "", "", "Companion", "LiteEco"})
public final class SimpleEconomyHook
extends HookListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LiteEco liteEco;
    private Storage economyHandler;
    @NotNull
    public static final String PLUGIN_NAME = "SimpleEconomy";

    public SimpleEconomyHook(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        super(PLUGIN_NAME, "You can now export economy from plugin SimpleEconomy to LiteEco with /eco database import SimpleEconomy <your_currency>");
        this.liteEco = liteEco;
    }

    @Override
    public boolean canRegister() {
        Plugin plugin = this.liteEco.getPluginManager().getPlugin(PLUGIN_NAME);
        return !this.getRegistered() && plugin != null && Companion.isSimpleEconomyPresent();
    }

    @Override
    public void register() {
        if (Companion.isSimpleEconomyPresent()) {
            this.setRegistered(true);
        }
    }

    @Override
    public void unregister() {
    }

    @NotNull
    public final CompletableFuture<Double> getBalance(@NotNull UUID uuid) {
        CompletableFuture completableFuture;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (Companion.isSimpleEconomyPresent()) {
            SimpleEconomy instance = SimpleEconomy.getInstance();
            Storage storage = instance.getStorage();
            Intrinsics.checkNotNullExpressionValue((Object)storage, (String)"getStorage(...)");
            this.economyHandler = storage;
            Storage storage2 = this.economyHandler;
            if (storage2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"economyHandler");
                storage2 = null;
            }
            CompletableFuture completableFuture2 = storage2.getBalance(uuid);
            Intrinsics.checkNotNull((Object)completableFuture2);
            completableFuture = completableFuture2;
        } else {
            CompletableFuture completableFuture3 = CompletableFuture.completedFuture(0.0);
            completableFuture = completableFuture3;
            Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"completedFuture(...)");
        }
        return completableFuture;
    }

    @NotNull
    public final Map<String, Double> getAccounts() {
        Map map2;
        if (Companion.isSimpleEconomyPresent()) {
            SimpleEconomy instance = SimpleEconomy.getInstance();
            Storage storage = instance.getStorage();
            Intrinsics.checkNotNullExpressionValue((Object)storage, (String)"getStorage(...)");
            this.economyHandler = storage;
            Storage storage2 = this.economyHandler;
            if (storage2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"economyHandler");
                storage2 = null;
            }
            Map map3 = storage2.getAllBalances();
            Intrinsics.checkNotNull((Object)map3);
            map2 = map3;
        } else {
            map2 = new LinkedHashMap();
        }
        return map2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/economy/simpleeconomy/SimpleEconomyHook$Companion;", "", "<init>", "()V", "PLUGIN_NAME", "", "isSimpleEconomyPresent", "", "LiteEco"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSimpleEconomyPresent() {
            return ClassUtil.INSTANCE.isValidClasspath("it.alzy.simpleeconomy.plugin.SimpleEconomy");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

