/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.api.economy;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.PlayerAccount;
import com.github.encryptsl.lite.eco.api.interfaces.LiteEconomyAPI;
import com.github.encryptsl.lite.eco.common.database.entity.User;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/github/encryptsl/lite/eco/api/economy/ModernLiteEcoEconomyImpl;", "Lcom/github/encryptsl/lite/eco/api/interfaces/LiteEconomyAPI;", "<init>", "()V", "hasAccount", "", "uuid", "Ljava/util/UUID;", "currency", "", "has", "requiredAmount", "Ljava/math/BigDecimal;", "syncAccounts", "", "getTopBalance", "", "getUUIDNameMap", "", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nModernLiteEcoEconomyImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModernLiteEcoEconomyImpl.kt\ncom/github/encryptsl/lite/eco/api/economy/ModernLiteEcoEconomyImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n463#2:43\n413#2:44\n488#2,7:49\n1252#3,4:45\n1068#3:56\n*S KotlinDebug\n*F\n+ 1 ModernLiteEcoEconomyImpl.kt\ncom/github/encryptsl/lite/eco/api/economy/ModernLiteEcoEconomyImpl\n*L\n33#1:43\n33#1:44\n34#1:49,7\n33#1:45,4\n36#1:56\n*E\n"})
public abstract class ModernLiteEcoEconomyImpl
implements LiteEconomyAPI {
    @Override
    public boolean hasAccount(@NotNull UUID uuid, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return LiteEco.Companion.getInstance().getDatabaseEcoModel().getExistPlayerAccount(uuid, currency);
    }

    @Override
    public boolean has(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal requiredAmount) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)requiredAmount, (String)"requiredAmount");
        return (Boolean)BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(requiredAmount, this, uuid, currency, null){
            Object L$0;
            int label;
            final /* synthetic */ BigDecimal $requiredAmount;
            final /* synthetic */ ModernLiteEcoEconomyImpl this$0;
            final /* synthetic */ UUID $uuid;
            final /* synthetic */ String $currency;
            {
                this.$requiredAmount = $requiredAmount;
                this.this$0 = $receiver;
                this.$uuid = $uuid;
                this.$currency = $currency;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BigDecimal bigDecimal = this.$requiredAmount;
                        this.L$0 = bigDecimal;
                        this.label = 1;
                        Object object2 = this.this$0.getBalance(this.$uuid, this.$currency, (Continuation<? super BigDecimal>)((Continuation)this));
                        if (object2 != object) return Boxing.boxBoolean((bigDecimal.compareTo((BigDecimal)object2) <= 0 ? 1 : 0) != 0);
                        return object;
                    }
                    case 1: {
                        BigDecimal bigDecimal = (BigDecimal)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Boxing.boxBoolean((bigDecimal.compareTo((BigDecimal)object2) <= 0 ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    @Override
    public void syncAccounts() {
        PlayerAccount.INSTANCE.syncAccounts();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, BigDecimal> getTopBalance(@NotNull String currency) {
        void $this$filterKeys$iv;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        boolean isFilteringEnabled = LiteEco.Companion.getInstance().getConfig().getBoolean("economy.currencies." + currency + ".top_balances.filtering");
        if (isFilteringEnabled) {
            List list2 = LiteEco.Companion.getInstance().getConfig().getStringList("economy.currencies." + currency + ".top_balances.blacklist");
            Intrinsics.checkNotNull((Object)list2);
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        List blackList = list;
        Object[] objectArray = new String[]{"NULL", "CONSOLE", "SERVER"};
        Set combinedList = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)blackList), (Iterable)SetsKt.setOf((Object[])objectArray));
        Map<String, User> map2 = LiteEco.Companion.getInstance().getDatabaseEcoModel().getTopBalance(currency);
        boolean $i$f$mapValues = false;
        void var8_8 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void e;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            BigDecimal bigDecimal = PlayerAccount.INSTANCE.isAccountCached(((User)e.getValue()).getUuid(), currency) ? PlayerAccount.INSTANCE.getBalance(((User)e.getValue()).getUuid(), currency) : ((User)e.getValue()).getMoney();
            map4.put(k, bigDecimal);
        }
        $this$mapValues$iv = destination$iv$iv$iv;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String e = (String)entry$iv.getKey();
            boolean bl = false;
            if (!(!combinedList.contains(e))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        List database = MapsKt.toList((Map)result$iv);
        Iterable $this$sortedByDescending$iv = database;
        boolean $i$f$sortedByDescending = false;
        return MapsKt.toMap((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)b;
                boolean bl = false;
                BigDecimal e = (BigDecimal)pair.component2();
                pair = (Pair)a;
                Comparable comparable = e;
                bl = false;
                e = (BigDecimal)pair.component2();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)e);
            }
        }));
    }

    @Override
    @NotNull
    public Map<UUID, String> getUUIDNameMap(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return LiteEco.Companion.getInstance().getDatabaseEcoModel().getUUIDNameMap(currency);
    }
}

