/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.api;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.interfaces.ConfigAPIProvider;
import java.io.File;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\bH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/encryptsl/lite/eco/api/ConfigAPI;", "Lcom/github/encryptsl/lite/eco/api/interfaces/ConfigAPIProvider;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "create", "fileName", "", "createConfig", "configName", "saveResource", "", "replace", "", "LiteEco"})
public final class ConfigAPI
implements ConfigAPIProvider {
    @NotNull
    private final LiteEco liteEco;

    public ConfigAPI(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
    }

    @Override
    @NotNull
    public ConfigAPI create(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = new File(this.liteEco.getDataFolder(), fileName);
        if (!file.exists()) {
            this.saveResource(fileName, false);
        } else {
            this.liteEco.getLogger().info("Resource " + fileName + " exists [!]");
        }
        return this;
    }

    @Override
    @NotNull
    public ConfigAPI createConfig(@NotNull String configName) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        File file = new File(this.liteEco.getDataFolder(), configName);
        if (!file.exists()) {
            this.saveResource(configName, false);
            this.liteEco.getLogger().info("Configuration " + configName + " was successfully created !");
        }
        return this;
    }

    private final void saveResource(String configName, boolean replace) {
        try {
            this.liteEco.saveResource(configName, replace);
        }
        catch (Exception e) {
            Logger logger = this.liteEco.getLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            logger.severe(string);
        }
    }

    static /* synthetic */ void saveResource$default(ConfigAPI configAPI, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        configAPI.saveResource(string, bl);
    }
}

