/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.hook;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.objects.ModernText;
import com.github.encryptsl.lite.eco.common.hook.HookListener;
import com.github.encryptsl.lite.eco.common.hook.economy.bettereconomy.BetterEconomyHook;
import com.github.encryptsl.lite.eco.common.hook.economy.craftconomy3.CraftConomyHook;
import com.github.encryptsl.lite.eco.common.hook.economy.scruffyboy13.ScruffyboyEconomyHook;
import com.github.encryptsl.lite.eco.common.hook.economy.simpleeconomy.SimpleEconomyHook;
import com.github.encryptsl.lite.eco.common.hook.economy.theosiseconomy.TheosisEconomyHook;
import com.github.encryptsl.lite.eco.common.hook.miniplaceholder.MiniPlaceholdersHook;
import com.github.encryptsl.lite.eco.common.hook.placeholderapi.PlaceholderAPIHook;
import com.github.encryptsl.lite.eco.common.hook.vault.VaultHook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/HookManager;", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "hooks", "", "Lcom/github/encryptsl/lite/eco/common/hook/HookListener;", "blockPlugin", "", "plugins", "", "", "([Ljava/lang/String;)V", "registerHooks", "unregisterHooks", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nHookManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HookManager.kt\ncom/github/encryptsl/lite/eco/common/hook/HookManager\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n29#2,2:65\n31#2:72\n774#3:67\n865#3,2:68\n1869#3,2:70\n1788#3,4:73\n774#3:77\n865#3,2:78\n1869#3,2:80\n*S KotlinDebug\n*F\n+ 1 HookManager.kt\ncom/github/encryptsl/lite/eco/common/hook/HookManager\n*L\n44#1:65,2\n44#1:72\n47#1:67\n47#1:68,2\n47#1:70,2\n53#1:73,4\n58#1:77\n58#1:78,2\n58#1:80,2\n*E\n"})
public final class HookManager {
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    private final Set<HookListener> hooks;

    public HookManager(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
        Object[] objectArray = new HookListener[]{new BetterEconomyHook(this.liteEco), new CraftConomyHook(this.liteEco), new ScruffyboyEconomyHook(this.liteEco), new SimpleEconomyHook(this.liteEco), new TheosisEconomyHook(this.liteEco), new MiniPlaceholdersHook(this.liteEco), new PlaceholderAPIHook(this.liteEco), new VaultHook(this.liteEco)};
        this.hooks = SetsKt.mutableSetOf((Object[])objectArray);
    }

    public final void blockPlugin(String ... plugins) {
        Intrinsics.checkNotNullParameter((Object)plugins, (String)"plugins");
        int n = plugins.length;
        for (int i = 0; i < n; ++i) {
            String plugin = plugins[i];
            if (!this.liteEco.getPluginManager().isPluginEnabled(plugin)) continue;
            ComponentLogger componentLogger = this.liteEco.getComponentLogger();
            String string = plugin.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            componentLogger.error("This is not a bug. Please do not report issues..\n" + string + " can corrupt database data or cause other problems.");
            this.liteEco.getPluginManager().disablePlugin((Plugin)this.liteEco);
        }
        this.liteEco.getComponentLogger().info("This plugins can't be used \n" + ArraysKt.toList((Object[])plugins) + " (" + plugins.length + ") with LiteEco.");
        this.liteEco.getComponentLogger().info("This is not a bug. Please don't report issue !!!");
    }

    /*
     * WARNING - void declaration
     */
    public final void registerHooks() {
        int n;
        void $this$count$iv;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        boolean $i$f$measureTimeMillis22 = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.liteEco.getComponentLogger().info("Registering " + this.hooks.size() + " hooks...");
        Iterable $this$filter$iv = this.hooks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            HookListener p0 = (HookListener)element$iv$iv;
            boolean bl2 = false;
            if (!p0.canRegister()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HookListener it = (HookListener)element$iv;
            boolean bl3 = false;
            it.register();
            this.liteEco.getComponentLogger().info(it.getPluginName() + " found hook " + it.getClass().getSimpleName() + " registered !.");
            this.liteEco.getComponentLogger().info(it.getDescription());
        }
        long timeTaken = System.currentTimeMillis() - start$iv;
        Iterable $i$f$measureTimeMillis22 = this.hooks;
        ComponentLogger componentLogger = this.liteEco.getComponentLogger();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                HookListener it = (HookListener)element$iv;
                boolean bl4 = false;
                if (!it.getRegistered() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n2 = n;
        componentLogger.info(ModernText.miniModernText("Registered " + n2 + " of " + this.hooks.size() + " hooks took " + timeTaken + " ms"));
    }

    /*
     * WARNING - void declaration
     */
    public final void unregisterHooks() {
        void $this$filterTo$iv$iv;
        this.liteEco.getComponentLogger().info("Unregistering hooks...");
        Iterable $this$filter$iv = this.hooks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            HookListener p0 = (HookListener)element$iv$iv;
            boolean bl = false;
            if (!p0.canRegister()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HookListener it = (HookListener)element$iv;
            boolean bl = false;
            this.liteEco.getComponentLogger().info("Unregistering hook " + it.getPluginName() + ".");
            it.unregister();
            this.liteEco.getComponentLogger().info("Unregistered hook " + it.getPluginName() + ".");
        }
    }
}

