/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.ktor.http;

import com.github.encryptsl.ktor.util.CharsetKt;
import com.github.encryptsl.ktor.util.TextKt;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u0000 \u001a2\u00060\u0001j\u0002`\u0002:\u0001\u001aB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ$\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0017\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u0019\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/github/encryptsl/ktor/http/URLProtocol;", "Ljava/io/Serializable;", "Lcom/github/encryptsl/ktor/utils/io/JvmSerializable;", "", "name", "", "defaultPort", "<init>", "(Ljava/lang/String;I)V", "component1", "()Ljava/lang/String;", "component2", "()I", "copy", "(Ljava/lang/String;I)Lcom/github/encryptsl/ktor/http/URLProtocol;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getName", "I", "getDefaultPort", "Companion", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nURLProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URLProtocol.kt\nio/ktor/http/URLProtocol\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1069#2,2:93\n1#3:95\n1208#4,2:96\n1236#4,4:98\n*S KotlinDebug\n*F\n+ 1 URLProtocol.kt\nio/ktor/http/URLProtocol\n*L\n21#1:93,2\n66#1:96,2\n66#1:98,4\n*E\n"})
public final class URLProtocol
implements Serializable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String name;
    private final int defaultPort;
    @NotNull
    private static final URLProtocol HTTP;
    @NotNull
    private static final URLProtocol HTTPS;
    @NotNull
    private static final URLProtocol WS;
    @NotNull
    private static final URLProtocol WSS;
    @NotNull
    private static final URLProtocol SOCKS;
    @NotNull
    private static final Map<String, URLProtocol> byName;

    public URLProtocol(@NotNull String name2, int defaultPort) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.defaultPort = defaultPort;
            CharSequence $this$all$iv = this.name;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (CharsetKt.isLowerCase(it)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "All characters should be lower case";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.defaultPort;
    }

    @NotNull
    public final URLProtocol copy(@NotNull String name2, int defaultPort) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new URLProtocol(name2, defaultPort);
    }

    public static /* synthetic */ URLProtocol copy$default(URLProtocol uRLProtocol, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = uRLProtocol.name;
        }
        if ((n2 & 2) != 0) {
            n = uRLProtocol.defaultPort;
        }
        return uRLProtocol.copy(string, n);
    }

    @NotNull
    public String toString() {
        return "URLProtocol(name=" + this.name + ", defaultPort=" + this.defaultPort + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.defaultPort);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof URLProtocol)) {
            return false;
        }
        URLProtocol uRLProtocol = (URLProtocol)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)uRLProtocol.name)) {
            return false;
        }
        return this.defaultPort == uRLProtocol.defaultPort;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        HTTP = new URLProtocol("http", 80);
        HTTPS = new URLProtocol("https", 443);
        WS = new URLProtocol("ws", 80);
        WSS = new URLProtocol("wss", 443);
        SOCKS = new URLProtocol("socks", 1080);
        Object[] objectArray = new URLProtocol[]{HTTP, HTTPS, WS, WSS, SOCKS};
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            URLProtocol uRLProtocol = (URLProtocol)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.name, element$iv$iv);
        }
        byName = destination$iv$iv;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0012\u0010\fR\u0017\u0010\u0013\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\n\u001a\u0004\b\u0014\u0010\fR#\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/github/encryptsl/ktor/http/URLProtocol$Companion;", "", "<init>", "()V", "", "name", "Lcom/github/encryptsl/ktor/http/URLProtocol;", "createOrDefault", "(Ljava/lang/String;)Lcom/github/encryptsl/ktor/http/URLProtocol;", "HTTP", "Lcom/github/encryptsl/ktor/http/URLProtocol;", "getHTTP", "()Lcom/github/encryptsl/ktor/http/URLProtocol;", "HTTPS", "getHTTPS", "WS", "getWS", "WSS", "getWSS", "SOCKS", "getSOCKS", "", "byName", "Ljava/util/Map;", "getByName", "()Ljava/util/Map;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URLProtocol getHTTP() {
            return HTTP;
        }

        @NotNull
        public final URLProtocol getHTTPS() {
            return HTTPS;
        }

        @NotNull
        public final URLProtocol getWS() {
            return WS;
        }

        @NotNull
        public final URLProtocol getWSS() {
            return WSS;
        }

        @NotNull
        public final URLProtocol getSOCKS() {
            return SOCKS;
        }

        @NotNull
        public final Map<String, URLProtocol> getByName() {
            return byName;
        }

        @NotNull
        public final URLProtocol createOrDefault(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            String it = TextKt.toLowerCasePreservingASCIIRules(name2);
            boolean bl = false;
            URLProtocol uRLProtocol = Companion.getByName().get(it);
            if (uRLProtocol == null) {
                uRLProtocol = new URLProtocol(it, 0);
            }
            return uRLProtocol;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

