/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.ktor.http;

import com.github.encryptsl.ktor.http.CodecsKt;
import com.github.encryptsl.ktor.http.Parameters;
import com.github.encryptsl.ktor.http.ParametersBuilder;
import com.github.encryptsl.ktor.http.ParametersKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\r\n\u0002\b\u0005\u001a3\u0010\b\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\t\u001a3\u0010\f\u001a\u00020\u000b*\u00020\n2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a;\u0010\u0011\u001a\u00020\u000b*\u00020\n2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a'\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a'\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018\u00a8\u0006\u001a"}, d2={"", "query", "", "startIndex", "limit", "", "decode", "Lcom/github/encryptsl/ktor/http/Parameters;", "parseQueryString", "(Ljava/lang/String;IIZ)Lcom/github/encryptsl/ktor/http/Parameters;", "Lcom/github/encryptsl/ktor/http/ParametersBuilder;", "", "parse", "(Lcom/github/encryptsl/ktor/http/ParametersBuilder;Ljava/lang/String;IIZ)V", "nameIndex", "equalIndex", "endIndex", "appendParam", "(Lcom/github/encryptsl/ktor/http/ParametersBuilder;Ljava/lang/String;IIIZ)V", "start", "end", "", "text", "trimEnd", "(IILjava/lang/CharSequence;)I", "trimStart", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Query.kt\nio/ktor/http/QueryKt\n+ 2 Parameters.kt\nio/ktor/http/Parameters$Companion\n*L\n1#1,97:1\n31#2:98\n*S KotlinDebug\n*F\n+ 1 Query.kt\nio/ktor/http/QueryKt\n*L\n16#1:98\n*E\n"})
public final class QueryKt {
    @NotNull
    public static final Parameters parseQueryString(@NotNull String query, int startIndex, int limit, boolean decode) {
        Parameters parameters;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (startIndex > StringsKt.getLastIndex((CharSequence)query)) {
            parameters = Parameters.Companion.getEmpty();
        } else {
            ParametersBuilder parametersBuilder;
            Parameters.Companion this_$iv = Parameters.Companion;
            boolean $i$f$build = false;
            ParametersBuilder $this$parseQueryString_u24lambda_u240 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
            boolean bl = false;
            QueryKt.parse($this$parseQueryString_u24lambda_u240, query, startIndex, limit, decode);
            parameters = parametersBuilder.build();
        }
        return parameters;
    }

    public static /* synthetic */ Parameters parseQueryString$default(String string, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 1000;
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return QueryKt.parseQueryString(string, n, n2, bl);
    }

    private static final void parse(ParametersBuilder $this$parse, String query, int startIndex, int limit, boolean decode) {
        int count2 = 0;
        int nameIndex = startIndex;
        int equalIndex = -1;
        int index = startIndex;
        int n = StringsKt.getLastIndex((CharSequence)query);
        if (index <= n) {
            while (true) {
                if (count2 == limit) {
                    return;
                }
                switch (query.charAt(index)) {
                    case '&': {
                        QueryKt.appendParam($this$parse, query, nameIndex, equalIndex, index, decode);
                        nameIndex = index + 1;
                        equalIndex = -1;
                        ++count2;
                        break;
                    }
                    case '=': {
                        if (equalIndex != -1) break;
                        equalIndex = index;
                    }
                }
                if (index == n) break;
                ++index;
            }
        }
        if (count2 == limit) {
            return;
        }
        QueryKt.appendParam($this$parse, query, nameIndex, equalIndex, query.length(), decode);
    }

    private static final void appendParam(ParametersBuilder $this$appendParam, String query, int nameIndex, int equalIndex, int endIndex, boolean decode) {
        if (equalIndex == -1) {
            int spaceNameIndex = QueryKt.trimStart(nameIndex, endIndex, query);
            int spaceEndIndex = QueryKt.trimEnd(spaceNameIndex, endIndex, query);
            if (spaceEndIndex > spaceNameIndex) {
                String string;
                if (decode) {
                    string = CodecsKt.decodeURLQueryComponent$default(query, spaceNameIndex, spaceEndIndex, false, null, 12, null);
                } else {
                    String string2 = query.substring(spaceNameIndex, spaceEndIndex);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                }
                String name2 = string;
                $this$appendParam.appendAll(name2, CollectionsKt.emptyList());
            }
            return;
        }
        int spaceNameIndex = QueryKt.trimStart(nameIndex, equalIndex, query);
        int spaceEqualIndex = QueryKt.trimEnd(spaceNameIndex, equalIndex, query);
        if (spaceEqualIndex > spaceNameIndex) {
            String string;
            String string3;
            if (decode) {
                string3 = CodecsKt.decodeURLQueryComponent$default(query, spaceNameIndex, spaceEqualIndex, false, null, 12, null);
            } else {
                String string4 = query.substring(spaceNameIndex, spaceEqualIndex);
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            }
            String name3 = string3;
            int spaceValueIndex = QueryKt.trimStart(equalIndex + 1, endIndex, query);
            int spaceEndIndex = QueryKt.trimEnd(spaceValueIndex, endIndex, query);
            if (decode) {
                string = CodecsKt.decodeURLQueryComponent$default(query, spaceValueIndex, spaceEndIndex, true, null, 8, null);
            } else {
                String string5 = query.substring(spaceValueIndex, spaceEndIndex);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            }
            String value = string;
            $this$appendParam.append(name3, value);
        }
    }

    private static final int trimEnd(int start, int end, CharSequence text) {
        int spaceIndex;
        for (spaceIndex = end; spaceIndex > start && CharsKt.isWhitespace((char)text.charAt(spaceIndex - 1)); --spaceIndex) {
        }
        return spaceIndex;
    }

    private static final int trimStart(int start, int end, CharSequence query) {
        int spaceIndex;
        for (spaceIndex = start; spaceIndex < end && CharsKt.isWhitespace((char)query.charAt(spaceIndex)); ++spaceIndex) {
        }
        return spaceIndex;
    }
}

