/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.hook.bettereconomy;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.common.hook.HookListener;
import com.github.encryptsl.lite.eco.utils.ClassUtil;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.hsgamer.bettereconomy.BetterEconomy;
import me.hsgamer.bettereconomy.holder.EconomyHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/bettereconomy/BetterEconomyHook;", "Lcom/github/encryptsl/lite/eco/common/hook/HookListener;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "economyHandler", "Lme/hsgamer/bettereconomy/holder/EconomyHolder;", "canRegister", "", "register", "", "unregister", "getBalance", "", "uuid", "Ljava/util/UUID;", "Companion", "LiteEco"})
public final class BetterEconomyHook
extends HookListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LiteEco liteEco;
    private EconomyHolder economyHandler;
    @NotNull
    public static final String PLUGIN_NAME = "BetterEconomy";

    public BetterEconomyHook(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        super(PLUGIN_NAME, "You can now export economy from plugin BetterEconomy to LiteEco with /eco database import BetterEconomy <your_currency>");
        this.liteEco = liteEco;
    }

    @Override
    public boolean canRegister() {
        return !this.getRegistered() && this.liteEco.getPluginManager().isPluginEnabled(PLUGIN_NAME);
    }

    @Override
    public void register() {
        if (Companion.isBetterEconomy()) {
            Object object = new BetterEconomy().get(EconomyHolder.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.economyHandler = (EconomyHolder)object;
        }
        this.setRegistered(true);
    }

    @Override
    public void unregister() {
    }

    public final double getBalance(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (!Companion.isBetterEconomy()) {
            throw new Exception("Plugin BetterEconomy missing !");
        }
        EconomyHolder economyHolder = this.economyHandler;
        if (economyHolder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"economyHandler");
            economyHolder = null;
        }
        return economyHolder.get(uuid);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/bettereconomy/BetterEconomyHook$Companion;", "", "<init>", "()V", "PLUGIN_NAME", "", "isBetterEconomy", "", "LiteEco"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isBetterEconomy() {
            return ClassUtil.INSTANCE.isValidClasspath("me.hsgamer.bettereconomy.BetterEconomy");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

