/*
 * Decompiled with CFR 0.152.
 */
package io.github.miniplaceholders.api.placeholder;

import io.github.miniplaceholders.api.placeholder.Placeholder;
import io.github.miniplaceholders.api.resolver.RelationalTagResolver;
import io.github.miniplaceholders.api.types.RelationalAudience;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record RelationalPlaceholder<A extends Audience>(@Nullable Class<A> targetClass, @TagPattern String key, String name, RelationalTagResolver<A> resolver) implements Placeholder
{
    public static <A extends Audience> RelationalPlaceholder<A> relational(@Nullable Class<A> targetClass, @TagPattern String key, String name, RelationalTagResolver<A> resolver) {
        return new RelationalPlaceholder<A>(targetClass, Objects.requireNonNull(key), name, Objects.requireNonNull(resolver));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Tag resolve(String name, ArgumentQueue arguments, Context ctx) {
        Object a;
        Object a2;
        Pointered targetRaw = ctx.target();
        if (targetRaw == null) {
            return null;
        }
        if (!(targetRaw instanceof RelationalAudience)) return null;
        RelationalAudience relationalAudience = (RelationalAudience)targetRaw;
        try {
            a = a2 = relationalAudience.audience();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object b = a2 = relationalAudience.relational();
        if (this.targetClass == null) {
            return this.resolveA(name, a, b, arguments, ctx);
        }
        @Nullable A audience = this.forwardingFilter((Pointered)a);
        if (audience == null) {
            return null;
        }
        @Nullable A relationalAudience2 = this.forwardingFilter((Pointered)b);
        if (relationalAudience2 != null) return this.resolveA(name, audience, relationalAudience2, arguments, ctx);
        return null;
    }

    @Nullable
    private Tag resolveA(String name, A audience, A relationalAudience, ArgumentQueue arguments, Context ctx) {
        return this.has(name) ? this.resolver.tag(audience, relationalAudience, arguments, ctx) : null;
    }

    @Nullable
    private A forwardingFilter(Pointered source) {
        if (this.targetClass.isInstance(source)) {
            return (A)((Audience)this.targetClass.cast(source));
        }
        if (source instanceof ForwardingAudience.Single) {
            ForwardingAudience.Single forward = (ForwardingAudience.Single)source;
            return this.forwardingFilter((Pointered)forward.audience());
        }
        return null;
    }

    public boolean has(@NotNull String name) {
        return this.key.equalsIgnoreCase(name);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationalPlaceholder)) {
            return false;
        }
        RelationalPlaceholder that = (RelationalPlaceholder)o;
        return that.key.equalsIgnoreCase(this.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key);
    }

    @Override
    public String toString() {
        return "RelationalPlaceholder{key='" + this.key + "'}";
    }
}

