/*
 * Decompiled with CFR 0.152.
 */
package io.github.miniplaceholders.api.placeholder;

import io.github.miniplaceholders.api.placeholder.Placeholder;
import io.github.miniplaceholders.api.resolver.AudienceTagResolver;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record AudiencePlaceholder<A extends Audience>(@Nullable Class<A> targetClass, @TagPattern String key, String name, AudienceTagResolver<A> resolver) implements Placeholder
{
    public static <A extends Audience> AudiencePlaceholder<A> single(@Nullable Class<A> targetClass, @TagPattern String key, String name, AudienceTagResolver<A> resolver) {
        return new AudiencePlaceholder<A>(targetClass, Objects.requireNonNull(key), Objects.requireNonNull(name), Objects.requireNonNull(resolver));
    }

    @Nullable
    public Tag resolve(String name, ArgumentQueue arguments, Context ctx) {
        Pointered targetRaw = ctx.target();
        if (targetRaw == null) {
            return null;
        }
        if (this.targetClass == null) {
            return this.resolveA(name, (Audience)targetRaw, arguments, ctx);
        }
        @Nullable A audience = this.forwardingFilter(targetRaw);
        if (audience == null) {
            return null;
        }
        return this.resolveA(name, audience, arguments, ctx);
    }

    @Nullable
    private Tag resolveA(String key, A audience, ArgumentQueue queue, Context ctx) {
        return this.has(key) ? this.resolver.tag(audience, queue, ctx) : null;
    }

    @Nullable
    private A forwardingFilter(Pointered source) {
        if (this.targetClass.isInstance(source)) {
            return (A)((Audience)this.targetClass.cast(source));
        }
        if (source instanceof ForwardingAudience.Single) {
            ForwardingAudience.Single forward = (ForwardingAudience.Single)source;
            return this.forwardingFilter((Pointered)forward.audience());
        }
        return null;
    }

    public boolean has(String name) {
        return this.key.equalsIgnoreCase(name);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudiencePlaceholder)) {
            return false;
        }
        AudiencePlaceholder that = (AudiencePlaceholder)o;
        return that.key.equalsIgnoreCase(this.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key);
    }

    @Override
    public String toString() {
        return "AudiencePlaceholder{key='" + this.key + "'}";
    }
}

