/*
 * Decompiled with CFR 0.152.
 */
package io.github.miniplaceholders.api;

import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.types.PlaceholderType;
import io.github.miniplaceholders.api.types.Platform;
import io.github.miniplaceholders.api.utils.Resolvers;
import io.github.miniplaceholders.connect.InternalPlatform;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MiniPlaceholders {
    static final Set<Expansion> expansions = ConcurrentHashMap.newKeySet();

    private MiniPlaceholders() {
    }

    @NotNull
    public static Platform platform() {
        return switch (InternalPlatform.platform()) {
            default -> throw new MatchException(null, null);
            case InternalPlatform.PAPER -> Platform.PAPER;
            case InternalPlatform.VELOCITY -> Platform.VELOCITY;
            case InternalPlatform.FABRIC -> Platform.FABRIC;
            case InternalPlatform.SPONGE -> Platform.SPONGE;
        };
    }

    @NotNull
    public static TagResolver globalPlaceholders() {
        TagResolver.Builder builder = TagResolver.builder();
        for (Expansion expansion2 : expansions) {
            TagResolver resolver = expansion2.globalPlaceholders();
            Resolvers.applyIfNotEmpty(resolver, builder);
        }
        return builder.build();
    }

    @NotNull
    public static TagResolver audiencePlaceholders() {
        TagResolver.Builder resolvers = TagResolver.builder();
        for (Expansion expansion2 : expansions) {
            TagResolver resolver = expansion2.audiencePlaceholders();
            Resolvers.applyIfNotEmpty(resolver, resolvers);
        }
        return resolvers.build();
    }

    @NotNull
    public static TagResolver relationalPlaceholders() {
        TagResolver.Builder builder = TagResolver.builder();
        for (Expansion expansion2 : expansions) {
            Resolvers.applyIfNotEmpty(expansion2.relationalPlaceholders(), builder);
        }
        return builder.build();
    }

    @NotNull
    public static TagResolver audienceGlobalPlaceholders() {
        TagResolver.Builder builder = TagResolver.builder();
        for (Expansion expansion2 : expansions) {
            Resolvers.applyIfNotEmpty(expansion2.audiencePlaceholders(), builder);
            Resolvers.applyIfNotEmpty(expansion2.globalPlaceholders(), builder);
        }
        return builder.build();
    }

    @NotNull
    public static TagResolver relationalGlobalPlaceholders() {
        TagResolver.Builder builder = TagResolver.builder();
        for (Expansion expansion2 : expansions) {
            Resolvers.applyIfNotEmpty(expansion2.audiencePlaceholders(), builder);
            Resolvers.applyIfNotEmpty(expansion2.relationalPlaceholders(), builder);
            Resolvers.applyIfNotEmpty(expansion2.globalPlaceholders(), builder);
        }
        return builder.build();
    }

    public static TagResolver placeholdersByType(PlaceholderType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PlaceholderType.GLOBAL -> MiniPlaceholders.globalPlaceholders();
            case PlaceholderType.AUDIENCE -> MiniPlaceholders.audiencePlaceholders();
            case PlaceholderType.RELATIONAL -> MiniPlaceholders.relationalPlaceholders();
        };
    }

    public static int expansionCount() {
        return expansions.size();
    }

    @Nullable
    public static Expansion expansionByName(@NotNull String name) {
        for (Expansion expansion2 : expansions) {
            if (!Objects.equals(expansion2.name(), name)) continue;
            return expansion2;
        }
        return null;
    }

    public static Collection<Expansion> expansionsAvailable() {
        return Collections.unmodifiableSet(expansions);
    }
}

