/*
 * Decompiled with CFR 0.152.
 */
package io.github.miniplaceholders.api;

import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.MiniPlaceholders;
import io.github.miniplaceholders.api.placeholder.AudiencePlaceholder;
import io.github.miniplaceholders.api.placeholder.GlobalPlaceholder;
import io.github.miniplaceholders.api.placeholder.Placeholder;
import io.github.miniplaceholders.api.placeholder.PlaceholderTagResolver;
import io.github.miniplaceholders.api.placeholder.RelationalPlaceholder;
import io.github.miniplaceholders.api.resolver.AudienceTagResolver;
import io.github.miniplaceholders.api.resolver.GlobalTagResolver;
import io.github.miniplaceholders.api.resolver.RelationalTagResolver;
import io.github.miniplaceholders.api.types.PlaceholderType;
import io.github.miniplaceholders.api.utils.Conditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.NullUnmarked;

@NullMarked
final class ExpansionImpl
implements Expansion {
    private static final AudiencePlaceholder<?>[] EMPTY_SINGLE_AUDIENCE = new AudiencePlaceholder[0];
    private static final RelationalPlaceholder<?>[] EMPTY_RELATIONAL_AUDIENCE = new RelationalPlaceholder[0];
    private static final GlobalPlaceholder[] EMPTY_GLOBAL_PLACEHOLDER = new GlobalPlaceholder[0];
    private final String name;
    private final PlaceholderTagResolver audiencePlaceholders;
    private final PlaceholderTagResolver relationalPlaceholders;
    private final PlaceholderTagResolver globalPlaceholders;
    @Nullable
    private final String author;
    @Nullable
    private final String version;

    ExpansionImpl(String expansionName, @Nullable Collection<AudiencePlaceholder<?>> audiencePlaceholders, @Nullable Collection<RelationalPlaceholder<?>> relationalPlaceholders, @Nullable Collection<GlobalPlaceholder> globalPlaceholders, @Nullable String author, @Nullable String version) {
        this.name = expansionName;
        this.audiencePlaceholders = audiencePlaceholders != null ? new PlaceholderTagResolver(audiencePlaceholders.toArray(EMPTY_SINGLE_AUDIENCE)) : PlaceholderTagResolver.EMPTY;
        this.relationalPlaceholders = relationalPlaceholders != null ? new PlaceholderTagResolver(relationalPlaceholders.toArray(EMPTY_RELATIONAL_AUDIENCE)) : PlaceholderTagResolver.EMPTY;
        this.globalPlaceholders = globalPlaceholders == null ? PlaceholderTagResolver.EMPTY : new PlaceholderTagResolver(globalPlaceholders.toArray(EMPTY_GLOBAL_PLACEHOLDER));
        this.author = author;
        this.version = version;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String author() {
        return this.author;
    }

    @Override
    @Nullable
    public String version() {
        return this.version;
    }

    @Override
    public TagResolver audiencePlaceholders() {
        if (this.audiencePlaceholders.placeholders().length == 0) {
            return TagResolver.empty();
        }
        return this.audiencePlaceholders;
    }

    @Override
    public TagResolver relationalPlaceholders() {
        if (this.relationalPlaceholders.placeholders().length == 0) {
            return TagResolver.empty();
        }
        return this.relationalPlaceholders;
    }

    @Override
    public TagResolver globalPlaceholders() {
        if (this.globalPlaceholders.placeholders().length == 0) {
            return TagResolver.empty();
        }
        return this.globalPlaceholders;
    }

    @Override
    public void register() {
        if (this.registered()) {
            throw new IllegalStateException("Expansion" + this.name + "is already registered");
        }
        MiniPlaceholders.expansions.add(this);
    }

    @Override
    public void unregister() {
        if (!this.registered()) {
            throw new IllegalStateException("Expansion " + this.name + " is not registered");
        }
        MiniPlaceholders.expansions.remove(this);
    }

    @Override
    public boolean registered() {
        return MiniPlaceholders.expansions.contains(this);
    }

    @Override
    public Collection<AudiencePlaceholder<?>> registeredAudiencePlaceholders() {
        return List.of((AudiencePlaceholder[])this.audiencePlaceholders.placeholders());
    }

    @Override
    public Collection<RelationalPlaceholder<?>> registeredRelationalPlaceholders() {
        return List.of((RelationalPlaceholder[])this.relationalPlaceholders.placeholders());
    }

    @Override
    @Nullable
    public AudiencePlaceholder<?> audiencePlaceholderByName(String name) {
        Objects.requireNonNull(name);
        for (Placeholder audiencePlaceholder : this.audiencePlaceholders.placeholders()) {
            if (!Objects.equals(audiencePlaceholder.name(), name)) continue;
            return (AudiencePlaceholder)audiencePlaceholder;
        }
        return null;
    }

    @Override
    @Nullable
    public RelationalPlaceholder<?> relationalPlaceholderByName(String name) {
        Objects.requireNonNull(name);
        for (Placeholder relationalPlaceholder : this.relationalPlaceholders.placeholders()) {
            if (!Objects.equals(relationalPlaceholder.name(), name)) continue;
            return (RelationalPlaceholder)relationalPlaceholder;
        }
        return null;
    }

    @Override
    @Nullable
    public GlobalPlaceholder globalPlaceholderByName(String name) {
        for (Placeholder placeholder : this.globalPlaceholders.placeholders()) {
            if (!Objects.equals(placeholder.name(), name)) continue;
            return (GlobalPlaceholder)placeholder;
        }
        return null;
    }

    @Override
    public TagResolver placeholdersByType(PlaceholderType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PlaceholderType.AUDIENCE -> this.audiencePlaceholders();
            case PlaceholderType.RELATIONAL -> this.relationalPlaceholders();
            case PlaceholderType.GLOBAL -> this.globalPlaceholders();
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expansion)) {
            return false;
        }
        Expansion that = (Expansion)o;
        return that.name().equalsIgnoreCase(this.name());
    }

    public int hashCode() {
        return Objects.hash(this.name.hashCode());
    }

    public String toString() {
        return "ExpansionImpl{name='" + this.name + "', audiencePlaceholders=" + String.valueOf(this.audiencePlaceholders) + ", relationalPlaceholders=" + String.valueOf(this.relationalPlaceholders) + ", globalPlaceholders=" + String.valueOf(this.globalPlaceholders) + ", author='" + this.author + "', version='" + this.version + "'}";
    }

    @NullUnmarked
    static final class Builder
    implements Expansion.Builder {
        private final String expansionName;
        @Subst(value="server")
        private final String expansionPrefix;
        private Set<AudiencePlaceholder<?>> audiencePlaceholders;
        private Set<RelationalPlaceholder<?>> relationalPlaceholders;
        private Set<GlobalPlaceholder> globalPlaceholders;
        private String author;
        private String version;

        Builder(@NotNull String name) {
            this.expansionName = Conditions.nonNullOrEmptyString(name, "Expansion name");
            this.expansionPrefix = name.toLowerCase(Locale.ROOT).concat("_");
        }

        @Override
        @NotNull
        public <A extends Audience> Builder audiencePlaceholder(@Nullable Class<A> targetClass, @Subst(value="name") @NotNull String key, @NotNull @NotNull AudienceTagResolver<@NotNull A> audiencePlaceholder) {
            Conditions.nonNullOrEmptyString(key, "Placeholder key");
            Objects.requireNonNull(audiencePlaceholder, "the audience placeholder cannot be null");
            if (this.audiencePlaceholders == null) {
                this.audiencePlaceholders = new HashSet();
            }
            this.audiencePlaceholders.add(AudiencePlaceholder.single(targetClass, this.expansionPrefix + key, key, audiencePlaceholder));
            return this;
        }

        @Override
        @NotNull
        public <A extends Audience> Builder relationalPlaceholder(@Nullable Class<A> targetClass, @Subst(value="relation") @NotNull String key, @NotNull @NotNull RelationalTagResolver<@NotNull A> relationalPlaceholder) {
            Conditions.nonNullOrEmptyString(key, "Placeholder key");
            Objects.requireNonNull(relationalPlaceholder, "the relational placeholder cannot be null");
            if (this.relationalPlaceholders == null) {
                this.relationalPlaceholders = new HashSet();
            }
            RelationalPlaceholder<A> relationalTag = RelationalPlaceholder.relational(targetClass, this.expansionPrefix + "rel_" + key, key, relationalPlaceholder);
            this.relationalPlaceholders.add(relationalTag);
            return this;
        }

        @Override
        @NotNull
        public Builder globalPlaceholder(@Subst(value="time") @NotNull String key, @NotNull GlobalTagResolver function) {
            Conditions.nonNullOrEmptyString(key, "Placeholder key");
            Objects.requireNonNull(function, "the global placeholder cannot be null");
            if (this.globalPlaceholders == null) {
                this.globalPlaceholders = new HashSet<GlobalPlaceholder>();
            }
            GlobalPlaceholder globalResolver = new GlobalPlaceholder(this.expansionPrefix + key, key, function);
            this.globalPlaceholders.add(globalResolver);
            return this;
        }

        @Override
        public @NotNull Expansion.Builder author(@Nullable String author) {
            this.author = author;
            return this;
        }

        @Override
        public @NotNull Expansion.Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @NotNull
        public Expansion build() {
            return new ExpansionImpl(this.expansionName, this.audiencePlaceholders, this.relationalPlaceholders, this.globalPlaceholders, this.author, this.version);
        }
    }
}

