/*
 * Decompiled with CFR 0.152.
 */
package io.github.miniplaceholders.api;

import io.github.miniplaceholders.api.ExpansionImpl;
import io.github.miniplaceholders.api.placeholder.AudiencePlaceholder;
import io.github.miniplaceholders.api.placeholder.GlobalPlaceholder;
import io.github.miniplaceholders.api.placeholder.RelationalPlaceholder;
import io.github.miniplaceholders.api.resolver.AudienceTagResolver;
import io.github.miniplaceholders.api.resolver.GlobalTagResolver;
import io.github.miniplaceholders.api.resolver.RelationalTagResolver;
import io.github.miniplaceholders.api.types.PlaceholderType;
import java.util.Collection;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed interface Expansion
permits ExpansionImpl {
    public String name();

    @Nullable
    public String author();

    @Nullable
    public String version();

    public TagResolver audiencePlaceholders();

    public TagResolver relationalPlaceholders();

    public TagResolver globalPlaceholders();

    public void register();

    public void unregister();

    public boolean registered();

    public Collection<AudiencePlaceholder<?>> registeredAudiencePlaceholders();

    public Collection<RelationalPlaceholder<?>> registeredRelationalPlaceholders();

    @Nullable
    public AudiencePlaceholder<?> audiencePlaceholderByName(String var1);

    @Nullable
    public RelationalPlaceholder<?> relationalPlaceholderByName(String var1);

    @Nullable
    public GlobalPlaceholder globalPlaceholderByName(String var1);

    default public boolean hasAudiencePlaceholder(String name) {
        return this.audiencePlaceholderByName(name) != null;
    }

    default public boolean hasRelationalPlaceholder(String name) {
        return this.relationalPlaceholderByName(name) != null;
    }

    default public boolean hasGlobalPlaceholder(String name) {
        return this.globalPlaceholderByName(name) != null;
    }

    public TagResolver placeholdersByType(PlaceholderType var1);

    public static Builder builder(String name) {
        return new ExpansionImpl.Builder(name);
    }

    @ApiStatus.Internal
    default public String shortToString() {
        StringBuilder builder = new StringBuilder(this.name()).append('[');
        if (this.author() != null) {
            builder.append("Author: ").append(this.author());
        }
        if (this.version() != null) {
            if (this.author() != null) {
                builder.append(", ");
            }
            builder.append("Version: ").append(this.version());
        }
        builder.append(']');
        return builder.toString();
    }

    @NullMarked
    public static interface Builder
    extends AbstractBuilder<Expansion> {
        public <A extends Audience> Builder audiencePlaceholder(@Nullable Class<A> var1, String var2, AudienceTagResolver<A> var3);

        default public Builder audiencePlaceholder(String key, AudienceTagResolver<Audience> audiencePlaceholder) {
            return this.audiencePlaceholder(null, key, audiencePlaceholder);
        }

        public <A extends Audience> Builder relationalPlaceholder(@Nullable Class<A> var1, String var2, RelationalTagResolver<A> var3);

        default public Builder relationalPlaceholder(String key, RelationalTagResolver<Audience> relationalResolver) {
            return this.relationalPlaceholder(null, key, relationalResolver);
        }

        public Builder globalPlaceholder(String var1, GlobalTagResolver var2);

        default public Builder globalPlaceholder(String key, Tag tag) {
            return this.globalPlaceholder(key, (ArgumentQueue queue, Context context) -> tag);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder author(@Nullable String var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder version(@Nullable String var1);
    }
}

